/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;

public final class ApproximateMatcher {
    private boolean ignoreCase = false;
    private boolean ignoreWhitespace = false;
    private boolean compareBackwards = false;
    private volatile int[][] buffer;
    private volatile int bufSize;

    public ApproximateMatcher() {
        this.buffer = null;
    }

    public ApproximateMatcher(int n) {
        this.bufSize = n + 1;
        this.buffer = new int[this.bufSize][this.bufSize];
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void setCompareBackwards(boolean bl) {
        this.compareBackwards = bl;
    }

    public String process(String string) {
        if (!(this.ignoreCase || this.compareBackwards || this.ignoreWhitespace)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (this.compareBackwards) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(string.length() - n - 1);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (!this.ignoreWhitespace || c != ' ' && c != '_') {
                    stringBuffer.append(c);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (!this.ignoreWhitespace || c != ' ' && c != '_') {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public final int match(String string, String string2) {
        return this.matchInternal(string, string2, Integer.MAX_VALUE);
    }

    public final boolean matches(String string, String string2, int n) {
        return this.matchInternal(string, string2, n) <= n;
    }

    public final boolean matches(String string, String string2, float f) {
        int n = string.length();
        int n2 = (int)(f * (float)n);
        int n3 = n - n2;
        return this.matches(string, string2, n3);
    }

    private int matchInternal(String string, String string2, int n) {
        if (string.length() <= string2.length()) {
            return this.matchInternalProcessed(string, string2, n);
        }
        return this.matchInternalProcessed(string2, string, n);
    }

    private int matchInternalProcessed(String string, String string2, int n) {
        int n2;
        int n3 = string.length();
        Assert.that(n3 <= (n2 = string2.length()));
        if (n <= 0) {
            return string.equals(string2) ? 0 : 1;
        }
        if (Math.abs(n3 - n2) > n) {
            return n + 1;
        }
        if (n3 == 0) {
            return n2;
        }
        int[][] nArray = this.buffer != null && this.bufSize >= Math.max(n3 + 1, n2 + 1) ? this.buffer : new int[n3 + 1][n2 + 1];
        int n4 = 2 * Math.min(n3 + 1, n2 + 1) - 1 + Math.min(n2 - n3, n);
        int n5 = 0;
        int n6 = 1;
        while (n6 < n4) {
            boolean bl;
            int n7 = n6 / 2 + n / 2;
            int n8 = n6 / 2 - n / 2;
            int n9 = n6 / 2 - n / 2;
            int n10 = n6 / 2 + n / 2;
            if (n6 % 2 != 0) {
                if (n % 2 == 0) {
                    ++n8;
                    ++n9;
                } else {
                    ++n7;
                    ++n10;
                }
            }
            if (n8 < 0 || n7 > n3) {
                n7 = Math.min(n6, n3);
                n8 = n6 - n7;
            }
            if (n9 < 0 || n10 > n2) {
                n10 = Math.min(n6, n2);
                n9 = n6 - n10;
            }
            Assert.that(n7 > 0, "Zero i1");
            Assert.that(n10 > 0, "Zero j2");
            nArray[n7][n8] = nArray[n7 - 1][n8] + 1;
            nArray[n9][n10] = nArray[n9][n10 - 1] + 1;
            if (n8 > 0) {
                nArray[n7][n8] = Math.min(nArray[n7][n8], nArray[n7 - 1][n8 - 1] + ApproximateMatcher.diff(string.charAt(n7 - 1), string2.charAt(n8 - 1)));
            }
            if (n9 > 0) {
                nArray[n9][n10] = Math.min(nArray[n9][n10], nArray[n9 - 1][n10 - 1] + ApproximateMatcher.diff(string.charAt(n9 - 1), string2.charAt(n10 - 1)));
            }
            boolean bl2 = bl = n6 % 2 != n % 2;
            if ((bl || n7 == n3) && n8 > 0) {
                nArray[n7][n8] = Math.min(nArray[n7][n8], nArray[n7][n8 - 1] + 1);
            }
            if (bl && n9 > 0) {
                nArray[n9][n10] = Math.min(nArray[n9][n10], nArray[n9 - 1][n10] + 1);
            }
            int n11 = Math.min(nArray[n7][n8], nArray[n9][n10]);
            int n12 = n7 - 1;
            int n13 = n8 + 1;
            while (n12 > n9 && n13 < n10) {
                int n14;
                nArray[n12][n13] = 1;
                nArray[n12][n13] = n14 = ApproximateMatcher.min3(nArray[n12 - 1][n13 - 1] + ApproximateMatcher.diff(string.charAt(n12 - 1), string2.charAt(n13 - 1)), nArray[n12 - 1][n13] + 1, nArray[n12][n13 - 1] + 1);
                n11 = Math.min(n11, n14);
                --n12;
                ++n13;
            }
            if (n11 > n && n5 > n) {
                return n11;
            }
            n5 = n11;
            ++n6;
        }
        return nArray[n3][n2];
    }

    private static int diff(char c, char c2) {
        if (c == c2) {
            return 0;
        }
        return 1;
    }

    private static int min3(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }
}

