/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

public class BandwidthThrottle {
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int _bytesPerTick;
    private int _availableBytes;
    private long _nextTickTime;

    public BandwidthThrottle(float f) {
        this.setRate(f);
    }

    public void setRate(float f) {
        this._bytesPerTick = (int)(f / 10.0f);
    }

    public synchronized int request(int n) {
        this.waitForBandwidth();
        int n2 = Math.min(n, this._availableBytes);
        this._availableBytes -= n2;
        return n2;
    }

    private void waitForBandwidth() {
        while (true) {
            long l = System.currentTimeMillis();
            this.updateWindow(l);
            if (this._availableBytes != 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(this._nextTickTime - l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateWindow(long l) {
        if (l >= this._nextTickTime) {
            this._availableBytes = this._bytesPerTick;
            this._nextTickTime = l + 100L;
        }
    }
}

