/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class BinaryHeap {
    private int currentSize;
    private Comparable[] array;
    private int maxSize;
    private boolean resizable = false;

    public BinaryHeap(int n) {
        this(n, false);
    }

    public BinaryHeap(int n, boolean bl) {
        this.resizable = bl;
        this.currentSize = 0;
        this.maxSize = n;
        this.array = new Comparable[n + 1];
    }

    public void clear() {
        this.currentSize = 0;
    }

    public BinaryHeap(Comparable[] comparableArray) {
        this.array = comparableArray;
        this.maxSize = this.currentSize = comparableArray.length - 1;
        this.buildHeap();
    }

    private boolean resize() {
        if (!this.isFull()) {
            return false;
        }
        if (!this.resizable) {
            return false;
        }
        this.maxSize = this.currentSize * 2;
        Comparable[] comparableArray = new Comparable[1 + this.maxSize];
        System.arraycopy(this.array, 1, comparableArray, 1, this.currentSize);
        this.array = comparableArray;
        return true;
    }

    private void heapify(int n) {
        int n2 = 2 * n;
        int n3 = 2 * n + 1;
        int n4 = n2 <= this.currentSize && this.array[n2].compareTo(this.array[n]) > 0 ? n2 : n;
        if (n3 <= this.currentSize && this.array[n3].compareTo(this.array[n4]) > 0) {
            n4 = n3;
        }
        if (n4 != n) {
            this.swap(n, n4);
            this.heapify(n4);
        }
    }

    private void buildHeap() {
        int n = this.currentSize / 2;
        while (n >= 1) {
            this.heapify(n);
            --n;
        }
    }

    private void swap(int n, int n2) {
        Comparable comparable = this.array[n];
        this.array[n] = this.array[n2];
        this.array[n2] = comparable;
    }

    public Comparable insert(Comparable comparable) {
        this.resize();
        Comparable comparable2 = null;
        if (this.currentSize < this.maxSize) {
            ++this.currentSize;
        } else {
            comparable2 = this.array[this.currentSize];
        }
        int n = this.currentSize;
        while (n > 1 && comparable.compareTo(this.array[n / 2]) > 0) {
            this.array[n] = this.array[n / 2];
            n /= 2;
        }
        this.array[n] = comparable;
        return comparable2;
    }

    public Comparable getMax() throws NoSuchElementException {
        if (this.currentSize < 1) {
            throw new NoSuchElementException();
        }
        return this.array[1];
    }

    public Comparable extractMax() throws NoSuchElementException {
        if (this.currentSize < 1) {
            throw new NoSuchElementException();
        }
        Comparable comparable = this.array[1];
        this.array[1] = this.array[this.currentSize--];
        this.heapify(1);
        return comparable;
    }

    public Iterator iterator() {
        return new BinaryHeapIterator();
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.currentSize == this.maxSize;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    class BinaryHeapIterator
    extends UnmodifiableIterator {
        int next = 1;

        BinaryHeapIterator() {
        }

        public boolean hasNext() {
            return this.next <= BinaryHeap.this.currentSize;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return BinaryHeap.this.array[this.next++];
        }
    }
}

