/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.sun.java.util.collections.Comparable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "2.8.5 Pro";
    private static final int _majorVersionNumber = CommonUtils.getMajorVersionNumberInternal("2.8.5 Pro");
    private static final int _minorVersionNumber = CommonUtils.getMinorVersionNumberInternal("2.8.5 Pro");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000orXP = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _isWindowsMe = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isJava118 = false;
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".limewire";
    private static final File CURRENT_DIRECTORY;
    private static boolean _isPro;
    private static boolean _windowsFilesMoved;
    private static final String[] USER_FILES;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$util$CommonUtils;

    private CommonUtils() {
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        return LIMEWIRE_VERSION;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    static int getMajorVersionNumberInternal(String string) {
        if (!string.equals(LIMEWIRE_VERSION)) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    static int getMinorVersionNumberInternal(String string) {
        if (!string.equals(LIMEWIRE_VERSION)) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(".");
                String string3 = string2.substring(0, n2);
                return new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }

    public static String getVendor() {
        return "LimeWire 2.8.5 Pro";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getOSVersion() {
        return PROPS.getProperty("os.version");
    }

    public static File getCurrentDirectory() {
        return CURRENT_DIRECTORY;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isSupernodeOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isMacClassic;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000orXP() {
        return _isWindowsNTor2000orXP;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isJaguarOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.2");
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isJava118() {
        return _isJava118;
    }

    public static boolean isJava13OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJava14OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    /*
     * Loose catch block
     */
    public static int copy(File file, int n, File file2) {
        int n2;
        block24: {
            IOException iOException2222;
            OutputStream outputStream;
            BufferedInputStream bufferedInputStream;
            block21: {
                n2 = n;
                boolean bl = true;
                bufferedInputStream = null;
                outputStream = null;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                while (n2 > 0) {
                    int n3 = ((InputStream)bufferedInputStream).read(byArray, 0, Math.min(1024, n2));
                    if (n3 == -1) break;
                    n2 -= n3;
                    outputStream.write(byArray, 0, n3);
                }
                Object var11_10 = null;
                if (bufferedInputStream == null) break block21;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block24;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    Object var11_11 = null;
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block24;
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException42222) {}
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var11_12 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return n - n2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return (long)CommonUtils.copy(file, (int)l, file2) == l;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static synchronized File getUserSettingsDir() {
        Object object;
        File file = new File(CommonUtils.getUserHomeDir(), LIMEWIRE_PREFS_DIR_NAME);
        if (CommonUtils.isMacOSX()) {
            object = new File(CommonUtils.getUserHomeDir(), "Library/Preferences");
            file = new File((File)object, "LimeWire");
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            object = "could not create preferences directory: " + file;
            throw new RuntimeException((String)object);
        }
        CommonUtils.moveWindowsFiles(file);
        return file;
    }

    private static synchronized void moveWindowsFiles(File file) {
        if (!CommonUtils.isWindows()) {
            return;
        }
        if (_windowsFilesMoved) {
            return;
        }
        File file2 = CommonUtils.getCurrentDirectory();
        int n = 0;
        while (n < USER_FILES.length) {
            File file3 = new File(file, USER_FILES[n]);
            File file4 = new File(file2, USER_FILES[n]);
            if (!file3.isFile()) {
                CommonUtils.copy(file4, file3);
            }
            ++n;
        }
        _windowsFilesMoved = true;
    }

    public static boolean isQuickTimeAvailable() {
        return CommonUtils.isMacOSX();
    }

    public static boolean isQuickTimeSupportedFormat(File file) {
        String string = file.getName();
        if (string.equals("") || string.length() < 4) {
            return false;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        String[] stringArray = new String[]{"mp3", "wav", "au", "aif", "aiff"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean canLaunchFileWithQuickTime(File file) {
        if (!CommonUtils.isQuickTimeAvailable()) {
            return false;
        }
        return CommonUtils.isQuickTimeSupportedFormat(file);
    }

    public static int compare(Object object, Object object2) {
        double d;
        int n = object == null && object2 == null ? 0 : (object == null ? -1 : (object2 == null ? 1 : (object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = CommonUtils.class$("java.lang.String")) : class$java$lang$String) ? CommonUtils.compareIgnoreCase((String)object, (String)object2) : (object instanceof Comparable ? ((Comparable)object).compareTo(object2) : (object instanceof Integer ? (Integer)object - (Integer)object2 : (object instanceof Boolean ? (object.equals(object2) ? 0 : (object.equals(Boolean.TRUE) ? 1 : -1)) : (object instanceof Double || object instanceof Float ? ((d = ((Number)object).doubleValue() - ((Number)object2).doubleValue()) > 0.0 ? 1 : (d < 0.0 ? -1 : 0)) : (object instanceof Number ? ((Number)object).intValue() - ((Number)object2).intValue() : 0))))))));
        return n;
    }

    private static int compareIgnoreCase(String string, String string2) {
        int n = 0;
        while (n < Math.min(string.length(), string2.length())) {
            char c;
            char c2 = Character.toLowerCase(string.charAt(n));
            int n2 = c2 - (c = Character.toLowerCase(string2.charAt(n)));
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return string.length() - string2.length();
    }

    public static void copyResourceFile(String string) {
        CommonUtils.copyResourceFile(string, null, false);
    }

    /*
     * Loose catch block
     */
    public static void copyResourceFile(String string, File file, boolean bl) {
        block19: {
            if (file == null) {
                file = new File(string);
            }
            if (!bl && file.exists()) {
                return;
            }
            String string2 = file.getParent();
            if (string2 == null) {
                return;
            }
            File file2 = new File(string2);
            if (!file2.isDirectory()) {
                file2.mkdirs();
            }
            ClassLoader classLoader = (class$com$limegroup$gnutella$util$CommonUtils == null ? (class$com$limegroup$gnutella$util$CommonUtils = CommonUtils.class$("com.limegroup.gnutella.util.CommonUtils")) : class$com$limegroup$gnutella$util$CommonUtils).getClassLoader();
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            InputStream inputStream = classLoader != null ? classLoader.getResource(string).openStream() : ClassLoader.getSystemResource(string).openStream();
            bufferedInputStream = new BufferedInputStream(inputStream, 2048);
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
            byte[] byArray = new byte[2048];
            int n = 0;
            do {
                n = bufferedInputStream.read(byArray, 0, 2048);
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            } while (n == 2048);
            Object var13_12 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                break block19;
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (Exception exception) {
                    file.delete();
                    Object var13_13 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CURRENT_DIRECTORY = new File(PROPS.getProperty("user.dir"));
        _isPro = false;
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = _isWindows = string.indexOf("windows") != -1;
        if (string.indexOf("windows nt") != -1 || string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindowsNTor2000orXP = true;
        }
        if (string.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (string.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("solaris") != -1;
        boolean bl2 = _isLinux = string.indexOf("linux") != -1;
        if (string.startsWith("mac os")) {
            if (string.endsWith("x")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
        if (CommonUtils.getJavaVersion().startsWith("1.1.8")) {
            _isJava118 = true;
        }
        if (!LIMEWIRE_VERSION.endsWith("Pro")) {
            HTTP_SERVER = "LimeWire/2.8.5 Pro";
        } else {
            HTTP_SERVER = "LimeWire/" + LIMEWIRE_VERSION.substring(0, LIMEWIRE_VERSION.length() - 4) + " (Pro)";
            _isPro = true;
        }
        _windowsFilesMoved = false;
        USER_FILES = new String[]{"limewire.props", "gnutella.net", "fileurns.cache"};
    }
}

