/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.ConcurrentModificationException;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.UnsupportedOperationException;

public final class IntBuffer
implements Cloneable {
    private final int size;
    private final int[] buf;
    private int head;
    private int tail;

    public IntBuffer(int n) {
        Assert.that(n >= 1);
        this.size = n + 1;
        this.buf = new int[n + 1];
        this.head = 0;
        this.tail = 0;
    }

    public IntBuffer(IntBuffer intBuffer) {
        this.size = intBuffer.size;
        this.head = intBuffer.head;
        this.tail = intBuffer.tail;
        this.buf = new int[intBuffer.buf.length];
        System.arraycopy(intBuffer.buf, 0, this.buf, 0, intBuffer.buf.length);
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int n) {
        if (n == 0) {
            return this.size - 1;
        }
        return n - 1;
    }

    private int increment(int n) {
        if (n == this.size - 1) {
            return 0;
        }
        return n + 1;
    }

    private int index(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        return (n + this.head) % this.size;
    }

    public int get(int n) throws IndexOutOfBoundsException {
        return this.buf[this.index(n)];
    }

    public void set(int n, int n2) throws IndexOutOfBoundsException {
        this.buf[this.index((int)n)] = n2;
    }

    public int add(int n) {
        return this.addFirst(n);
    }

    public int addFirst(int n) {
        int n2 = -1;
        if (this.isFull()) {
            n2 = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = n;
        return n2;
    }

    public int addLast(int n) {
        int n2 = -1;
        if (this.isFull()) {
            n2 = this.removeFirst();
        }
        this.buf[this.tail] = n;
        this.tail = this.increment(this.tail);
        return n2;
    }

    public boolean contains(int n) {
        IntBufferIterator intBufferIterator = this.iterator();
        while (intBufferIterator.hasNext()) {
            if (intBufferIterator.nextInt() != n) continue;
            return true;
        }
        return false;
    }

    public int first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public int last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public int removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int n = this.buf[this.head];
        this.buf[this.head] = -1;
        this.head = this.increment(this.head);
        return n;
    }

    public int removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        int n = this.buf[this.tail];
        this.buf[this.tail] = -1;
        return n;
    }

    public int remove(int n) throws IndexOutOfBoundsException {
        int n2 = this.get(n);
        int n3 = this.index(n);
        while (n3 != this.tail) {
            this.buf[n3] = this.buf[this.increment(n3)];
            n3 = this.increment(n3);
        }
        this.tail = this.decrement(this.tail);
        return n2;
    }

    public boolean removeValue(int n) {
        int n2 = 0;
        while (n2 < this.getSize()) {
            if (n == this.get(n2)) {
                this.remove(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean removeAll(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.getSize()) {
            if (n == this.get(n2)) {
                this.remove(n2);
                --n2;
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public IntBufferIterator iterator() {
        return new IntBufferIterator();
    }

    public Object clone() {
        return new IntBuffer(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        IntBufferIterator intBufferIterator = this.iterator();
        while (intBufferIterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(intBufferIterator.nextInt());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        IntBuffer intBuffer = new IntBuffer(10);
        int n = 0;
        while (n < 11) {
            intBuffer.addLast(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 11) {
            System.out.print(n2 + ": " + intBuffer.get(n2));
            ++n2;
        }
    }

    private class IntBufferIterator
    extends UnmodifiableIterator {
        int index;
        int oldHead;
        int oldTail;

        IntBufferIterator() {
            this.index = IntBuffer.this.head;
            this.oldHead = IntBuffer.this.head;
            this.oldTail = IntBuffer.this.tail;
        }

        public boolean hasNext() {
            this.ensureNoModifications();
            return this.index != IntBuffer.this.tail;
        }

        public Object next() throws NoSuchElementException {
            throw new UnsupportedOperationException();
        }

        public int nextInt() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = IntBuffer.this.buf[this.index];
            this.index = IntBuffer.this.increment(this.index);
            return n;
        }

        private void ensureNoModifications() {
            if (this.oldHead != IntBuffer.this.head || this.oldTail != IntBuffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

