/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.downloader.Interval;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

public class IntervalSet {
    private List intervals = new ArrayList();

    public void add(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Interval interval2 = null;
        Interval interval3 = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval4 = (Interval)iterator.next();
            if (n <= interval4.low && interval4.high <= n2) {
                iterator.remove();
                continue;
            }
            if (n <= interval4.high && interval4.low < n) {
                interval2 = interval4;
            }
            if (interval4.high == n - 1) {
                interval2 = interval4;
            }
            if (interval4.low <= n2 && interval4.high > n2) {
                interval3 = interval4;
            }
            if (n2 != interval4.low - 1) continue;
            interval3 = interval4;
        }
        if (interval2 == null && interval3 == null) {
            this.intervals.add(new Interval(n, n2));
        } else if (interval2 != null && interval3 != null) {
            this.intervals.remove(interval3);
            this.intervals.remove(interval2);
            this.intervals.add(new Interval(interval2.low, interval3.high));
        } else if (interval3 != null) {
            this.intervals.remove(interval3);
            this.intervals.add(new Interval(n, interval3.high));
        } else if (interval2 != null) {
            this.intervals.remove(interval2);
            this.intervals.add(new Interval(interval2.low, n2));
        }
    }

    public List getOverlapIntervals(Interval interval) {
        ArrayList arrayList = new ArrayList();
        long l = interval.high;
        long l2 = interval.low;
        long l3 = l - l2 + 1L;
        if (l2 >= l) {
            return arrayList;
        }
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval2 = (Interval)iterator.next();
            if (l2 <= (long)interval2.low && (long)interval2.high <= l) {
                arrayList.add(interval2);
                continue;
            }
            if (l2 <= (long)interval2.high && (long)interval2.low < l2) {
                arrayList.add(new Interval((int)l2, Math.min((int)l, interval2.high)));
            }
            if ((long)interval2.low > l || (long)interval2.high <= l) continue;
            arrayList.add(new Interval(Math.max(interval2.low, (int)l2), (int)l));
        }
        return arrayList;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return this.intervals;
    }

    public int getSize() {
        int n = 0;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            n += interval.high - interval.low + 1;
        }
        return n;
    }

    public void clear() {
        this.intervals.clear();
    }

    public Iterator getNeededIntervals(int n) {
        if (this.intervals == null || this.intervals.size() == 0) {
            Interval interval = new Interval(0, n - 1);
            ArrayList arrayList = new ArrayList();
            arrayList.add(interval);
            return arrayList.iterator();
        }
        Collections.sort(this.intervals, new IntervalComparator());
        ArrayList arrayList = new ArrayList();
        int n2 = -1;
        Interval interval = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            interval = (Interval)iterator.next();
            if (interval.low != 0 && n2 < interval.low) {
                arrayList.add(new Interval(n2 + 1, interval.low - 1));
            }
            n2 = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < n - 1) {
            arrayList.add(new Interval(interval.high + 1, n - 1));
        }
        return arrayList.iterator();
    }

    public static void main(String[] stringArray) {
        IntervalSet intervalSet = new IntervalSet();
        Interval interval = new Interval(40, 45);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 1, "add method broken");
        Assert.that(intervalSet.getSize() == 6, "getSize() broken");
        Iterator iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 39, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        interval = new Interval(35, 39);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 1, "lower boundry colating failed");
        interval = intervalSet.getIntervalAt(0);
        Assert.that(interval.high == 45, "lower boundry colating failed");
        Assert.that(interval.low == 35, "lower boundry colating failed");
        Assert.that(intervalSet.getSize() == 11, "getSize() broken");
        interval = new Interval(30, 37);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 1, "lower overlap colating failed");
        interval = intervalSet.getIntervalAt(0);
        Assert.that(interval.high == 45, "lower boundry colating failed");
        Assert.that(interval.low == 30, "lower boundry colating failed");
        interval = new Interval(20, 25);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 2, "lower non-overlap add failed");
        Assert.that(intervalSet.getSize() == 22, "getSize() broken");
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 19, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 26, "getNeededInterval broken");
        Assert.that(interval.high == 29, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        interval = new Interval(50, 60);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3, "upper non-overlap add failed");
        Assert.that(intervalSet.getSize() == 33, "getSize() broken");
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 19, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 26, "getNeededInterval broken");
        Assert.that(interval.high == 29, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 49, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 61, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        interval = new Interval(23, 32);
        List list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 2, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 23, "getOverlapIntervals broken");
        Assert.that(interval.high == 25, "getOverlapIntervals broken");
        interval = (Interval)list.get(1);
        Assert.that(interval.low == 30, "getOverlapIntervals broken");
        Assert.that(interval.high == 32, "getOverlapIntervals broken");
        interval = new Interval(25, 30);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 2, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 25, "getOverlapIntervals broken");
        Assert.that(interval.high == 25, "getOverlapIntervals broken");
        interval = (Interval)list.get(1);
        Assert.that(interval.low == 30, "getOverlapIntervals broken");
        Assert.that(interval.high == 30, "getOverlapIntervals broken");
        interval = new Interval(16, 23);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 1, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 20, "getOverlapIntervals broken");
        Assert.that(interval.high == 23, "getOverlapIntervals broken");
        interval = new Interval(16, 20);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 1, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 20, "getOverlapIntervals broken");
        Assert.that(interval.high == 20, "getOverlapIntervals broken");
        interval = new Interval(23, 29);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 1, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 23, "getOverlapIntervals broken");
        Assert.that(interval.high == 25, "getOverlapIntervals broken");
        interval = new Interval(25, 29);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 1, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 25, "getOverlapIntervals broken");
        Assert.that(interval.high == 25, "getOverlapIntervals broken");
        interval = new Interval(13, 19);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 0, "reported false overlap");
        interval = new Interval(26, 29);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 0, "reported false overlap");
        interval = new Interval(23, 53);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 3, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 23);
        Assert.that(interval.high == 25);
        interval = (Interval)list.get(1);
        Assert.that(interval.low == 30);
        Assert.that(interval.high == 45);
        interval = (Interval)list.get(2);
        Assert.that(interval.low == 50);
        Assert.that(interval.high == 53);
        interval = new Interval(16, 65);
        list = intervalSet.getOverlapIntervals(interval);
        Assert.that(list.size() == 3, "getOverlapIntervals broken");
        interval = (Interval)list.get(0);
        Assert.that(interval.low == 20);
        Assert.that(interval.high == 25);
        interval = (Interval)list.get(1);
        Assert.that(interval.low == 30);
        Assert.that(interval.high == 45);
        interval = (Interval)list.get(2);
        Assert.that(interval.low == 50);
        Assert.that(interval.high == 60);
        interval = new Interval(54, 70);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 50);
        Assert.that(interval.high == 70);
        Assert.that(intervalSet.getSize() == 43, "getSize() broken");
        interval = new Interval(71, 75);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 50);
        Assert.that(interval.high == 75);
        Assert.that(intervalSet.getSize() == 48, "getSize() broken");
        interval = new Interval(75, 80);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 50);
        Assert.that(interval.high == 80);
        interval = new Interval(15, 20);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 15);
        Assert.that(interval.high == 25);
        Assert.that(intervalSet.getSize() == 58, "getSize() broken");
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 14, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 26, "getNeededInterval broken");
        Assert.that(interval.high == 29, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 49, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 81, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        interval = new Interval(49, 81);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 49);
        Assert.that(interval.high == 81);
        Assert.that(intervalSet.getSize() == 60, "getSize() broken");
        interval = new Interval(55, 60);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 3);
        interval = intervalSet.getIntervalAt(2);
        Assert.that(interval.low == 49);
        Assert.that(interval.high == 81);
        interval = new Interval(26, 29);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 2);
        interval = intervalSet.getIntervalAt(1);
        Assert.that(interval.low == 15);
        Assert.that(interval.high == 45);
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 14, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 48, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 82, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        interval = new Interval(3, 5);
        intervalSet.add(interval);
        interval = new Interval(7, 9);
        intervalSet.add(interval);
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 2, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 6, "getNeededInterval broken");
        Assert.that(interval.high == 6, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 10, "getNeededInterval broken");
        Assert.that(interval.high == 14, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 46, "getNeededInterval broken");
        Assert.that(interval.high == 48, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 82, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        Assert.that(intervalSet.numIntervals() == 4);
        interval = new Interval(2, 17);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 2);
        interval = intervalSet.getIntervalAt(1);
        Assert.that(interval.low == 2);
        Assert.that(interval.high == 45);
        Assert.that(intervalSet.getSize() == 77, "getSize() broken");
        interval = new Interval(40, 50);
        intervalSet.add(interval);
        Assert.that(intervalSet.numIntervals() == 1);
        interval = intervalSet.getIntervalAt(0);
        Assert.that(interval.low == 2);
        Assert.that(interval.high == 81);
        Assert.that(intervalSet.getSize() == 80, "getSize() broken");
        iterator = intervalSet.getNeededIntervals(100);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 0, "getNeededInterval broken");
        Assert.that(interval.high == 1, "getNeededInterval broken");
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 82, "getNeededInterval broken");
        Assert.that(interval.high == 99, "getNeededInterval broken");
        intervalSet.clear();
        intervalSet.add(new Interval(0, 5));
        iterator = intervalSet.getNeededIntervals(6);
        Assert.that(!iterator.hasNext());
        intervalSet.add(new Interval(6, 10));
        iterator = intervalSet.getNeededIntervals(20);
        interval = (Interval)iterator.next();
        Assert.that(interval.low == 11);
        Assert.that(interval.high == 19);
        Assert.that(!iterator.hasNext());
    }

    public int numIntervals() {
        return this.intervals.size();
    }

    public Interval getIntervalAt(int n) {
        return (Interval)this.intervals.get(n);
    }

    private class IntervalComparator
    implements Comparator {
        private IntervalComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            return interval.low - interval2.low;
        }
    }
}

