/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.WindowsLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _getFileCreator;
    private static Method _openURL;
    private static Method _findApplication;
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")";
    private static WindowsLauncher _windowsLauncher;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    private Launcher() {
    }

    public static int openURL(String string) throws IOException {
        if (CommonUtils.isWindows()) {
            return Launcher.openURLWindows(string);
        }
        if (CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            Launcher.openURLMac(string);
        } else if (CommonUtils.isUnix()) {
            Launcher.launchFileUnix(string);
        }
        return -1;
    }

    private static int openURLWindows(String string) throws IOException {
        return new WindowsLauncher().openURL(string);
    }

    private static void openURLMac(String string) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] objectArray = new Object[]{string};
            _openURL.invoke(null, objectArray);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IOException();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException();
        }
    }

    public static int launchFile(File file) throws IOException, SecurityException {
        String string = file.getCanonicalPath();
        String string2 = string.toLowerCase();
        if (!(string2.endsWith(".exe") || string2.endsWith(".vbs") || string2.endsWith(".lnk") || string2.endsWith(".bat") || string2.endsWith(".sys") || string2.endsWith(".com"))) {
            if (CommonUtils.isWindows()) {
                return Launcher.launchFileWindows(string);
            }
            if (CommonUtils.isMacClassic()) {
                Launcher.launchFileMacClassic(file);
            } else if (CommonUtils.isMacOSX()) {
                Launcher.launchFileMacOSX(string);
            } else if (CommonUtils.isUnix()) {
                Launcher.launchFileUnix(string);
            }
        } else {
            throw new SecurityException();
        }
        return -1;
    }

    private static int launchFileWindows(String string) throws IOException {
        return new WindowsLauncher().launchFile(string);
    }

    private static void launchFileMacClassic(File file) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        File file2 = Launcher.getMacApplication(file);
        String string = file2.getCanonicalPath();
        String string2 = file.getCanonicalPath();
        try {
            Runtime.getRuntime().exec(new String[]{string, string2});
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void launchFileMacOSX(String string) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", string});
    }

    private static File getMacApplication(File file) throws IOException {
        try {
            Object object = _getFileCreator.invoke(null, file);
            Object object2 = _findApplication.invoke(null, object);
            return (File)object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException();
        }
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
            Class<?> clazz2 = Class.forName("com.apple.mrj.MRJOSType");
            String string = "getFileCreator";
            Class[] classArray = new Class[]{class$java$io$File == null ? (class$java$io$File = Launcher.class$("java.io.File")) : class$java$io$File};
            _getFileCreator = clazz.getDeclaredMethod(string, classArray);
            String string2 = "openURL";
            Class[] classArray2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Launcher.class$("java.lang.String")) : class$java$lang$String};
            _openURL = clazz.getDeclaredMethod(string2, classArray2);
            String string3 = "findApplication";
            Class[] classArray3 = new Class[]{clazz2};
            _findApplication = clazz.getDeclaredMethod(string3, classArray3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException();
        }
        catch (SecurityException securityException) {
            throw new IOException();
        }
    }

    private static void launchFileUnix(String string) throws IOException {
        String string2 = SettingsManager.instance().getBrowser();
        if (string2 == "netscape") {
            Launcher.launchFileUnixWithNetscape(string);
        } else {
            String[] stringArray = new String[]{string2, string};
            Process process = Runtime.getRuntime().exec(stringArray);
        }
    }

    private static void launchFileUnixWithNetscape(String string) throws IOException {
        String[] stringArray = new String[]{"netscape", NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START, string, NETSCAPE_OPEN_PARAMETER_END};
        Process process = Runtime.getRuntime().exec(stringArray);
        try {
            int n = process.waitFor();
            if (n != 0) {
                Runtime.getRuntime().exec(new String[]{"netscape", string});
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("InterruptedException launching browser: " + interruptedException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (CommonUtils.isWindows()) {
            _windowsLauncher = new WindowsLauncher();
        } else if (CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException iOException) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

