/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.BinaryHeap;
import com.limegroup.gnutella.util.SimpleTimerTask;
import com.sun.java.util.collections.Comparable;

public class SimpleTimer {
    private BinaryHeap _queue = new BinaryHeap(4, true);
    private static final int INITIAL_HEAP_SIZE = 4;
    private TimerRunnerThread _runner;
    private volatile boolean _isCancelled = false;
    private ActivityCallback _callback;

    public SimpleTimer(boolean bl) {
        this._runner = new TimerRunnerThread(bl);
        this._runner.start();
    }

    public void schedule(Runnable runnable, long l, long l2) throws IllegalStateException {
        if (this._isCancelled) {
            throw new IllegalStateException("Timer cancelled");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay: " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative period: " + l2);
        }
        long l3 = System.currentTimeMillis();
        ActivityCallback activityCallback = RouterService.getCallback();
        SimpleTimerTask simpleTimerTask = new SimpleTimerTask(runnable, l2, l3 + l, activityCallback);
        BinaryHeap binaryHeap = this._queue;
        synchronized (binaryHeap) {
            Comparable comparable = this._queue.insert(simpleTimerTask);
            Assert.that(comparable == null, "heap didn't resize");
            this._queue.notify();
        }
    }

    public void cancel() {
        this._isCancelled = true;
        this._runner.interrupt();
    }

    private class TimerRunnerThread
    extends Thread {
        TimerRunnerThread(boolean bl) {
            this.setDaemon(bl);
        }

        public void run() {
            while (true) {
                try {
                    if (SimpleTimer.this._isCancelled) break;
                    SimpleTimerTask simpleTimerTask = null;
                    try {
                        simpleTimerTask = this.waitForTask();
                        if (simpleTimerTask == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Assert.that(SimpleTimer.this._isCancelled, "Interrupted without cancel");
                        return;
                    }
                    simpleTimerTask.runAndReschedule();
                    BinaryHeap binaryHeap = SimpleTimer.this._queue;
                    synchronized (binaryHeap) {
                        SimpleTimer.this._queue.insert(simpleTimerTask);
                    }
                }
                catch (Throwable throwable) {
                    RouterService.error(throwable);
                    break;
                }
            }
        }

        private SimpleTimerTask waitForTask() throws InterruptedException {
            BinaryHeap binaryHeap = SimpleTimer.this._queue;
            synchronized (binaryHeap) {
                if (SimpleTimer.this._queue.isEmpty()) {
                    SimpleTimer.this._queue.wait();
                    SimpleTimerTask simpleTimerTask = null;
                    return simpleTimerTask;
                }
                SimpleTimerTask simpleTimerTask = (SimpleTimerTask)SimpleTimer.this._queue.getMax();
                long l = simpleTimerTask.timeUntilExecution();
                if (l > 0L) {
                    SimpleTimer.this._queue.wait(l);
                    SimpleTimerTask simpleTimerTask2 = null;
                    return simpleTimerTask2;
                }
                SimpleTimerTask simpleTimerTask3 = (SimpleTimerTask)SimpleTimer.this._queue.extractMax();
                Assert.that(simpleTimerTask3 == simpleTimerTask, "Queue modified without lock");
                SimpleTimerTask simpleTimerTask4 = simpleTimerTask;
                return simpleTimerTask4;
            }
        }
    }
}

