/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.TrieNode;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.NoSuchElementException;

public class Trie {
    private TrieNode root;
    private boolean ignoreCase = false;

    public Trie(boolean bl) {
        this.ignoreCase = bl;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    private final char canonicalCase(char c) {
        return this.ignoreCase ? Character.toLowerCase(c) : c;
    }

    private final String canonicalCase(String string) {
        if (this.ignoreCase) {
            return string.toLowerCase();
        }
        return string;
    }

    private final int match(String string, int n, int n2, String string2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < string2.length()) {
            if (n3 >= n2) {
                return n4;
            }
            if (this.canonicalCase(string.charAt(n3)) != string2.charAt(n4)) {
                return n4;
            }
            ++n3;
            ++n4;
        }
        return -1;
    }

    public Object add(String string, Object object) {
        Object object2;
        TrieNode trieNode = this.root;
        int n = 0;
        while (n < string.length()) {
            Object object3;
            object2 = trieNode.get(this.canonicalCase(string.charAt(n)));
            if (object2 == null) {
                object3 = new TrieNode(object);
                trieNode.put(this.canonicalCase(string.substring(n)), (TrieNode)object3);
                return null;
            }
            object3 = ((TrieEdge)object2).getLabel();
            int n2 = this.match(string, n, string.length(), (String)object3);
            Assert.that(n2 != 0, "Label didn't start with prefix[0].");
            if (n2 >= 0) {
                TrieNode trieNode2 = ((TrieEdge)object2).getChild();
                TrieNode trieNode3 = new TrieNode();
                String string2 = ((String)object3).substring(0, n2);
                String string3 = ((String)object3).substring(n2);
                String string4 = this.canonicalCase(string.substring(n + n2));
                if (string4.length() > 0) {
                    TrieNode trieNode4 = new TrieNode(object);
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.put(string4, trieNode4);
                } else {
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.setValue(object);
                }
                return null;
            }
            Assert.that(n2 == -1, "Bad return value from match: " + n);
            trieNode = ((TrieEdge)object2).getChild();
            n += ((String)object3).length();
        }
        object2 = trieNode.getValue();
        trieNode.setValue(object);
        return object2;
    }

    private TrieNode fetch(String string) {
        TrieNode trieNode = this.root;
        int n = 0;
        while (n < string.length()) {
            TrieEdge trieEdge = trieNode.get(this.canonicalCase(string.charAt(n)));
            if (trieEdge == null) {
                return null;
            }
            String string2 = trieEdge.getLabel();
            int n2 = this.match(string, n, string.length(), string2);
            Assert.that(n2 != 0, "Label didn't start with prefix[0].");
            if (n2 != -1) {
                return null;
            }
            n += string2.length();
            trieNode = trieEdge.getChild();
        }
        return trieNode;
    }

    public Object get(String string) {
        TrieNode trieNode = this.fetch(string);
        if (trieNode == null) {
            return null;
        }
        return trieNode.getValue();
    }

    public boolean remove(String string) {
        TrieNode trieNode = this.fetch(string);
        if (trieNode == null) {
            return false;
        }
        boolean bl = trieNode.getValue() != null;
        trieNode.setValue(null);
        return bl;
    }

    public Iterator getPrefixedBy(String string) {
        return this.getPrefixedBy(string, 0, string.length());
    }

    public Iterator getPrefixedBy(String string, int n, int n2) {
        TrieNode trieNode = this.root;
        int n3 = n;
        while (n3 < n2) {
            TrieEdge trieEdge = trieNode.get(this.canonicalCase(string.charAt(n3)));
            if (trieEdge == null) {
                return new EmptyIterator();
            }
            trieNode = trieEdge.getChild();
            String string2 = trieEdge.getLabel();
            int n4 = this.match(string, n3, n2, string2);
            Assert.that(n4 != 0, "Label didn't start with prefix[0].");
            if (n3 + n4 == n2) break;
            if (n4 >= 0) {
                trieNode = null;
                break;
            }
            Assert.that(n4 == -1, "Bad return value from match: " + n3);
            n3 += string2.length();
        }
        if (trieNode == null) {
            return new EmptyIterator();
        }
        return new ValueIterator(trieNode);
    }

    public void trim(Function function) throws IllegalArgumentException, ClassCastException {
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.root);
        while (!linkedList.isEmpty()) {
            Object object;
            TrieNode trieNode = (TrieNode)linkedList.removeLast();
            if (function != null && (object = trieNode.getValue()) != null) {
                trieNode.setValue(function.apply(object));
            }
            trieNode.trim();
            object = trieNode.children();
            while (object.hasNext()) {
                linkedList.addLast(object.next());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<root>");
        this.toStringHelper(this.root, stringBuffer, 1);
        return stringBuffer.toString();
    }

    private void toStringHelper(TrieNode trieNode, StringBuffer stringBuffer, int n) {
        if (trieNode.getValue() == null) {
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(" -> " + trieNode.getValue().toString() + "\n");
        }
        Iterator iterator = trieNode.labels();
        while (iterator.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("  ");
                ++n2;
            }
            String string = (String)iterator.next();
            stringBuffer.append(string);
            TrieNode trieNode2 = trieNode.get(string.charAt(0)).getChild();
            this.toStringHelper(trieNode2, stringBuffer, n + 1);
        }
    }

    private static class EmptyIterator
    extends UnmodifiableIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private class ValueIterator
    extends UnmodifiableIterator {
        private LinkedList queue = new LinkedList();

        ValueIterator(TrieNode trieNode) {
            this.queue.add(trieNode);
            this.advance();
        }

        private void advance() {
            while (this.queue.size() > 0) {
                TrieNode trieNode = (TrieNode)this.queue.getLast();
                Object object = trieNode.getValue();
                if (object != null) {
                    return;
                }
                this.queue.removeLast();
                Iterator iterator = trieNode.children();
                while (iterator.hasNext()) {
                    this.queue.addLast(iterator.next());
                }
            }
        }

        public boolean hasNext() {
            return this.queue.size() > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieNode trieNode = (TrieNode)this.queue.removeLast();
            Iterator iterator = trieNode.children();
            while (iterator.hasNext()) {
                this.queue.addLast(iterator.next());
            }
            this.advance();
            return trieNode.getValue();
        }
    }
}

