/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLOpener {
    private URL url;
    private URLConnection connection = null;
    private boolean timedOut = false;

    public URLOpener(URL uRL) {
        this.url = uRL;
    }

    public synchronized URLConnection connect(int n) throws IOException {
        Thread thread = new Thread(new URLOpenerThread());
        thread.start();
        Assert.that(this.connection == null, "Connection already established w.o. lock.");
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            if (this.connection == null) {
                this.timedOut = true;
            } else {
                URLOpener.close(this.connection);
            }
            throw new IOException();
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.timedOut = true;
        throw new IOException();
    }

    private static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    private class URLOpenerThread
    implements Runnable {
        private URLOpenerThread() {
        }

        public void run() {
            try {
                URLConnection uRLConnection = null;
                try {
                    uRLConnection = URLOpener.this.url.openConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                URLOpener uRLOpener = URLOpener.this;
                synchronized (uRLOpener) {
                    if (URLOpener.this.timedOut && uRLConnection != null) {
                        URLOpener.close(uRLConnection);
                    } else {
                        URLOpener.this.connection = uRLConnection;
                        URLOpener.this.notify();
                    }
                }
            }
            catch (Throwable throwable) {
                RouterService.error(throwable);
            }
        }
    }
}

