/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Weighable;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class WeightBasedHashMap {
    HashMap hashMap;
    private int numOfEntries = 0;
    private int maxEntries = 0;
    private long sumOfWeights = 0L;
    private HashSet probableRemovableEntries;
    private int maxProbableRemovableEntries = 0;

    public WeightBasedHashMap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.hashMap = new HashMap((int)((double)n / 0.75 + 10.0), 0.75f);
        this.maxEntries = n;
        this.probableRemovableEntries = new HashSet((int)((double)n / 0.75 + 5.0), 0.75f);
        this.maxProbableRemovableEntries = n / 10 + 1;
    }

    public boolean incrementWeight(Object object) {
        boolean bl = false;
        Weighable weighable = null;
        weighable = (Weighable)this.hashMap.get(object);
        if (weighable != null) {
            weighable.addWeight(1);
            ++this.sumOfWeights;
            return true;
        }
        return false;
    }

    public Weighable get(Object object) {
        return (Weighable)this.hashMap.get(object);
    }

    public Weighable remove(Object object) {
        Weighable weighable = (Weighable)this.hashMap.remove(object);
        if (weighable != null) {
            this.sumOfWeights -= (long)weighable.getWeight();
            --this.numOfEntries;
        }
        return weighable;
    }

    public Object add(Object object, Weighable weighable) {
        Object object2 = null;
        Weighable weighable2 = (Weighable)this.hashMap.put(object, weighable);
        this.sumOfWeights += (long)weighable.getWeight();
        if (weighable2 == null) {
            ++this.numOfEntries;
            if (this.numOfEntries > this.maxEntries) {
                object2 = this.removeSomeLessWeightedEntry();
            }
        } else {
            this.sumOfWeights -= (long)weighable2.getWeight();
        }
        return object2;
    }

    private Object removeSomeLessWeightedEntry() {
        if (this.probableRemovableEntries.size() <= 0) {
            this.fillProbableRemovableEntries();
        }
        Object object = this.probableRemovableEntries.iterator().next();
        Weighable weighable = (Weighable)this.hashMap.remove(object);
        this.probableRemovableEntries.remove(object);
        --this.numOfEntries;
        this.sumOfWeights -= (long)weighable.getWeight();
        return object;
    }

    public boolean isWeightedEnough(Weighable weighable) {
        int n = (int)(this.sumOfWeights / (long)this.numOfEntries);
        return weighable.getWeight() > n + 5;
    }

    public boolean isFull() {
        return this.numOfEntries >= this.maxEntries;
    }

    private void fillProbableRemovableEntries() {
        Iterator iterator = this.hashMap.entrySet().iterator();
        float f = this.sumOfWeights / (long)this.numOfEntries;
        int n = (int)(1.1 * (double)f) + 1;
        while (iterator.hasNext() && this.probableRemovableEntries.size() < this.maxProbableRemovableEntries) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Weighable weighable = (Weighable)entry.getValue();
            if (weighable.getWeight() >= n) continue;
            this.probableRemovableEntries.add(entry.getKey());
        }
    }

    public Set entrySet() {
        return this.hashMap.entrySet();
    }

    public String toString() {
        return this.hashMap.toString();
    }
}

