/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class LimeXMLDocumentHelper {
    private static final String SCHEMA_PRECEDE_STRING = "SchemaLocation";
    private static boolean debugOn = false;

    private LimeXMLDocumentHelper() {
    }

    public static List getDocuments(String string, int n) {
        int n2;
        ArrayList arrayList = new ArrayList();
        DOMParser dOMParser = new DOMParser();
        if (string == null || string.equals("")) {
            return arrayList;
        }
        int n3 = n2 = string.indexOf("<?xml");
        String string2 = "";
        boolean bl = false;
        while (!bl) {
            n2 = n3;
            if (n2 == -1) {
                bl = true;
                continue;
            }
            n3 = string.indexOf("<?xml", n2 + 1);
            string2 = n3 > 0 ? string.substring(n2, n3) : string.substring(n2);
            LimeXMLDocument[] limeXMLDocumentArray = new LimeXMLDocument[n];
            Element element = LimeXMLDocumentHelper.getDOMTree(dOMParser, string2);
            if (element == null) {
                arrayList.add(null);
                continue;
            }
            List list = LimeXMLUtils.getElements(element.getChildNodes());
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                LimeXMLDocument limeXMLDocument;
                Node node = (Node)list.get(n5);
                String string3 = LimeXMLDocumentHelper.getAttributeValue(node, "index");
                int n6 = Integer.parseInt(string3);
                limeXMLDocumentArray[n6] = limeXMLDocument = new LimeXMLDocument(node, element);
                ++n5;
            }
            arrayList.add(limeXMLDocumentArray);
        }
        return arrayList;
    }

    public static List breakSingleSchemaAggregateString(String string) {
        Element element = LimeXMLDocumentHelper.getDOMTree(new DOMParser(), string);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List list = LimeXMLUtils.getElements(element.getChildNodes());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.add(new LimeXMLDocument(node, element));
        }
        return arrayList;
    }

    public static String getAggregateString(Response[] responseArray) {
        Serializable serializable;
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < responseArray.length) {
            serializable = responseArray[n].getDocument();
            if (serializable != null) {
                LimeXMLDocumentHelper.aggregateResponse(hashMap, (LimeXMLDocument)serializable, n);
            }
            ++n;
        }
        serializable = new StringBuffer();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            String string = ((StringBuffer)iterator.next()).toString();
            int n2 = string.indexOf("<", 2);
            int n3 = string.indexOf(" ", n2);
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("</");
            ((StringBuffer)serializable).append(string.substring(n2 + 1, n3));
            ((StringBuffer)serializable).append(">");
        }
        return ((StringBuffer)serializable).toString();
    }

    private static String getSchemaURI(String string) {
        String string2 = null;
        int n = string.indexOf(SCHEMA_PRECEDE_STRING);
        if (n > -1) {
            n += SCHEMA_PRECEDE_STRING.length();
            if (string.charAt(n++) == '=' && (string.charAt(n) == '\'' || string.charAt(n) == '\"')) {
                char c = string.charAt(n);
                int n2 = ++n;
                while (string.charAt(n) != c) {
                    ++n;
                }
                int n3 = n;
                string2 = string.substring(n2, n3);
            }
        }
        return string2;
    }

    private static void aggregateResponse(HashMap hashMap, LimeXMLDocument limeXMLDocument, int n) {
        if (limeXMLDocument == null) {
            return;
        }
        String string = limeXMLDocument.getSchemaURI();
        StringBuffer stringBuffer = (StringBuffer)hashMap.get(string);
        if (stringBuffer == null) {
            String string2 = null;
            try {
                string2 = limeXMLDocument.getXMLString();
            }
            catch (Exception exception) {
                return;
            }
            if (string2 == null || string2.equals("")) {
                return;
            }
            int n2 = (string2 = string2.substring(0, string2.lastIndexOf("<"))).indexOf("<");
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            n2 = string2.indexOf("<", n2 + 1);
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            n2 = string2.indexOf("<", n2 + 1);
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            int n3 = string2.indexOf(">", n2 + 1);
            int n4 = string2.lastIndexOf("/", n3 - 1);
            n2 = n4 != -1 && n2 < n4 && n4 < n3 ? (string2.substring(n4 + 1, n3).trim().equals("") ? n4 : n3) : n3;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2);
            StringBuffer stringBuffer2 = new StringBuffer(string3.length() + 15 + string4.length());
            stringBuffer2.append(string3);
            stringBuffer2.append(" index=\"");
            stringBuffer2.append(n);
            stringBuffer2.append("\" ");
            stringBuffer2.append(string4);
            hashMap.put(string, stringBuffer2);
        } else {
            String string5 = null;
            try {
                string5 = limeXMLDocument.getXMLString();
            }
            catch (Exception exception) {
                return;
            }
            int n5 = string5.indexOf("<");
            n5 = string5.indexOf("<", n5 + 1);
            n5 = string5.indexOf("<", n5 + 1);
            int n6 = string5.lastIndexOf("<");
            string5 = string5.substring(n5, n6);
            int n7 = string5.indexOf(">");
            int n8 = string5.lastIndexOf("/", n7 - 1);
            if (n8 != -1 && n8 < n7 && string5.substring(n8 + 1, n7).trim().equals("")) {
                n7 = n8;
            }
            String string6 = string5.substring(0, n7);
            String string7 = string5.substring(n7);
            stringBuffer.append(string6);
            stringBuffer.append(" index=\"");
            stringBuffer.append(n);
            stringBuffer.append("\" ");
            stringBuffer.append(string7);
            hashMap.put(string, stringBuffer);
        }
    }

    private static Element getDOMTree(DOMParser dOMParser, String string) {
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = null;
        try {
            dOMParser.parse(inputSource);
        }
        catch (Exception exception) {
            return null;
        }
        document = dOMParser.getDocument();
        Element element = document.getDocumentElement();
        return element;
    }

    private static String getAttributeValue(Node node, String string) {
        String string2 = string.toLowerCase();
        List list = LimeXMLUtils.getAttributes(node.getAttributes());
        String string3 = "";
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = (Node)list.get(n2);
            String string4 = node2.getNodeName().toLowerCase();
            if (string4.indexOf(string2) >= 0) {
                string3 = node2.getNodeValue();
            }
            ++n2;
        }
        return string3;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }
}

