/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Properties;

public class LimeXMLProperties {
    public static final long DEFAULT_NONFILE_INDEX = 0xFFFFFFFFL;
    private Properties _properties = new Properties();
    private static LimeXMLProperties _instance = new LimeXMLProperties();
    private static final String XML_PROPS_FILENAME = "xml.props";
    private static final String XML_SCHEMA_DIR = "XML_SCHEMA_DIR";
    private static final String XML_IMAGES_DIR = "XML_IMAGES_DIR";
    private static final String XML_DOCS_DIR = "XML_DOCS_DIR";
    private static final String XML_DISPLAY_PROPS_DIR = "XML_DISPLAY_PROPS_DIR";
    private static final String XML_SCHEMA_DIR_DEF = "xml" + File.separator + "schemas" + File.separator;
    private static final String XML_IMAGES_DIR_DEF = "xml" + File.separator + "misc" + File.separator;
    private static final String XML_DOCS_DIR_DEF = "xml" + File.separator + "data" + File.separator;
    private static final String XML_DISPLAY_PROPS_DIR_DEF = "xml" + File.separator + "display" + File.separator;
    private static final String MAX_JDBC_XML_RESULTS = "MAX_JDBC_XML_RESULTS";
    private static final int MAX_JDBC_XML_RESULTS_DEF = 250;
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE = "SCHEMA_TRANSFORMATION_DATA_MAP_FILE";
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE_DEF = "STDataMap.dat";
    private static final String HTTP_MAPPING_FILE = "HTTP_MAPPING_FILE";
    private static final String HTTP_MAPPING_FILE_DEF = "httpmapping.xml";
    private static final String DATABASE_MAPPING_FILE = "DATABASE_MAPPING_FILE";
    private static final String DATABASE_MAPPING_FILE_DEF = "databasemapping.xml";
    private static final String FEED_PROPS_FILE = "FEED_PROPS_FILE";
    private static final String FEED_PROPS_FILE_DEF = "feedreceiverprops.xml";
    private static final String DIRECT_MAPPING_FILE = "DIRECT_MAPPING_FILE";
    private static final String DIRECT_MAPPING_FILE_DEF = "directmapping.xml";
    private static final String KEYWORD_LIST_FILE = "KEYWORD_LIST_FILE";
    private static final String KEYWORD_LIST_FILE_DEF = "keywords.list";
    private static final String NUM_QUERY_DISPATCHER_THREADS = "NUM_QUERY_DISPATCHER_THREADS";
    private static final int NUM_QUERY_DISPATCHER_THREADS_DEF = 50;
    private static final String USER_MAP_FILE = "USER_MAP_FILE";
    private static final String USER_MAP_FILE_DEF = "UserMap.dat";

    private LimeXMLProperties() {
        this.loadProperties();
    }

    protected void loadProperties() {
        try {
            this._properties.load(new FileInputStream(this.getPath() + XML_PROPS_FILENAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LimeXMLProperties instance() {
        return _instance;
    }

    public String getXMLSchemaDir() {
        String string = this._properties.getProperty(XML_SCHEMA_DIR, XML_SCHEMA_DIR_DEF);
        return this.getPath() + string;
    }

    public String getXMLImagesDir() {
        String string = this._properties.getProperty(XML_IMAGES_DIR, XML_IMAGES_DIR_DEF);
        return this.getPath() + string;
    }

    public String getXMLDocsDir() {
        String string = this._properties.getProperty(XML_DOCS_DIR, XML_DOCS_DIR_DEF);
        return this.getPath() + string;
    }

    public String getXMLDisplayPropsDir() {
        String string = this._properties.getProperty(XML_DISPLAY_PROPS_DIR, XML_DISPLAY_PROPS_DIR_DEF);
        return this.getPath() + string;
    }

    public File[] getAllXMLSchemaFiles() {
        File file = new File(this.getXMLSchemaDir());
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xsd");
            }
        });
        if (stringArray == null || stringArray.length == 0) {
            return new File[0];
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            fileArray[n2] = new File(file, stringArray[n2]);
            ++n2;
        }
        return fileArray;
    }

    public String getUserMapFile() {
        String string = this._properties.getProperty(USER_MAP_FILE, USER_MAP_FILE_DEF);
        return this.getPath() + string;
    }

    public String getPath() {
        String string = System.getProperty("LIME_HOME");
        if (string == null || string.trim().equals("")) {
            File file = new File(CommonUtils.getCurrentDirectory(), "lib");
            String string2 = file.getAbsolutePath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            return string2;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string + "lib" + File.separator;
    }
}

