/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.mp3.ID3Editor;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.xml.sax.SAXException;

public class LimeXMLReplyCollection {
    private String schemaURI;
    private HashMap mainMap;
    public boolean audio = false;
    private File dataFile = null;
    private MetaFileManager metaFileManager = null;
    private Object writeLock = new Object();
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    private static final boolean debugOn = false;

    public LimeXMLReplyCollection(Map map, String string, FileManager fileManager, boolean bl) {
        this.schemaURI = string;
        this.metaFileManager = (MetaFileManager)fileManager;
        this.audio = bl;
        LimeXMLReplyCollection.debug("LimeXMLReplyCollection(): entered with audio = " + bl);
        MapSerializer mapSerializer = this.initializeMapSerializer(string);
        Map map2 = mapSerializer == null ? new HashMap() : mapSerializer.getMap();
        Map map3 = map;
        synchronized (map3) {
            Iterator iterator = map.keySet().iterator();
            ID3Reader iD3Reader = new ID3Reader();
            while (iterator != null && iterator.hasNext()) {
                LimeXMLDocument limeXMLDocument;
                String string2;
                block19: {
                    File file = (File)iterator.next();
                    string2 = (String)map.get(file);
                    Object object = map2.get(string2);
                    limeXMLDocument = null;
                    if (object != null && object instanceof LimeXMLDocument) {
                        limeXMLDocument = (LimeXMLDocument)object;
                    } else {
                        String string3 = (String)object;
                        if (bl && LimeXMLUtils.isMP3File(file)) {
                            boolean bl2 = string3 == null || string3.equals("");
                            try {
                                if (!bl2) {
                                    try {
                                        String string4 = iD3Reader.readDocument(file, bl2);
                                        String string5 = this.joinAudioXMLStrings(string4, string3);
                                        limeXMLDocument = new LimeXMLDocument(string5);
                                    }
                                    catch (RuntimeException runtimeException) {
                                        limeXMLDocument = iD3Reader.readDocument(file);
                                    }
                                } else {
                                    limeXMLDocument = iD3Reader.readDocument(file);
                                }
                                break block19;
                            }
                            catch (SAXException sAXException) {
                                continue;
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                            catch (SchemaNotFoundException schemaNotFoundException) {
                                continue;
                            }
                        }
                        try {
                            if (string3 == null || string3.equals("")) continue;
                            limeXMLDocument = new LimeXMLDocument(string3);
                        }
                        catch (SAXException sAXException) {
                            continue;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        catch (SchemaNotFoundException schemaNotFoundException) {
                            continue;
                        }
                    }
                }
                this.addReply(string2, limeXMLDocument);
            }
            this.checkDocuments(map, false);
        }
        LimeXMLReplyCollection.debug("LimeXMLReplyCollection(): returning.");
        this.write();
    }

    protected List getKeyWords() {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = this.mainMap.values().iterator();
            while (iterator.hasNext()) {
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
                arrayList.addAll(limeXMLDocument.getKeyWords());
            }
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private void checkDocuments(Map var1_1, boolean var2_2) {
        var3_3 = var1_1;
        synchronized (var3_3) {
            var4_4 = var1_1.keySet().iterator();
            if (var4_4 != null) ** GOTO lbl33
            return;
lbl-1000:
            // 1 sources

            {
                var5_5 = (File)var4_4.next();
                var6_6 = (String)var1_1.get(var5_5);
                var8_8 = this.mainMap;
                synchronized (var8_8) {
                    var7_7 = (LimeXMLDocument)this.mainMap.get(var6_6);
                }
                if (var7_7 == null) continue;
                var9_9 = null;
                try {
                    var9_9 = var5_5.getCanonicalPath();
                }
                catch (IOException var10_12) {
                    var11_13 = this.mainMap;
                    synchronized (var11_13) {
                        this.mainMap.remove(var6_6);
                    }
                }
                var10_11 = var7_7.getIdentifier();
                if (var9_9.equalsIgnoreCase(var10_11)) continue;
                var7_7.setIdentifier(var9_9);
lbl33:
                // 4 sources

                ** while (var4_4.hasNext())
            }
lbl34:
            // 1 sources

        }
    }

    private MapSerializer initializeMapSerializer(String string) {
        String string2 = LimeXMLSchema.getDisplayString(string) + ".sxml";
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string3 = limeXMLProperties.getXMLDocsDir();
        this.dataFile = new File(string3, string2);
        this.mainMap = new HashMap();
        MapSerializer mapSerializer = null;
        try {
            mapSerializer = new MapSerializer(this.dataFile);
        }
        catch (Exception exception) {
            LimeXMLReplyCollection.debug(exception);
        }
        return mapSerializer;
    }

    private String joinAudioXMLStrings(String string, String string2) throws RuntimeException {
        int n = string2.lastIndexOf("></audio>");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n);
        return string3 + string + string4;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void addReply(String string, LimeXMLDocument limeXMLDocument) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            this.mainMap.put(string, limeXMLDocument);
        }
    }

    void addReplyWithCommit(File file, String string, LimeXMLDocument limeXMLDocument) {
        String string2 = "";
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        limeXMLDocument.setIdentifier(string2);
        this.addReply(string, limeXMLDocument);
        try {
            if (this.audio) {
                this.mp3ToDisk(file.getCanonicalPath());
            } else {
                this.write();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCount() {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            int n = this.mainMap.size();
            return n;
        }
    }

    public LimeXMLDocument getDocForHash(String string) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)this.mainMap.get(string);
            return limeXMLDocument;
        }
    }

    public List getCollectionList() {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = this.mainMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Object object2 = this.mainMap.get(object);
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    public List getMatchingReplies(LimeXMLDocument limeXMLDocument) {
        ArrayList arrayList;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = this.mainMap.keySet().iterator();
            arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                LimeXMLDocument limeXMLDocument2 = (LimeXMLDocument)this.mainMap.get(object);
                boolean bl = LimeXMLUtils.match(limeXMLDocument2, limeXMLDocument);
                if (!bl) continue;
                arrayList.add(limeXMLDocument2);
                bl = false;
            }
        }
        return arrayList;
    }

    public LimeXMLDocument replaceDoc(Object object, LimeXMLDocument limeXMLDocument) {
        LimeXMLDocument limeXMLDocument2 = null;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            limeXMLDocument2 = (LimeXMLDocument)this.mainMap.get(object);
            this.mainMap.put(object, limeXMLDocument);
        }
        return limeXMLDocument2;
    }

    public boolean removeDoc(String string) {
        boolean bl;
        Object object;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            object = this.mainMap.remove(string);
            bl = object != null;
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.write();
        }
        if (!bl2 && bl) {
            HashMap hashMap2 = this.mainMap;
            synchronized (hashMap2) {
                this.mainMap.put(string, object);
            }
        } else if (bl && bl2) {
            return true;
        }
        return false;
    }

    public boolean write() {
        Object object;
        Object object2;
        if (this.dataFile == null) {
            object2 = LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml";
            object = LimeXMLProperties.instance();
            String string = ((LimeXMLProperties)object).getXMLDocsDir();
            this.dataFile = new File(string, (String)object2);
        }
        try {
            object2 = new MapSerializer(this.dataFile, this.mainMap);
            object = this.writeLock;
            synchronized (object) {
                ((MapSerializer)object2).commit();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public int mp3ToDisk(String string) {
        boolean bl = false;
        int n = -1;
        Object[] objectArray = this.ripMP3XML(string);
        if (((Boolean)objectArray[0]).booleanValue()) {
            n = this.commitID3Data(string, (String)objectArray[1], (ID3Editor)objectArray[2]);
        }
        if (!(bl = this.write())) {
            return 2;
        }
        return n;
    }

    private Object[] ripMP3XML(String string) {
        Object[] objectArray = new Object[3];
        objectArray[0] = new Boolean(false);
        if (!LimeXMLUtils.isMP3File(string)) {
            return objectArray;
        }
        try {
            String string2 = new String(LimeXMLUtils.hashFile(new File(string)));
            LimeXMLDocument limeXMLDocument = null;
            HashMap hashMap = this.mainMap;
            synchronized (hashMap) {
                limeXMLDocument = (LimeXMLDocument)this.mainMap.get(string2);
            }
            String string3 = limeXMLDocument.getIdentifier();
            if (LimeXMLUtils.isMP3File(string)) {
                ID3Editor iD3Editor = new ID3Editor();
                String string4 = limeXMLDocument.getXMLStringWithIdentifier();
                iD3Editor.removeID3Tags(string4);
                objectArray[0] = new Boolean(true);
                objectArray[1] = string2;
                objectArray[2] = iD3Editor;
            }
            return objectArray;
        }
        catch (Exception exception) {
            return objectArray;
        }
    }

    private int commitID3Data(String string, String string2, ID3Editor iD3Editor) {
        int n = iD3Editor.writeID3DataToDisk(string);
        if (n != 0) {
            return n;
        }
        File file = new File(string);
        String string3 = null;
        try {
            string3 = new String(LimeXMLUtils.hashFile(file));
        }
        catch (Exception exception) {
            n = 11;
            return n;
        }
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Object object = this.mainMap.remove(string2);
            this.mainMap.put(string3, object);
        }
        this.metaFileManager.writeToMap(file, string3);
        this.metaFileManager.handleChangedHash(string2, string3, this);
        return n;
    }

    public static void testMapSerializer(String[] stringArray) throws Exception {
        MapSerializer mapSerializer = new MapSerializer(new File(stringArray[0]));
        Map map = mapSerializer.getMap();
        System.out.println("" + map);
        int n = 1;
        while (n < stringArray.length) {
            try {
                map.put(stringArray[n], stringArray[n + 1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n += 2;
        }
        mapSerializer.commit();
    }

    private static final void debug(String string) {
    }

    private static final void debug(Exception exception) {
    }

    public static void main(String[] stringArray) throws Exception {
        LimeXMLReplyCollection.testMapSerializer(stringArray);
    }

    public static class MapSerializer {
        private File _backingStoreFile;
        private Map _hashMap;

        public MapSerializer(File file) throws Exception {
            this._backingStoreFile = file;
            if (this._backingStoreFile.isDirectory()) {
                throw new Exception();
            }
            if (this._backingStoreFile.exists()) {
                this.deserializeFromFile();
            } else {
                this._hashMap = new HashMap();
            }
        }

        public MapSerializer(File file, Map map) throws Exception {
            this._backingStoreFile = file;
            this._hashMap = map;
            if (this._backingStoreFile.isDirectory()) {
                throw new Exception();
            }
        }

        private void deserializeFromFile() throws Exception {
            FileInputStream fileInputStream = new FileInputStream(this._backingStoreFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this._hashMap = (Map)objectInputStream.readObject();
            fileInputStream.close();
        }

        public void commit() throws Exception {
            this.serializeToFile();
        }

        private void serializeToFile() throws Exception {
            FileOutputStream fileOutputStream = new FileOutputStream(this._backingStoreFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Map map = this._hashMap;
            synchronized (map) {
                objectOutputStream.writeObject(this._hashMap);
            }
            fileOutputStream.close();
        }

        public Map getMap() {
            return this._hashMap;
        }
    }
}

