/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLUtils {
    private static final double MATCHING_RATE = 0.9;
    private static final String C_HEADER_BEGIN = "{";
    private static final String C_HEADER_END = "}";
    private static final String C_HEADER_NONE_VAL = "plaintext";
    private static final String C_HEADER_ZLIB_VAL = "deflate";
    private static final String C_HEADER_GZIP_VAL = "gzip";
    private static final String COMPRESS_HEADER_ZLIB = "{deflate}";
    private static final String COMPRESS_HEADER_GZIP = "{gzip}";
    private static final String COMPRESS_HEADER_NONE = "{plaintext}";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZLIB = 2;
    private static final int NUM_BYTES_TO_HASH = 100;
    private static final int NUM_TOTAL_HASH = 300;
    private static final byte[] hashBytes = new byte[100];

    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null) continue;
            stringBuffer.append(string + "\n");
        }
        return new InputSource(new StringReader(stringBuffer.toString()));
    }

    public static Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = LimeXMLUtils.getInputSource(file);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public static String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static List getElements(NodeList nodeList) {
        ArrayList arrayList = new ArrayList(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                arrayList.add(node);
            }
            ++n;
        }
        return arrayList;
    }

    public static List getAttributes(NamedNodeMap namedNodeMap) {
        ArrayList arrayList = new ArrayList(namedNodeMap.getLength());
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            arrayList.add(node);
            ++n;
        }
        return arrayList;
    }

    public static String getText(NodeList nodeList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    break;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        stringBuffer.append('&');
                        break;
                    }
                    if (node.getNodeName().equals("lt")) {
                        stringBuffer.append('<');
                        break;
                    }
                    if (node.getNodeName().equals("gt")) {
                        stringBuffer.append('>');
                        break;
                    }
                    if (node.getNodeName().equals("apos")) {
                        stringBuffer.append('\'');
                        break;
                    }
                    if (!node.getNodeName().equals("quot")) break;
                    stringBuffer.append('\"');
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                writer.write("&lt;");
            } else if (c == '>') {
                writer.write("&gt;");
            } else if (c == '&') {
                writer.write("&amp;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\"') {
                writer.write("&quot;");
            } else {
                writer.write(c);
            }
            ++n;
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static LimeXMLDocument[] convertAggregateToParts(LimeXMLDocument limeXMLDocument) {
        return null;
    }

    public static boolean match(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        if (limeXMLDocument == null) {
            return false;
        }
        List list = limeXMLDocument2.getNameValueList();
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            NameValue nameValue = (NameValue)list.get(n2);
            String string = nameValue.getName();
            arrayList.add(string);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            block15: {
                String string = (String)arrayList.get(n5);
                String string2 = limeXMLDocument2.getValue(string);
                if (string2 == null) {
                    try {
                        Assert.that(false, "Bad query. String = " + limeXMLDocument2.getXMLString());
                    }
                    catch (SchemaNotFoundException schemaNotFoundException) {
                        Assert.that(false, "SchemaNotFound? That's impossible!");
                    }
                }
                if (!string2.equals("")) {
                    String string3 = limeXMLDocument.getValue(string);
                    if (string3 == null || string3.equals("")) {
                        ++n4;
                    } else {
                        try {
                            double d = new Double(string3);
                            double d2 = new Double(string2);
                            if (d == d2) {
                                ++n3;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string4 = string2.toLowerCase();
                            String string5 = string3.toLowerCase();
                            if (!string5.startsWith(string4)) break block15;
                            ++n3;
                        }
                    }
                }
            }
            ++n5;
        }
        double d = n;
        double d3 = n3;
        double d4 = n4;
        if (n > 1) {
            if ((d4 + d3) / d < 0.9) {
                return false;
            }
            return n3 > 0;
        }
        if (n == 1) {
            return !(d3 / d < 1.0);
        }
        return false;
    }

    public static boolean isMP3File(String string) {
        boolean bl = false;
        if ((string = string.toLowerCase()).endsWith(".mp3")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMP3File(File file) {
        boolean bl = LimeXMLUtils.isMP3File(file.getName());
        return bl;
    }

    public static String encodeXML(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(38) == -1 && string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(39) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFirst(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1);
        String string4 = string2 + string3;
        return string4.replace('_', ' ');
    }

    public static String processColName(String string) {
        int n;
        boolean bl = true;
        if (string.endsWith("__")) {
            string = string.substring(0, string.lastIndexOf("__"));
        }
        if ((n = string.lastIndexOf("__")) == -1) {
            return string;
        }
        return LimeXMLUtils.capitalizeFirst(string.substring(n += "__".length()));
    }

    public static byte[] compress(byte[] byArray) {
        byte[] byArray2 = null;
        if (LimeXMLUtils.shouldCompress(byArray)) {
            byArray2 = LimeXMLUtils.compressZLIB(byArray);
        }
        byte[] byArray3 = null;
        if (byArray2 != null) {
            byArray3 = new byte[COMPRESS_HEADER_ZLIB.length() + byArray2.length];
            System.arraycopy(COMPRESS_HEADER_ZLIB.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_ZLIB.length());
            System.arraycopy(byArray2, 0, byArray3, COMPRESS_HEADER_ZLIB.length(), byArray2.length);
        } else {
            byArray3 = new byte[COMPRESS_HEADER_NONE.length() + byArray.length];
            System.arraycopy(COMPRESS_HEADER_NONE.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_NONE.length());
            System.arraycopy(byArray, 0, byArray3, COMPRESS_HEADER_NONE.length(), byArray.length);
        }
        return byArray3;
    }

    private static boolean shouldCompress(byte[] byArray) {
        return byArray.length >= 1000;
    }

    private static byte[] compressZLIB(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            ((FilterOutputStream)deflaterOutputStream).flush();
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    private static byte[] compressGZIP(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ((DeflaterOutputStream)gZIPOutputStream).write(byArray, 0, byArray.length);
            ((FilterOutputStream)gZIPOutputStream).flush();
            gZIPOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    public static byte[] uncompress(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[]{};
        String string = new String(byArray, 0, C_HEADER_BEGIN.length());
        if (string.equals(C_HEADER_BEGIN)) {
            boolean bl = false;
            int n = 0;
            while (n < byArray.length && !bl) {
                if (byArray[n] == 125) {
                    bl = true;
                }
                ++n;
            }
            string = new String(byArray, 1, n - 1 - 1);
            int n2 = LimeXMLUtils.getCompressionType(string);
            if (n2 == 0) {
                byArray2 = new byte[byArray.length - (string.length() + 2)];
                System.arraycopy(byArray, n, byArray2, 0, byArray.length - (string.length() + 2));
            } else if (n2 == 1) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_GZIP.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_GZIP.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_GZIP.length());
                byArray2 = LimeXMLUtils.uncompressGZIP(byArray2);
            } else if (n2 == 2) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_ZLIB.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_ZLIB.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_ZLIB.length());
                byArray2 = LimeXMLUtils.uncompressZLIB(byArray2);
            }
        } else {
            return byArray;
        }
        return byArray2;
    }

    private static int getCompressionType(String string) {
        String string2 = string.trim();
        if (string2.equals("") || string2.equalsIgnoreCase(C_HEADER_NONE_VAL)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(C_HEADER_GZIP_VAL)) {
            return 1;
        }
        if (string2.equalsIgnoreCase(C_HEADER_ZLIB_VAL)) {
            return 2;
        }
        return -1;
    }

    private static byte[] uncompressGZIP(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = gZIPInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] uncompressZLIB(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inflaterInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int max3(int n, int n2, int n3) {
        return LimeXMLUtils.max2(LimeXMLUtils.max2(n, n2), n3);
    }

    private static int max2(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private static void clearHashBytes() {
        int n = 0;
        while (n < 100) {
            LimeXMLUtils.hashBytes[n] = 0;
            ++n;
        }
    }

    public static byte[] hashFile(File file) throws Exception {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            long l = file.length();
            if (l < 300L) {
                int n = 0;
                do {
                    LimeXMLUtils.clearHashBytes();
                    n = fileInputStream.read(hashBytes);
                    messageDigest.update(hashBytes);
                    if (file.length() == l) continue;
                    throw new Exception();
                } while (n == 100);
            } else {
                long l2 = l / 3L;
                LimeXMLUtils.clearHashBytes();
                int n = fileInputStream.read(hashBytes);
                messageDigest.update(hashBytes);
                if (file.length() != l) {
                    throw new Exception();
                }
                LimeXMLUtils.clearHashBytes();
                fileInputStream.skip(l2 - 100L);
                n = fileInputStream.read(hashBytes);
                messageDigest.update(hashBytes);
                if (file.length() != l) {
                    throw new Exception();
                }
                LimeXMLUtils.clearHashBytes();
                fileInputStream.skip(file.length() - (l2 + 100L) - 100L);
                n = fileInputStream.read(hashBytes);
                messageDigest.update(hashBytes);
                if (file.length() != l) {
                    throw new Exception();
                }
            }
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new Exception(exception.toString());
        }
        return byArray;
    }

    public static boolean notValidXML(String string) {
        return string == null || string.trim().equals("") || !string.startsWith("<?xml version=\"1.0\"?>");
    }
}

