/*
 * Decompiled with CFR 0.152.
 */
package dk.mikkle.network.ip.multicast;

import dk.mikkle.network.ip.multicast.SwingWorker;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

class MulticastListener
extends SwingWorker {
    private InetAddress m_Group;
    private int m_Port;
    private MulticastSocket m_MCS;
    private DatagramPacket m_DP;
    private byte[] m_Buffer = new byte[1500];
    private long m_TotalPackets = 0L;
    private long m_TotalBytes = 0L;
    private boolean m_Halt = false;

    public MulticastListener(String in_Group, int in_Port) {
        this.m_Port = in_Port;
        try {
            this.m_Group = InetAddress.getByName(in_Group);
            this.m_MCS = new MulticastSocket(this.m_Port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object construct() {
        try {
            this.m_MCS.setSoTimeout(0);
            this.m_DP = new DatagramPacket(this.m_Buffer, this.m_Buffer.length);
            this.m_MCS.joinGroup(this.m_Group);
            do {
                this.m_MCS.receive(this.m_DP);
                ++this.m_TotalPackets;
                this.m_TotalBytes += (long)this.m_DP.getLength();
            } while (!this.m_Halt);
            this.m_MCS.leaveGroup(this.m_Group);
            this.m_MCS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public long getTotalPackets() {
        return this.m_TotalPackets;
    }

    public long getTotalBytes() {
        return this.m_TotalBytes;
    }

    public void halt() {
        this.m_Halt = true;
    }
}

