/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.ChatPane;
import xnap.gui.ChatServerCellRenderer;
import xnap.gui.HistoryTextField;
import xnap.gui.XNapFrame;
import xnap.gui.action.MenuAction;
import xnap.gui.event.PopupListener;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.gui.table.ChatUserTableModel;
import xnap.gui.table.UserTableModel;
import xnap.net.IChannel;
import xnap.net.IUser;
import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.util.Formatter;
import xnap.util.Preferences;

public class ChatSubPanel
extends AbstractPanel
implements ChannelListener,
PropertyChangeListener,
TableModelListener,
UserSupport {
    private static Logger logger = Logger.getLogger(class$Lxnap$gui$ChatSubPanel != null ? class$Lxnap$gui$ChatSubPanel : (class$Lxnap$gui$ChatSubPanel = ChatSubPanel.class$("xnap.gui.ChatSubPanel")));
    protected ChatPane cpChat;
    protected JTable jta;
    protected JTextField jteInput;
    protected Preferences prefs = Preferences.getInstance();
    protected UserTableModel utm;
    protected JSplitPane jspH;
    protected JLabel jlTopic;
    protected JLabel jlServer;
    protected JCheckBox jcbShowChatMsgTime;
    private JCheckBox jcbBeepOnChatMessage;
    private JCheckBox jcbBlinkOnChatMessage;
    private JCheckBox jcbServerIsSticky;
    private JComboBox jcbServers;
    private ChangeTopicAction acChangeTopic = new ChangeTopicAction();
    private SendAction acSend = new SendAction();
    private MenuAction acMenu = new MenuAction(new UserMenu(this));
    protected IChannel channel;
    protected LinkedList channels = new LinkedList();
    protected ChatUserTableModel.IUserVector userData = new ChatUserTableModel.IUserVector();
    private static /* synthetic */ Class class$Lxnap$gui$ChatSubPanel;

    private final void initialize() {
        this.cpChat = new ChatPane();
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(5));
        this.jlTopic = new JLabel(this.channel.getTopic());
        box.add(this.jlTopic);
        box.add(Box.createGlue());
        this.jcbShowChatMsgTime = new JCheckBox(XNap.tr("Timestamp Messages"), this.prefs.getShowChatMsgTime());
        box.add(this.jcbShowChatMsgTime);
        this.jcbBeepOnChatMessage = new JCheckBox(XNap.tr("Beep"), this.prefs.getBeepOnChatMessage());
        box.add(this.jcbBeepOnChatMessage);
        this.jcbBlinkOnChatMessage = new JCheckBox(XNap.tr("Blink"), false);
        box.add(this.jcbBlinkOnChatMessage);
        JPanel jPanel = new JPanel(new BorderLayout());
        UserMenu userMenu = new UserMenu(this, true);
        this.utm = new ChatUserTableModel("user", this.userData);
        this.jta = this.utm.createJTable();
        this.utm.addTableModelListener(this);
        PopupListener popupListener = new PopupListener(userMenu);
        this.jta.addMouseListener(popupListener);
        this.jta.setShowGrid(false);
        JScrollPane jScrollPane = new JScrollPane(this.jta);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jlServer = new JLabel(" ");
        jPanel2.add((Component)this.jlServer, "Center");
        jPanel.add((Component)jPanel2, "South");
        Box box2 = new Box(0);
        this.jteInput = new HistoryTextField("", 20);
        this.jteInput.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acSend);
        box2.add(this.jteInput);
        box2.add(Box.createHorizontalStrut(5));
        this.jcbServerIsSticky = new JCheckBox(XNap.tr("Sticky"));
        box2.add(this.jcbServerIsSticky);
        this.jcbServers = new JComboBox();
        this.jcbServers.setRenderer(new ChatServerCellRenderer());
        box2.add(this.jcbServers);
        box2.add(new JButton(this.acSend));
        this.jspH = new JSplitPane(1);
        this.jspH.add((Component)this.cpChat, "left");
        this.jspH.add((Component)jPanel, "right");
        this.jspH.setDividerLocation(this.prefs.getChatVerticalDividerLocation());
        this.jspH.setResizeWeight(1.0);
        this.jspH.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)box, "North");
        this.add((Component)this.jspH, "Center");
        this.add((Component)box2, "South");
    }

    public void addChannel(IChannel iChannel) {
        IUser[] iUserArray = iChannel.getUsers();
        int n = 0;
        while (n < iUserArray.length) {
            this.userData.add(iUserArray[n]);
            ++n;
        }
        iChannel.addChannelListener(this);
        this.channels.add(iChannel);
        if (this.prefs.getPrintServerNotificationsInChatWindow()) {
            this.println(MessageFormat.format(XNap.tr("connected to {0}"), iChannel.getServer().getName()), "chatInfo");
        }
        Runnable runnable = new Runnable(this, iChannel){
            private final /* synthetic */ ChatSubPanel this$0;
            private final /* synthetic */ IChannel val$channel;

            public final void run() {
                ChatSubPanel.access$0(this.this$0).addItem(this.val$channel);
                ChatSubPanel.access$1(this.this$0).setEnabled(ChatSubPanel.access$1(this.this$0).isEnabled() | this.val$channel.canChangeTopic());
                this.this$0.updateStatus();
            }
            {
                this.val$channel = iChannel;
                this.this$0 = chatSubPanel;
                this.constructor$0(chatSubPanel);
            }

            private final void constructor$0(ChatSubPanel chatSubPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void channelClosed(ChannelEvent channelEvent) {
        this.removeChannel(this.channel);
    }

    public void removeChannel(IChannel iChannel) {
        IUser[] iUserArray = iChannel.getUsers();
        int n = 0;
        while (n < iUserArray.length) {
            this.userData.remove(iUserArray[n]);
            ++n;
        }
        this.channels.remove(iChannel);
        if (this.prefs.getPrintServerNotificationsInChatWindow()) {
            this.println(MessageFormat.format(XNap.tr("disconnected from {0}"), iChannel.getServer().getName()), "chatInfo");
        }
        Runnable runnable = new Runnable(this, iChannel){
            private final /* synthetic */ ChatSubPanel this$0;
            private final /* synthetic */ IChannel val$channel;

            public final void run() {
                ChatSubPanel.access$0(this.this$0).removeItem(this.val$channel);
                this.this$0.updateStatus();
            }
            {
                this.val$channel = iChannel;
                this.this$0 = chatSubPanel;
                this.constructor$0(chatSubPanel);
            }

            private final void constructor$0(ChatSubPanel chatSubPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    public IChannel[] getChannels() {
        IChannel[] iChannelArray = new IChannel[this.channels.size()];
        System.arraycopy(this.channels.toArray(), 0, iChannelArray, 0, iChannelArray.length);
        return iChannelArray;
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.acChangeTopic, null, this.acMenu};
    }

    public IUser[] getUsers() {
        int[] nArray = this.jta.getSelectedRows();
        IUser[] iUserArray = new IUser[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            iUserArray[n] = this.utm.get(nArray[n]);
            ++n;
        }
        return iUserArray;
    }

    public Iterator iterator() {
        return this.channels.iterator();
    }

    public void messageReceived(ChannelEvent channelEvent) {
        IUser iUser = channelEvent.getUser();
        if (!(channelEvent.getMessageType() != 1 || iUser != null && iUser.isChatIgnored())) {
            this.printTimeStamp();
            this.print(iUser.getName(), "chatUser");
            this.printServer(channelEvent);
            this.print("> " + channelEvent.getMessage(), "chatMessage");
            this.println("", "chatMessage", !this.itsMe(iUser));
            if (!this.jcbServerIsSticky.isSelected()) {
                this.jcbServers.setSelectedItem(channelEvent.getSource());
            }
        } else if (channelEvent.getMessageType() == 3) {
            this.println(channelEvent.getMessage(), "chatError");
        } else if (channelEvent.getMessageType() == 2) {
            this.println(channelEvent.getMessage(), "chatInfo");
        }
        if (this.jcbBlinkOnChatMessage.isSelected()) {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ ChatSubPanel this$0;

                public final void run() {
                    XNapFrame.getInstance().chatBlink();
                }
                {
                    this.this$0 = chatSubPanel;
                    this.constructor$0(chatSubPanel);
                }

                private final void constructor$0(ChatSubPanel chatSubPanel) {
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void print(String string, String string2) {
        this.cpChat.appendLater(string, string2);
    }

    public void println(String string, String string2, boolean bl) {
        if (string.length() > 0) {
            this.printTimeStamp();
        }
        this.print(string + "\n", string2);
        if (bl && this.jcbBeepOnChatMessage.isSelected()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void println(String string, String string2) {
        this.println(string, string2, true);
    }

    public void printTimeStamp() {
        if (this.jcbShowChatMsgTime.isSelected()) {
            this.cpChat.appendLater("[" + Formatter.shortDate() + "]  ", "chatMessage");
        }
    }

    public void printServer(ChannelEvent channelEvent) {
        if (this.prefs.getAppendServerNameToChatUser()) {
            IChannel iChannel = (IChannel)channelEvent.getSource();
            this.print("@" + iChannel.getServer().getName(), "chatUser");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.prefs.setChatVerticalDividerLocation(this.jspH.getDividerLocation());
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateStatus();
    }

    public void updateStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.channels.size() == 0) {
            stringBuffer.append("(");
            stringBuffer.append(XNap.tr("disconnected"));
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.channels.size());
            stringBuffer.append(" ");
            stringBuffer.append(XNap.tr("Servers"));
        }
        stringBuffer.append(" / ");
        stringBuffer.append(this.utm.getRowCount());
        stringBuffer.append(" ");
        stringBuffer.append(XNap.tr("users"));
        String string = stringBuffer.toString();
        Runnable runnable = new Runnable(this, string){
            private final /* synthetic */ ChatSubPanel this$0;
            private final /* synthetic */ String val$s;

            public final void run() {
                this.this$0.jlServer.setText(this.val$s);
            }
            {
                this.val$s = string;
                this.this$0 = chatSubPanel;
                this.constructor$0(chatSubPanel);
            }

            private final void constructor$0(ChatSubPanel chatSubPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void userAdded(ChannelEvent channelEvent) {
        this.userData.add(channelEvent.getUser());
    }

    public void userRemoved(ChannelEvent channelEvent) {
        this.userData.remove(channelEvent.getUser());
    }

    public void topicChanged(ChannelEvent channelEvent) {
        Runnable runnable = new Runnable(this, channelEvent){
            private final /* synthetic */ ChatSubPanel this$0;
            private final /* synthetic */ ChannelEvent val$e;

            public final void run() {
                this.this$0.jlTopic.setText(this.val$e.getTopic());
            }
            {
                this.val$e = channelEvent;
                this.this$0 = chatSubPanel;
                this.constructor$0(chatSubPanel);
            }

            private final void constructor$0(ChatSubPanel chatSubPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected boolean itsMe(IUser iUser) {
        return this.channel.getServer().getUser().equals(iUser);
    }

    static /* synthetic */ ChangeTopicAction access$1(ChatSubPanel chatSubPanel) {
        return chatSubPanel.acChangeTopic;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChatSubPanel(IChannel iChannel) {
        this.channel = iChannel;
        this.initialize();
        this.jspH.addPropertyChangeListener("dividerLocation", this);
        this.addChannel(iChannel);
    }

    private class ChangeTopicAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(ChatSubPanel.this, "Topic", XNap.tr("Change Topic"), 3);
            if (string != null) {
                try {
                    ChatSubPanel.this.channel.changeTopic(string);
                }
                catch (IOException iOException) {
                    ChatSubPanel.this.println(XNap.tr("Could not change topic:") + " " + iOException.getMessage(), "chatError");
                }
            }
        }

        public ChangeTopicAction() {
            this.putValue("Name", "");
            this.putValue("SmallIcon", XNapFrame.getIcon("edit.png"));
            this.putValue("ShortDescription", XNap.tr("Change topic of channel."));
            this.putValue("MnemonicKey", new Integer(67));
            this.setEnabled(false);
        }
    }

    private class SendAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IChannel iChannel;
            String string = ChatSubPanel.this.jteInput.getText();
            if (string.length() > 0 && (iChannel = (IChannel)ChatSubPanel.this.jcbServers.getSelectedItem()) != null) {
                try {
                    iChannel.sendMessage(string);
                }
                catch (IOException iOException) {
                    ChatSubPanel.this.println(iOException.getMessage(), "chatError");
                }
                ChatSubPanel.this.jteInput.setText("");
            }
        }

        public SendAction() {
            this.putValue("Name", XNap.tr("Send"));
            this.putValue("ShortDescription", XNap.tr("Send message"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }
}

