/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import xnap.gui.util.GUIHelper;
import xnap.util.Preferences;

public class ConsolePane
extends JScrollPane
implements PropertyChangeListener {
    private Preferences prefs = Preferences.getInstance();
    private JTextArea jta;
    private boolean crop;
    private boolean appendPending = false;
    private StringBuffer pendingText = new StringBuffer();

    public void initialize() {
        this.jta = new JTextArea();
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        this.jta.setCaretColor(Color.red);
        this.jta.setSelectedTextColor(Color.red);
        this.jta.setEditable(false);
        this.jta.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setViewportView(this.jta);
        this.updateProperties();
    }

    public void appendLater(String string) {
        StringBuffer stringBuffer = this.pendingText;
        synchronized (stringBuffer) {
            this.pendingText.append(string);
            if (this.appendPending) {
                return;
            }
            this.appendPending = true;
        }
        Runnable runnable = new Runnable(this){
            private final /* synthetic */ ConsolePane this$0;

            public final void run() {
                String string;
                StringBuffer stringBuffer = ConsolePane.access$0(this.this$0);
                synchronized (stringBuffer) {
                    string = ConsolePane.access$0(this.this$0).toString();
                    ConsolePane.access$0(this.this$0).setLength(0);
                    ConsolePane.access$2(this.this$0, false);
                }
                this.this$0.append(string);
            }
            {
                this.this$0 = consolePane;
                this.constructor$0(consolePane);
            }

            private final void constructor$0(ConsolePane consolePane) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void append(String string) {
        int n;
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        int n2 = jScrollBar.getValue() + jScrollBar.getVisibleAmount();
        boolean bl = n2 == jScrollBar.getMaximum();
        this.jta.append(string);
        if (this.crop && (n = this.jta.getLineCount() - this.prefs.getMaxConsoleLines()) > 0) {
            try {
                int n3 = this.jta.getLineEndOffset(n);
                this.jta.replaceRange(null, 0, n3);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (bl) {
            try {
                n2 = this.jta.getLineCount() - 1;
                this.jta.setCaretPosition(this.jta.getLineEndOffset(n2));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateProperties();
    }

    public void setText(String string) {
        this.jta.setText(string);
    }

    public void updateProperties() {
        this.jta.setFont(GUIHelper.getFont("console"));
        this.jta.setBackground(GUIHelper.getColor("consoleBackground"));
        this.jta.setForeground(GUIHelper.getColor("consoleForeground"));
    }

    static /* synthetic */ StringBuffer access$0(ConsolePane consolePane) {
        return consolePane.pendingText;
    }

    static /* synthetic */ boolean access$1(ConsolePane consolePane) {
        return consolePane.appendPending;
    }

    static /* synthetic */ void access$2(ConsolePane consolePane, boolean bl) {
        consolePane.appendPending = bl;
    }

    public ConsolePane(boolean bl) {
        this.crop = bl;
        this.initialize();
        this.prefs.addFontListener("console", this);
        this.prefs.addColorListener("consoleBackground", this);
        this.prefs.addColorListener("consoleForeground", this);
    }

    public ConsolePane() {
        this(true);
    }
}

