/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xnap.XNap;
import xnap.gui.GridBagHelper;
import xnap.gui.MultiLineLabel;
import xnap.net.HttpConnection;
import xnap.net.PluginInfoReader;
import xnap.plugin.IPlugin;
import xnap.plugin.PluginInfo;
import xnap.plugin.PluginManager;
import xnap.util.FileHelper;
import xnap.util.VersionParser;

public class PluginDialog
extends JDialog
implements ListSelectionListener {
    private static PluginDialog me = null;
    private JLabel jlStatus;
    private DefaultListModel dlmPlugins;
    private JList jlPlugins;
    private JLabel jlName;
    private JLabel jlVersion;
    private JLabel jlInstalledVersion;
    private MultiLineLabel jlDescription;
    private InstallAction acInstall = new InstallAction();

    public static void showDialog(Component component) {
        if (me == null) {
            me = new PluginDialog();
            if (component != null) {
                me.setLocationRelativeTo(component);
            }
        }
        me.show();
    }

    private final void setStatus(String string) {
        this.jlStatus.setText(string);
        this.jlStatus.setToolTipText(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PluginInfo pluginInfo = (PluginInfo)this.jlPlugins.getSelectedValue();
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName(pluginInfo.getName());
        this.jlName.setText(pluginInfo.getName());
        this.jlVersion.setText(pluginInfo.getVersion());
        this.jlInstalledVersion.setText(iPlugin != null ? iPlugin.getVersion() : "");
        this.jlDescription.setText(pluginInfo.getDescription());
        if (iPlugin != null) {
            int n = VersionParser.compare(pluginInfo.getVersion(), iPlugin.getVersion());
            this.acInstall.setEnabled(n != 0);
        } else {
            this.acInstall.setEnabled(true);
        }
    }

    static /* synthetic */ PluginDialog access$2() {
        return me;
    }

    private PluginDialog() {
        this.jlStatus = new JLabel(" ");
        this.jlStatus.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.dlmPlugins = new DefaultListModel();
        this.jlPlugins = new JList(this.dlmPlugins);
        this.jlPlugins.addListSelectionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagHelper.addLabel(jPanel, XNap.tr("Name"));
        this.jlName = new JLabel();
        GridBagHelper.add((Container)jPanel, this.jlName);
        GridBagHelper.addLabel(jPanel, XNap.tr("Version"));
        this.jlVersion = new JLabel();
        GridBagHelper.add((Container)jPanel, this.jlVersion);
        GridBagHelper.addLabel(jPanel, XNap.tr("Installed"));
        this.jlInstalledVersion = new JLabel();
        GridBagHelper.add((Container)jPanel, this.jlInstalledVersion);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(XNap.tr("Description", 1)));
        this.jlDescription = new MultiLineLabel();
        jPanel2.add(this.jlDescription);
        GridBagHelper.add((Container)jPanel, jPanel2);
        GridBagHelper.addVerticalSpacer(jPanel);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JButton(this.acInstall));
        GridBagHelper.add((Container)jPanel, jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.add(new JButton(new CloseAction()));
        this.setTitle(XNap.tr("Install Plugins"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseListener());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jlStatus, "North");
        this.getContentPane().add((Component)new JScrollPane(this.jlPlugins), "West");
        this.getContentPane().add((Component)new JScrollPane(jPanel), "Center");
        this.getContentPane().add((Component)jPanel4, "South");
        this.pack();
        Thread thread = new Thread((Runnable)new FetchWorker(), "FetchPluginList");
        thread.start();
    }

    private class InstallAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PluginInfo pluginInfo = (PluginInfo)PluginDialog.this.jlPlugins.getSelectedValue();
            try {
                HttpConnection httpConnection = new HttpConnection();
                httpConnection.connect(pluginInfo.getLocation());
                ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(PluginDialog.this, "Downloading " + pluginInfo.getFilename(), httpConnection.getInputStream());
                progressMonitorInputStream.getProgressMonitor().setMillisToPopup(0);
                progressMonitorInputStream.getProgressMonitor().setMillisToDecideToPopup(0);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(progressMonitorInputStream);
                String string = FileHelper.getHomeDir("jars") + pluginInfo.getFilename();
                HttpConnection.save(bufferedInputStream, string);
            }
            catch (IOException iOException) {
                PluginDialog.this.setStatus(iOException.getMessage());
            }
        }

        public InstallAction() {
            this.putValue("Name", XNap.tr("Download"));
            this.putValue("ShortDescription", XNap.tr("Download selected plugin"));
            this.putValue("MnemonicKey", new Integer(73));
            this.setEnabled(false);
        }
    }

    private class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PluginDialog.this.dispose();
            me = null;
        }

        public CloseAction() {
            this.putValue("Name", XNap.tr("Close"));
            this.putValue("ShortDescription", XNap.tr("Closes the dialog."));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }

    private class CloseListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            PluginDialog.this.dispose();
            me = null;
        }

        CloseListener() {
        }
    }

    private class FetchWorker
    implements Runnable {
        public void run() {
            PluginDialog.this.setStatus(XNap.tr("Getting list..."));
            try {
                String string = "http://localhost/plugin.txt";
                PluginInfo[] pluginInfoArray = PluginInfoReader.read(string);
                int n = 0;
                while (n < pluginInfoArray.length) {
                    PluginDialog.this.dlmPlugins.addElement(pluginInfoArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {
                PluginDialog.this.setStatus(iOException.getMessage());
                return;
            }
            PluginDialog.this.setStatus(PluginDialog.this.dlmPlugins.size() + XNap.tr("Plugins available"));
        }

        FetchWorker() {
        }
    }
}

