/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import xnap.gui.XNapFrame;
import xnap.plugin.INetworkPlugin;
import xnap.util.event.StatusListener;

public class StatusPanel
extends JLabel
implements ActionListener,
StatusListener {
    public static final int TIMEOUT = 10000;
    private static final ImageIcon[] icons = new ImageIcon[]{null, XNapFrame.getSmallIcon("ok.png"), XNapFrame.getSmallIcon("flag.png")};
    private int defaultTimeout;
    private INetworkPlugin plugin = null;
    private Timer timer;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.timer.stop();
            super.setText(" ");
            super.setToolTipText(null);
        }
    }

    public void update() {
        if (this.plugin != null) {
            int n = this.plugin.getStatus();
            if (n > 0 && n < icons.length) {
                this.setIcon(icons[n]);
            } else {
                this.setIcon(null);
            }
            StringBuffer stringBuffer = new StringBuffer(this.plugin.getStatusMessage());
            this.setText(stringBuffer.toString());
            stringBuffer.append("(");
            stringBuffer.append(this.plugin.getName());
            stringBuffer.append(")");
            super.setToolTipText(stringBuffer.toString());
        }
    }

    public void setText(String string, int n) {
        super.setText(string);
        super.setToolTipText(string);
        if (n > 0) {
            this.timer.setInitialDelay(n);
            this.timer.restart();
        }
    }

    public void setText(String string) {
        this.setText(string, this.defaultTimeout);
    }

    public void setStatus(String string) {
        this.setText(string);
    }

    public StatusPanel(int n) {
        this.defaultTimeout = n;
        this.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.setForeground(Color.black);
        this.timer = new Timer(-1, this);
    }

    public StatusPanel(ImageIcon imageIcon) {
        this(-1);
        this.setIcon(imageIcon);
    }

    public StatusPanel(INetworkPlugin iNetworkPlugin) {
        this(-1);
        this.plugin = iNetworkPlugin;
    }

    public StatusPanel() {
        this(-1);
    }
}

