/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.AbstractSortableTableModel;
import xnap.gui.table.SortButtonRenderer;
import xnap.util.Preferences;

public class TableHeaderListener
extends MouseAdapter
implements MouseMotionListener {
    private JTable jta;
    private JTableHeader header;
    private JPopupMenu jpm;
    private SortButtonRenderer renderer;
    private AbstractSortableTableModel stm;
    private boolean sort = false;

    public static TableHeaderListener install(JTable jTable, JPopupMenu jPopupMenu) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableHeaderListener tableHeaderListener = new TableHeaderListener(jTable, jPopupMenu);
        jTableHeader.addMouseListener(tableHeaderListener);
        jTableHeader.addMouseMotionListener(tableHeaderListener);
        return tableHeaderListener;
    }

    public static TableHeaderListener install(JTable jTable) {
        return TableHeaderListener.install(jTable, null);
    }

    public static boolean isWindowsPopupTrigger(MouseEvent mouseEvent) {
        return Preferences.isWindowsOS && (mouseEvent.getModifiers() & 4) != 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        } else {
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            this.renderer.selectColumn(n);
            this.header.repaint();
            this.sort = true;
        }
        this.setAutoResizeMode(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        } else if (this.sort) {
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                if (this.jta.isEditing()) {
                    this.jta.getCellEditor().stopCellEditing();
                }
                int n2 = this.jta.convertColumnIndexToModel(n);
                this.sortByColumn(n, n2);
                this.sort = false;
            }
            this.renderer.selectColumn(-1);
            this.header.repaint();
            if (this.jta.getModel() instanceof AbstractDynamicTableModel) {
                ((AbstractDynamicTableModel)this.jta.getModel()).saveSortedColumn();
            }
        } else if (this.jta.getModel() instanceof AbstractDynamicTableModel) {
            ((AbstractDynamicTableModel)this.jta.getModel()).saveColumnWidths();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.sort) {
            this.sort = false;
            this.renderer.selectColumn(-1);
            this.header.repaint();
        }
        this.setAutoResizeMode(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private final void setAutoResizeMode(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0) {
            this.jta.setAutoResizeMode(1);
        } else if ((mouseEvent.getModifiers() & 2) != 0) {
            this.jta.setAutoResizeMode(4);
        } else {
            this.jta.setAutoResizeMode(2);
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        if (this.jpm != null) {
            this.header.setDraggedColumn(null);
            this.header.setResizingColumn(null);
            this.jpm.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void sortByColumn(int n, int n2) {
        boolean bl = this.stm.sortByColumn(n2);
        this.renderer.setSortedColumn(n, bl);
    }

    public TableHeaderListener(JTable jTable, JPopupMenu jPopupMenu) {
        this.jta = jTable;
        this.header = jTable.getTableHeader();
        this.stm = (AbstractSortableTableModel)jTable.getModel();
        this.jpm = jPopupMenu;
        this.renderer = new SortButtonRenderer(this.header.getDefaultRenderer());
        this.header.setDefaultRenderer(this.renderer);
        this.header.setReorderingAllowed(true);
        this.header.setResizingAllowed(true);
        if (this.stm.getLastSortedColumn() != -1) {
            int n = jTable.convertColumnIndexToView(this.stm.getLastSortedColumn());
            this.renderer.setSortedColumn(n, this.stm.isSortedAscending());
        }
    }
}

