/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import xnap.net.ISearchResult;
import xnap.util.StringHelper;

public class SearchResultContainer
extends Observable {
    private Vector results = new Vector();
    private int maxLinkSpeed = 0;
    private HashSet plugins = new HashSet();
    protected String status;

    public void add(ISearchResult iSearchResult) {
        this.results.add(iSearchResult);
        this.maxLinkSpeed = Math.max(iSearchResult.getUser().getLinkSpeed(), this.maxLinkSpeed);
        this.plugins.add(iSearchResult.getPlugin());
        this.broadcast();
    }

    public ISearchResult[] getSearchResults() {
        ISearchResult[] iSearchResultArray = new ISearchResult[this.results.size()];
        System.arraycopy(this.results.toArray(), 0, iSearchResultArray, 0, iSearchResultArray.length);
        return iSearchResultArray;
    }

    public int getBitrate() {
        return this.getResult().getBitrate();
    }

    public long getFilesize() {
        return this.getResult().getFilesize();
    }

    public int getFrequency() {
        return this.getResult().getFrequency();
    }

    public int getLength() {
        return this.getResult().getLength();
    }

    public int getLinkSpeed() {
        return this.maxLinkSpeed;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
        this.broadcast();
    }

    public String getPath() {
        String[] stringArray = this.getResult().getPath();
        if (this.results.size() == 1 && stringArray != null) {
            return StringHelper.toString(stringArray, "/");
        }
        return "";
    }

    public String getPlugin() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int getScore() {
        return this.results.size();
    }

    public String getShortFilename() {
        return this.getResult().getShortFilename();
    }

    public String getUsername() {
        if (this.results.size() == 1) {
            return this.getResult().getUser().getName();
        }
        return this.results.size() + " users";
    }

    protected ISearchResult getResult() {
        return (ISearchResult)this.results.get(0);
    }

    public int size() {
        return this.results.size();
    }

    public String toString() {
        return this.getShortFilename() + ", " + this.getUsername();
    }

    protected void broadcast() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public SearchResultContainer(ISearchResult iSearchResult) {
        this.add(iSearchResult);
    }

    public SearchResultContainer() {
    }
}

