/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.IOException;
import xnap.net.AbstractBrowse;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.BrowseRequestMessage;
import xnap.plugin.nap.net.msg.server.BrowseResponseMessage;

public class Browse
extends AbstractBrowse
implements ExceptionListener {
    protected Server server;
    protected String failedMsg = null;

    public void add(BrowseResponseMessage browseResponseMessage) {
        User user = this.server.getUser(browseResponseMessage.nick);
        SearchResult searchResult = new SearchResult(browseResponseMessage.filesize, browseResponseMessage.bitrate, browseResponseMessage.frequency, browseResponseMessage.length, user, browseResponseMessage.filename, browseResponseMessage.md5);
        this.add(searchResult);
    }

    public synchronized int available() throws IOException {
        if (this.failedMsg != null) {
            throw new IOException(this.failedMsg);
        }
        return super.available();
    }

    public void close() {
        if (!this.finished) {
            this.server.removeBrowse(this);
        }
        this.finished = true;
    }

    public void connect() throws IOException {
        this.server.addBrowse(this);
    }

    public void exceptionThrown(Exception exception) {
        this.failed(exception.getMessage());
    }

    public void failed(String string) {
        this.failedMsg = string;
    }

    public void finished() {
        this.finished = true;
    }

    public void start() {
        BrowseRequestMessage browseRequestMessage = new BrowseRequestMessage(this.user.getName());
        browseRequestMessage.setExceptionListener(this);
        MessageHandler.send(this.server, browseRequestMessage);
    }

    public Browse(User user) {
        super(user);
        this.server = user.getServer();
    }
}

