/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import xnap.net.IBrowse;
import xnap.net.IChannel;
import xnap.plugin.nap.net.AbstractNapUser;
import xnap.plugin.nap.net.Browse;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.PrivateMessage;
import xnap.plugin.nap.net.msg.client.WhoisRequestMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.user.UserData2;
import xnap.user.UserManager;
import xnap.util.Preferences;

public class User
extends AbstractNapUser {
    public static final int WHOIS_REQUERY_INTERVALL = 120000;
    public static final int WHOIS_RESENT_INTERVALL = 600000;
    private long lastWhoisSent = 0L;
    private long lastWhoisResponse = 0L;
    private Server server;
    private GlobalUser parent;

    public static GlobalUser getParentByName(String string) {
        GlobalUser globalUser = (GlobalUser)UserManager.getInstance().get(string);
        if (globalUser == null) {
            globalUser = new GlobalUser(string, true);
            UserManager.getInstance().add(globalUser);
        }
        return globalUser;
    }

    public IBrowse getBrowse() {
        return this.server != null ? new Browse(this) : null;
    }

    public UserData2 getData() {
        return this.parent.getData();
    }

    public IChannel getPrivateChannel() {
        return this.server != null ? MessageHandler.getPrivateChannel(this) : null;
    }

    public int getQueuedCount() {
        return this.parent.getQueuedCount();
    }

    public Server getServer() {
        return this.server;
    }

    public synchronized void incQueuedCount(int n) {
        this.parent.incQueuedCount(n);
    }

    public boolean isActionSupported(Class clazz) {
        return true;
    }

    public boolean isAllowedToDownload() {
        if (this.getMaxUploads() == Integer.MAX_VALUE) {
            return true;
        }
        NapPreferences napPreferences = NapPreferences.getInstance();
        if (napPreferences.getUseMinimumShares() && this.update() && this.getFileCount() < napPreferences.getMinimumShares()) {
            if (napPreferences.getSendMinimumSharesMessage()) {
                PrivateMessage privateMessage = new PrivateMessage(this.getName(), napPreferences.getMinimumSharesMessage());
                MessageHandler.send(this.server, privateMessage);
            }
            return false;
        }
        return true;
    }

    public boolean isAllowedToRequestDownload() {
        Preferences preferences = Preferences.getInstance();
        if (preferences.getLimitDownloadsPerUser()) {
            if (this.getMaxDownloads() == 0) {
                return false;
            }
            if (this.getMaxDownloads() == -1) {
                return this.getLocalDownloadCount() + this.getQueuedCount() < preferences.getMaxDownloadsPerUser();
            }
        }
        return true;
    }

    public boolean isUpToDate() {
        return System.currentTimeMillis() - this.lastWhoisResponse < 600000L;
    }

    public void notifyWhoisReceived() {
        this.lastWhoisResponse = System.currentTimeMillis();
        this.lastWhoisSent = 0L;
    }

    public void setStatus(int n) {
        this.parent.setStatus(n);
        super.setStatus(n);
    }

    public void setStatus(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("active")) {
            this.setStatus(1);
        } else if (string2.equals("remote")) {
            this.setStatus(2);
        } else {
            this.setStatus(3);
        }
    }

    public void setTemporary(boolean bl) {
        super.setTemporary(bl);
        this.parent.setTemporary(bl);
    }

    public boolean shouldRequery() {
        return System.currentTimeMillis() - this.lastWhoisSent > 120000L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (this.server != null) {
            stringBuffer.append("@");
            stringBuffer.append(this.server.getHost());
        }
        return stringBuffer.toString();
    }

    public boolean update(boolean bl) {
        if (bl || !this.isUpToDate()) {
            if (this.shouldRequery()) {
                MessageHandler.send(this.server, new WhoisRequestMessage(this.getName()));
                this.lastWhoisSent = System.currentTimeMillis();
            }
            return false;
        }
        return true;
    }

    public boolean update() {
        return this.update(false);
    }

    public User(String string, Server server) {
        this.server = server;
        if (string.equals(server.getUsername())) {
            this.fakeLocalFileCount = true;
        }
        this.parent = User.getParentByName(string);
        this.parent.getServers().add(server);
    }
}

