/*
 * Decompiled with CFR 0.152.
 */
package xnap.util.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.Console;
import xnap.util.Preferences;
import xnap.util.QuotedStringTokenizer;
import xnap.util.Updater;
import ziga.util.WindowsFileLauncher;

public class LauncherSupport {
    private static Preferences prefs = Preferences.getInstance();
    private static Logger logger = Logger.getLogger(class$Lxnap$util$launcher$LauncherSupport != null ? class$Lxnap$util$launcher$LauncherSupport : (class$Lxnap$util$launcher$LauncherSupport = LauncherSupport.class$("xnap.util.launcher.LauncherSupport")));
    public static String[][] LAUNCHERS = new String[][]{{"ziga.dll", "Windows (requires ziga.dll)", ""}, {"kfmclient", "KDE", "kfmclient"}, {"open", "Mac OS X", "open"}, {"other", XNap.tr("Other"), ""}};
    private static /* synthetic */ Class class$Lxnap$util$launcher$LauncherSupport;

    public static boolean isEnabled() {
        String string = prefs.getFileLauncherType();
        if (string.equals("ziga.dll")) {
            return Updater.isZigaDllLoaded();
        }
        return prefs.getFileLauncherCmd().length() > 0;
    }

    public static void open(File file) throws IOException {
        logger.debug("launching " + file.getAbsolutePath());
        String string = prefs.getFileLauncherType();
        if (string.equals("kfmclient")) {
            String[] stringArray = new String[]{prefs.getFileLauncherCmd(), "exec", file.getAbsolutePath()};
            LauncherSupport.exec(stringArray);
        } else if (string.equals("ziga.dll")) {
            try {
                WindowsFileLauncher.open(file.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                logger.error("ziga.dll", unsatisfiedLinkError);
                throw new IOException("ziga.dll not loaded");
            }
        } else if (string.equals("open")) {
            String[] stringArray = new String[]{prefs.getFileLauncherCmd(), file.getAbsolutePath()};
            LauncherSupport.exec(stringArray);
        } else {
            LauncherSupport.exec(prefs.getFileLauncherCmd(), new File[]{file});
        }
    }

    private static final Process exec(String string) throws IOException {
        return LauncherSupport.exec(string, null);
    }

    public static Process exec(String string, File[] fileArray) throws IOException {
        String[] stringArray;
        boolean bl = false;
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string);
        ArrayList<String[]> arrayList = new ArrayList<String[]>(quotedStringTokenizer.countTokens() + fileArray.length);
        while (quotedStringTokenizer.hasMoreTokens()) {
            stringArray = quotedStringTokenizer.nextToken();
            if (stringArray.equals("{}")) {
                LauncherSupport.insertFiles(arrayList, fileArray);
                bl = true;
                continue;
            }
            arrayList.add(stringArray);
        }
        if (!bl) {
            LauncherSupport.insertFiles(arrayList, fileArray);
        }
        stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return LauncherSupport.exec(stringArray);
    }

    private static final void insertFiles(ArrayList arrayList, File[] fileArray) {
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] != null || fileArray[n].length() != 0L) {
                    arrayList.add(fileArray[n].getAbsolutePath());
                }
                ++n;
            }
        }
    }

    private static final Process exec(String[] stringArray) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        if (Preferences.getInstance().getCaptureLauncherOutput()) {
            Console.getInstance().add(process);
        }
        return process;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private LauncherSupport() {
    }
}

