/**
 * AboutBox for JamochaMUD (to display license, thanks, etc...)
 * $Id: AboutBox.java,v 1.57 2004/08/03 02:06:40 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.*;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import anecho.gui.PosTools;
import anecho.gui.JMText;

/**
 * A Dialogue box to display licensing information and credits/thanks
 * for the developement of JamochaMUD.
 * @version $Id: AboutBox.java,v 1.57 2004/08/03 02:06:40 jeffnik Exp $
 * @author Jeff Robinson
 */
public class AboutBox extends Dialog implements ActionListener, KeyListener{
    
    /**
     * This button is used by the user to toggle between the credits and
     * license of JamochaMUD.
     */
    private static Button okayButton;
    
    /**
     * This button is used by the user to dismiss the "About JamochaMUD"
     * dialogue box.
     */
    private static Button cancelButton;
    /**
     * Current version number of JamochaMUD.
     */
    public static final String verNum = "1.1 build 2005-12-28";
    /**
     * The JMText item used to display either credits or licensing information.
     */
    private static JMText text;
    
    /**
     * The constructor that allows up to show the JamochaMUD AboutBox.
     * @param parentFrame The parent frame for our about-box.
     */
    // public AboutBox(Frame parentFrame, JMConfig settings){
    public AboutBox(Frame parentFrame) {
        super(parentFrame, "About JamochaMUD (Version: " + verNum +")", true);
        JMConfig settings = JMConfig.getInstance();
        
        // The "About Box" for JamochaMUD information
        
        // Design look for gridbag layout
        GridBagLayout dLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(dLayout);
        
        // Add the components to the dialog
        
        this.text = new JMText("", 80, 10, JMText.SCROLLBARS_VERTICAL_ONLY);
        text.setMaxRows(50);
        
        text.setEditable(false);
        text.addKeyListener(this);
        constraints.insets = new Insets(7, 7, 2, 7);
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.gridheight = GridBagConstraints.RELATIVE;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1;
        constraints.weighty = 1;
        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        dLayout.setConstraints(text, constraints);
        add(text);
        
        okayButton = new Button(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("credits"));
        constraints.insets = new Insets(2, 7, 7, 2);
        constraints.gridwidth = GridBagConstraints.RELATIVE;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0;
        constraints.weighty = 0;
        constraints.fill = GridBagConstraints.NONE;
        constraints.anchor = GridBagConstraints.WEST;
        dLayout.setConstraints(okayButton, constraints);
        okayButton.addActionListener(this);
        add(okayButton);
        
        cancelButton = new Button(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("thanksalot!"));
        constraints.insets = new Insets(2, 2, 7, 7);
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0;
        constraints.weighty = 0;
        constraints.fill = GridBagConstraints.NONE;
        constraints.anchor = GridBagConstraints.EAST;
        dLayout.setConstraints(cancelButton, constraints);
        cancelButton.addActionListener(this);
        add(cancelButton);
        
        this.pack();
        
        text.setFont(settings.getJMFont(settings.FONTFACE));
        text.setBackground(settings.getJMColor(settings.BACKGROUNDCOLOUR));
        text.setForeground(settings.getJMColor(settings.FOREGROUNDCOLOUR));
        
        Point centre = PosTools.findCenter();
        setLocation(centre.x - 237, centre.y - 185);
        setSize(475, 370);
        
        displayLicense();
        
        
    }
    
    /**
     * Information pertaining to the GPL and copyright
     */
    private void displayLicense() {
        text.setText("");
        
        // Write the GPL information
        text.append('\u001b' + "[32mJamochaMUD - a (Java) MUD/MUCK client\n");
        text.append("Copyright (C) 1998-2004  Jeff Robinson (jeffnik@anecho.mb.ca)\n");
        text.append('\u001b' + "[0m\n");
        text.append("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or any later version.\n\n");
        // text.append("\n");
        text.append("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\n");
        // text.append("\n");
        text.append("You should have received a copy of the GNU General Public License  along with this program; if not, write to the\n");
        text.append("Free Software Foundation, Inc., 59 Temple Place - Suite 330,\n");
        text.append("Boston, MA  02111-1307, USA.\n");
        okayButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("credits"));
    }
    
    /**
     * Changes the TextArea to show the credits for JamochaMUD
     */
    private void showCredits() {
        // First, empty the text area
        text.setText("");
        
        // Write the credits
        // In the future, perhaps this will be on a Canvas instead
        text.append("Dedicated to the memory of F. Ross Browne; uncle, instigator, inspiration, and curmudgeon.\n\n");
        // text.append("\n");
        text.append('\u001b' + "[1mJeff Robinson - High(ly caffeinated) Muckymuck (jeffnik@anecho.mb.ca)\n" + '\u001b' + "[0m\n");
        //text.append("\n");
        text.append("Jason Holmgren - Annoying Vermin\n");
        text.append("Sean Simpson - Head Haranguer (Strnig)\n");
        text.append("Sara Palmer - Chief of Wahness\n");
        text.append("Sandi Wilkinson - Wizzywizz\n");
        text.append("Andrea Adams - Clue-by-four handler\n");
        text.append("Bjoern Weber - Socks(5) for fox!\n");
        text.append("Leonid Konkov - Language logistics\n");
        text.append("Stephane Boisjoli - Text-chopping magic\n\n");
        // text.append("\n");
        text.append("Translations:\n");
        text.append("Miguel Estrugo - Man of many words (Spanish and Italian)\n");
        text.append("Mark Straver - Dutch (No, Dutch is *NOT* baby-German!) \n");
        text.append("Andr Schieleit - German!  Yay!\n\n");
        // text.append("\n");
        text.append("Sloggers:\n");
        text.append("Rocko - Official JMUD-mangler\n");
        text.append("Caroline Blight - Chat-a-cat\n");
        text.append("PaulTB - Japanese is a difficult language?!\n");
        text.append("Thufir - Work properly?  Not unreasonable, I guess.\n");
        text.append("Lucy Handfield - My God, it's (not) full of colours!\n");
        text.append("\n");
        text.append("A great deal of thanks to Matthias L. Jugel and Marcus Meiner for their Java telnet app (http://www.first.gmd.de/persons/leo/java/Telnet).\n");
        text.append("\n");
        text.append('\u001b' + "[1mCrystal Icon Theme" + '\u001b' + "[0m\n");
        text.append("Created by Everaldo Coelho for KDE.  http://www.everaldo.com\n");
        
        // Change the button to 'About'
        okayButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("aboutJamochaMUD"));
    }
    
    /**
     * Check for button presses
     * @param event The event used to determine the button pressed.
     */
    public void actionPerformed(final ActionEvent event){
        final String arg = event.getActionCommand();
        
        if (arg.equals(cancelButton.getLabel())) {
            // dismiss the dialogue
            dispose();
        }
        
        if (arg.equals(okayButton.getLabel())) {
            // Check to see which function to call
            if (arg.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("credits"))) {
                // Change to display the credits
                showCredits();
            } else {
                // Change to display the license
                displayLicense();
            }
            
            // reflow the layout of the button, incase the size of
            // the writing is different.
            okayButton.invalidate();
            okayButton.getParent().validate();
            
            // Make certain we start displaying the first line
            // of the text and not the last
            text.setVerticalScrollbarPos(0);
            
        }
        
    }
    
    /**
     * Consume any keystrokes that are in the TextArea
     * @param event Any keypresses received.
     */
    public void keyPressed(final KeyEvent event){
        event.consume();
        // return;
    }
    
    /**
     * 
     * @param event 
     */
    public void keyTyped(final KeyEvent event){}
    
    /**
     * 
     * @param event 
     */
    public void keyReleased(final KeyEvent event){}
    
}
