/**
 * JMConfig.java, an object to keep and share
 * JamochaMUD settings between classes
 * $Id: JMConfig.java,v 1.32 2004/07/28 03:13:05 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * vesion 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

// import anecho.JamochaMUD.DataIn;
// import anecho.JamochaMUD.CHandler;

import java.awt.Color;
//import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;

import java.util.Hashtable;
import java.util.Vector;

public class JMConfig {
    
    // This hashtable will contain all the values we should need
    private Hashtable vars;
    private Hashtable userVariables;    // variables defined by the user
    private Hashtable userDefs; // Definitions defined by the user
    private static final boolean DEBUG = false;
    
    public static final String AUTOFOCUSINPUT = "AutoFocusInput";
    public static final String AUTOLOGGING = "AutomaticLogging";
    public static final String ALTFOCUS = "AltFocus";
    public static final String ANTIALIAS = "AntiAliasing";
    public static final String BACKGROUNDCOLOUR = "BGColour";
    public static final String BGPAINT = "BackgroundPaint";
    public static final String BROWSER1 = "Browser1";
    public static final String BROWSERINSTANCE1 = "BrowserInstance1";
    public static final String BROWSER2 = "Browser2";
    public static final String BROWSERINSTANCE2 = "BrowserInstance2";
    public static final String CONNECTIONHANDLER = "ConnectionHandler";
    public static final String CONNMUCK = "ConnMuck";
    public static final String CONNPORT = "ConnPort";
    public static final String CUSTOMPALETTE = "CustomPalette";
    public static final String DATABAR = "DataBar";
    public static final String DATAINVARIABLE = "DataInVariable";
    public static final String DIVIDERLOCATION = "DividerLocation";
    public static final String DOUBLEBUFFER = "DoubleBuffer";
    public static final String EMAILCLIENT = "EMailClient";
    public static final String ENUMERATOR = "Enumerator";
    public static final String FONTFACE = "FontFace";
    public static final String FOREGROUNDCOLOUR = "FGColour";
    public static final String FTPCLIENT = "FTPClient";
    public static final String ICONIMAGE = "IconImage";
    public static final String JMUDCORE = "JamochaMUDCore";
    public static final String LASTMU = "LastConnectedMU";
    public static final String LOGPATH = "LogPath";
    public static final String LOCALECHO = "LocalEcho";
    public static final String LOWCOLOUR = "LowColour";
    public static final String MACROFRAME = "MacroFrame";
    public static final String MACRODEFS = "MacroDefs";
    public static final String MACROLABELS = "MacroLabels";
    public static final String MACROVISIBLE = "MacroVisible";
    public static final String MAINLAYOUTVALID = "MainLayoutValid";
    public static final String MAINWINDOW = "MainWindow";
    public static final String MAINWINDOWICONIFIED = "MainWindowIconified";
    public static final String MAINWINDOWVARIABLE = "MainWindowVariable";
    public static final String MASTERPLUGINDIR = "MasterPlugInDirectory";
    public static final String MUCKCONNVISIBLE = "MuckConnVisible";
    public static final String MUCKMAINFRAME = "MuckMainFrame";
    public static final String MUCKMAINTITLE = "MuckMainTitle";
    public static final String MUCKNAME = "MuckName";
    public static final String MUCKADDY = "MuckAddy";
    public static final String MUCKPORT = "MuckPort";
    public static final String OSNAME = "OSName";
    public static final String PATHSEPARATOR = "PathSeparator";
    public static final String PLUGENUMERATOR = "PluginEnumerator";
    public static final String PLUGINNAME = "PlugInName";
    public static final String PLUGINSTATUS = "PlugInStatus";
    public static final String PROXY = "ProxyEnabled";
    public static final String PROXYHOST = "ProxyHost";
    public static final String PROXYPORT = "ProxyPort";
    public static final String RELEASEPAUSE = "ReleasePause";
    public static final String SCREENSIZE = "ScreenSize";
    public static final String SINGLEUSERMODE = "Single User Mode";
    public static final String SPLITVIEW = "SplitView";
    public static final String SYNCWINDOWS = "SyncWindows";
    public static final String TEXTPANEL = "TextPanel";
    public static final String TFKEYEMU = "TFKeyEmu";
    public static final String TIMERS = "Timers";
    public static final String TIMERSVISIBLE = "TimersVisible";
    public static final String USESWING = "UseSwing";
    public static final String USESWINGENTRY = "UseSwingEntry";
    public static final String USEUNICODE = "Unicode";
    public static final String USERDIRECTORY = "UserDirectory";
    public static final String USERPLUGINDIR = "UserPlugInDir";
    public static final String WORKINGDIRECTORY = "WorkingDirectory";
    public static final String WORLD = "World";
    public static final String BUNDLEBASE = "anecho.JamochaMUD.JamochaMUDBundle";
    
    /** Our constructor is empty, and we like it that way!
     * Well, actually, all our variables should have some base value
     * straight &quot;out of the box".  There would be far too many
     * to do in the constructor... without falling asleep.
     *
     * Individual "get" statements will return a default value if
     * one does not exist.  This should avoid problems with a damaged
     * .jamocha.rc, missing information when writing out .jamocha.rc
     * or like scenarios.
     */
    
    private static JMConfig _instance;
    
//    public JMConfig() {
    private JMConfig() {
        vars = new Hashtable(101, .75f);
        userVariables = new Hashtable(5, .75f);
        userDefs = new Hashtable(5, .75f);
    }
    
    /**
     * 
     * @return 
     */
    public static JMConfig getInstance() {
        if (_instance==null) {
            _instance = new JMConfig();
        }
        return _instance;
        
    }
    
    /** Check our hashtable for the existance
     * of key &quot;String"
     */
    private boolean checkKey(final String key) {
        boolean retCode = false;
        
        if (vars.containsKey(key)) {
            // return true;
            retCode = true;
        }
        
        return retCode;
    }
    
    /** Convert a string value to a boolean */
    private boolean stringToboolean(final String key) {
        final String workString = (String)vars.get(key);
        boolean retCode = false;
        if (workString.toLowerCase().equals("true")) {
            // return true;
            retCode = true;
        }
        return retCode;
    }
    
    /* Convert a boolean value to a string */
    /*
    private String booleanToString(boolean status) {
        String retCode = "false";
     
        if (status) {
            retCode = "true";
        }
     
        return retCode;
        }
     */
    
    /**
     * Set a value to our configuration containing a boolean value
     * @param objName A string defining the setting's name
     * @param setting The boolean value to be attributed to our <CODE>objName</CODE>
     */
    public synchronized void setJMValue(final String objName, final boolean setting) {
        String value = "false";
        if (setting) {
            value = "true";
        }
        vars.put(objName, value);
    }
    
    /**
     *
     * @param objName
     * @param setting
     */
    public synchronized void setJMValue(final String objName, final int setting) {
        vars.put(objName, setting + "");
    }
    
    /**
     * Add a string to our settings
     * @param objName
     * @param value
     */
    public synchronized void setJMValue(final String objName, final Object value) {
        vars.put(objName, value);
    }
    
    
    /**
     *
     * @param item
     * @param setting
     */
    public void setJMboolean(final String item, final String setting) {
        String value = "false";
        if (setting.toLowerCase().equals("true")) {
            value = "true";
        }
        vars.put(item, value);
    }
    
    /**
     *
     * @param item
     * @param value
     */
    public synchronized void setJMObject(final String item, final Object value) {
        vars.put(item, value);
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Object getJMObject(final String item) {
        Object retVal = (Object)null;
        
        if (checkKey(item)) {
            retVal = (Object)vars.get(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Frame getJMFrame(final String item) {
        Frame retVal = new Frame();
        
        if (checkKey(item)) {
            retVal = (Frame)vars.get(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Rectangle getJMRectangle(final String item) {
        Rectangle retVal = new Rectangle(0, 0, 0, 0);
        
        if (checkKey(item)) {
            retVal = (Rectangle)vars.get(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized String getJMString(final String item) {
        String retVal = "";
        if (checkKey(item)) {
            retVal = (String)vars.get(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized String[] getJMStringArray(final String item) {
        String[] retVal = new String[0];
        if (checkKey(item)) {
            retVal = (String[])vars.get(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized boolean getJMboolean(final String item) {
        boolean retVal = false;
        
        if (checkKey(item)) {
            retVal = stringToboolean(item);
        }
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Color getJMColor(final String item) {
        Color retVal = new Color(0, 0, 0);
        
        if (checkKey(item)) {
            retVal = (Color)vars.get(item);
        }
        
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized int getJMint(final String item) {
        int retVal = 0;
        
        if (checkKey(item)) {
            retVal = Integer.parseInt((String)vars.get(item));
        }
        
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Font getJMFont(final String item) {
        Font retVal = new Font("Dialog", Font.PLAIN, 12);
        
        if (checkKey(item)) {
            retVal = (Font)vars.get(item);
        }
        
        return retVal;
    }
    
    /**
     *
     * @param item
     * @return
     */
    public synchronized Vector getJMVector(final String item) {
        Vector retVal = new Vector();
        
        if (checkKey(item)) {
            retVal = (Vector)vars.get(item);
        }
        
        return retVal;
    }
    
    /* Specialised methods that are a little more tricky to deal with */
    /**
     *
     * @param icon
     */
    public synchronized void setIconImage(final Image icon) {
        vars.put(ICONIMAGE, icon);
    }
    
    /**
     *
     * @return
     */
    public synchronized Image getIconImage() {
        return (Image)getJMObject(ICONIMAGE);
    }
    
    /*
    public synchronized void setPlugInName(Vector names) {
        vars.put(PLUGINNAME, names);
    }
     
    public synchronized Vector getPlugInName() {
        return (Vector)getJMObject(PLUGINNAME);
    }
     
    public synchronized void setPlugInStatus(Vector status) {
        vars.put(PLUGINSTATUS, status);
    }
     
    public synchronized Vector getPlugInStatus() {
        return (Vector)getJMObject(PLUGINSTATUS);
    }
     */
    
    /*
    public synchronized void setMuckName(Vector name) {
        vars.put(MUCKNAME, name);
    }
     
    public synchronized Vector getMuckName() {
        if (!checkKey(MUCKNAME)) {
            // Create a default MU* setting
            createNewMuck();
        }
        return (Vector)getJMObject(MUCKNAME);
    }
     
    public synchronized void setMuckAddy(Vector addy) {
        vars.put(MUCKADDY, addy);
    }
     
    public synchronized Vector getMuckAddy() {
        if (!checkKey(MUCKADDY)) {
            // Create a default MU* setting
            createNewMuck();
        }
        return (Vector)getJMObject(MUCKADDY);
    }
     
    public synchronized void setMuckPort(Vector port) {
        vars.put(MUCKPORT, port);
    }
     
    public synchronized Vector getMuckPort() {
        if (!checkKey(MUCKPORT)) {
            // Create a default MU* setting
            createNewMuck();
        }
        return (Vector)getJMObject(MUCKPORT);
    }
     */
    
    /**
     *
     * @param screen
     */
    public synchronized void setScreenSize(final Dimension screen) {
        vars.put(SCREENSIZE, screen);
    }
    
    /**
     *
     * @return
     */
    public synchronized Dimension getScreenSize() {
        return (Dimension)getJMObject(SCREENSIZE);
    }
    
    /**
     *
     * @param connection
     */
    public synchronized void setConnectionHandler(final CHandler connection) {
        if (DEBUG) {
            System.err.println("Connection Handler set.");
        }
        vars.put(CONNECTIONHANDLER, connection);
    }
    
    /**
     *
     * @return
     */
    public synchronized CHandler getConnectionHandler() {
        return (CHandler)(getJMObject(CONNECTIONHANDLER));
    }
    
    /**
     *
     * @param core
     */
    public synchronized void setJMCore(final JMUD core) {
        vars.put(JMUDCORE, core);
    }
    
    /**
     *
     * @return
     */
    public synchronized JMUD getJMCore() {
        return (JMUD)getJMObject(JMUDCORE);
    }
    
    /**
     *
     * @param variable
     */
    public synchronized void setDataInVariable(final DataIn variable) {
        vars.put(DATAINVARIABLE, variable);
    }
    
    /**
     *
     * @return
     */
    public synchronized DataIn getDataInVariable() {
        return (DataIn)getJMObject(DATAINVARIABLE);
    }
    
    /**
     *
     * @param variable
     */
    public synchronized void setMainWindowVariable(final MuckMain variable) {
        vars.put(MAINWINDOWVARIABLE, variable);
    }
    
    /**
     *
     * @return
     */
    public synchronized MuckMain getMainWindowVariable() {
        return (MuckMain)getJMObject(MAINWINDOWVARIABLE);
    }
    
    /**
     *
     * @param plugEnum
     */
    public synchronized void setPlugEnumerator(final EnumPlugIns plugEnum) {
        vars.put(PLUGENUMERATOR, plugEnum);
    }
    
    /**
     *
     * @return
     */
    public synchronized String getPlugEnumerator() {
        String retVal = "";
        
        if (checkKey(PLUGENUMERATOR)) {
            retVal = (String)vars.get(PLUGENUMERATOR);
        }
        return retVal;
    }
    
    /**
     * This returns the base path to our language resource bundles
     * @return 
     */
    public synchronized String getBundleBase() {
        return "anecho.JamochaMUD.JamochaMUDBundle";
    }
    
    /**
     * Add a new user-variable or change the definition of an existing one
     * @param name 
     * @param value 
     */
    public synchronized void addVariable(final String name, final String value) {
        if (userVariables.containsKey(name)) {
            userVariables.remove(name);
        }
        
        userVariables.put(name, value);
        
    }
    
    /**
     * Get the value of the given user-variable name
     * @param name 
     * @return 
     */
    public synchronized String getVariable(final String name) {
        // String retVal = "";
        String retVal = (String)null;
        
        if (userVariables.containsKey(name)) {
            retVal = (String)userVariables.get(name);
        }
        
        return retVal;
        
    }
    
    /**
     * Remove the selected variable from the list of user-variables
     * @param name 
     * @return 
     */
    public synchronized boolean removeVariable(final String name) {
        boolean retVal = false;
        
        if (userVariables.containsKey(name)) {
            userVariables.remove(name);
            retVal = true;
        }
        
        return retVal;
    }
    
    /**
     *
     * @return
     */
    public synchronized Hashtable getAllVariables() {
        return userVariables;
    }
    
    /**
     *
     * @param name
     * @param value
     */
    public synchronized void addDefinition(final String name, final String value) {
        if (userDefs.containsKey(name)) {
            userDefs.remove(name);
        }
        
        userDefs.put(name, value);
    }
    
    /**
     *
     * @param name
     * @return
     */
    public synchronized String getDefinition(final String name) {
        String retVal = (String)null;
        
        if (userDefs.containsKey(name)) {
            // return (String)userDefs.get(name);
            retVal = (String)userDefs.get(name);
        }
        
        return retVal;
    }
    
    
    /**
     *
     * @param name
     * @return
     */
    public synchronized boolean removeDefinition(final String name) {
        boolean retVal = false;
        
        if (userDefs.containsKey(name)) {
            userDefs.remove(name);
            retVal = true;
        }
        
        return retVal;
        
    }
    
    /**
     *
     * @return
     */
    public synchronized Hashtable getAllDefinitions() {
        return userDefs;
    }
    
    /** Sets up a default MU* as we've had a request for one
     * but don't seem to have any set!
     */
    /*
    private void createNewMuck() {
        System.err.println("Create New Muck.");
     
        Vector tempName = new Vector(0, 1);
        Vector tempAddy = new Vector(0, 1);
        Vector tempPort = new Vector(0, 1);
     
        tempName.addElement("FurryMuck");
        tempAddy.addElement("muck.furry.com");
        tempPort.addElement("8888");
     
        // setMuckName(tempName);
        // setMuckAddy(tempAddy);
        // setMuckPort(tempPort);
        setJMValue(MUCKNAME, tempName);
        setJMValue(MUCKADDY, tempAddy);
        setJMValue(MUCKPORT, tempPort);
        }
     */
    
    /** Experimental way of having saving settings in our hashfile.
     * We will define a list of public constants which will stand
     * for our settings in JamochaMUD.  To set the value represented
     * by these constants the program will give the name of the constant
     * plus the value to be added.  Inversely, the program will get
     * a value by asking for the constant and defining the type of
     * "object" that it should be cast to.
     */
    
    
}

