/**
 * JMParseRC replaces the deprecated ParseINI file
 * Reads in the settings for the user's environment
 * $Id: JMParseRC.java,v 1.30 2004/08/03 02:06:40 jeffnik Exp $
 */


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
//import java.io.PrintWriter;
import java.io.RandomAccessFile;

import java.util.Hashtable;
// import java.util.Properties;
import java.util.Vector;

import anecho.gui.OKBox;
// import anecho.gui.ResReader;

/**
 * JMParseRC replaces the deprecated ParseINI file
 * Reads in the settings for the user's environment
 * @version $Id: JMParseRC.java,v 1.30 2004/08/03 02:06:40 jeffnik Exp $
 * @author Jeff Robinson
 */
public class JMParseRC{
    
    /**
     * Read .jamocha.rc and make an
     * array of available MU*s, window positions, etc.
     */
    
    private boolean stillLines, readLoop;
    private Hashtable jmSections;
    // private FileOutputStream outFile;
    private int sectionFlag;
    private int tempInt1, tempInt2, tempInt3;
    private int totalLines = 0;
    // private PrintWriter out;
    public RandomAccessFile file;
    private String str, temp1, temp2, temp3, temp4;
    private Frame workingFrame;
    // private Vector fileLines;       // This vector contains our configuration file
    private String fileLines[];
    public JMConfig settings;
    private static final boolean DEBUG = false;
    
    Vector muckName = new Vector(0, 1);
    Vector muckAddy = new Vector(0, 1);
    Vector muckPort = new Vector(0, 1);
    
    //	public JMParseRC() {
    /**
     * 
     */
//        public JMParseRC(JMConfig mainSettings) {
//            this.settings = mainSettings;
    public JMParseRC() {
        this.settings = JMConfig.getInstance();
        
        // Set INI-field flags to 0
        jmSections = new Hashtable();
        // workingFrame = new Frame("Loading...."); 	// This frame is created
        // so that the dialogue
        // box has a parent
        
        // Set SectionFlag to 0, which indicates a non-valid INI group
        sectionFlag = 0;
        
        // Initialise other variables
        temp1 = "";
        temp2 = "";
        temp3 = "";
        temp4 = "";
        
        // First, set 'stillLines' to True.
        // When 'stillLines' is false, end reading the file
        
        stillLines = true;
        Vector tempLines = new Vector();
        
        // Open the file to allow subroutine to read
        
        try {
            // file = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc", "r");
            file = new RandomAccessFile(settings.getJMString(JMConfig.USERDIRECTORY) + ".jamocha.rc", "r");
            // int totalLines = (int)file.length();
            // totalLines = (int)file.length();
            
            fileLines = new String[totalLines];
            
            String str; // Temporary working String
            // boolean stillLines = true;
            
            // Read in all the lines from the file
            // for (int i = 0; i < totalLines; i++) {
            // int i = 0;
            
            while (stillLines) {
                str = (file.readLine()).trim();
                
                // Check for relevant information
                if (str.equals(null)) {
                    // We've run out of lines to read
                    // readLoop = false;
                    // stillLines = false;
                    if (DEBUG) {
                        System.err.println("NULL in .rc file.");
                    }
                } else {
                    tempLines.addElement(str);
                }
                
            }
            
        } catch (IOException e) {
            // No .jamocha.rc available, create a new one
            if (DEBUG) {
                System.err.println("JMParseRC creating new .jamocha.rc file.");
            }
            createRC();
            // } catch (NullPointerException e) {
            // Run out of file to parse
        } catch (Exception e) {
            // This is the catchall exception, just to end JMParseRC
            // System.err.println("JMParseRC Exception " + e);
            // should really work on a better mechanism to end this, huh?
            if (DEBUG) {
                System.err.println("JMParseRC hit an error: " + e);
            }
        }
        
        // Set all the elements in our Settings class to the default
        // Any settings we find here will then override them
        
        
        // Loop through all the lines of the file and separate it into its
        // proper "components"
        
        String tmpString;
        
        fileLines = new String[tempLines.size()];
        
        // Convert our Vector to an array for "easier" handling
        for (int i = 0; i < tempLines.size(); i++) {
            fileLines[i] = tempLines.elementAt(i).toString();
        }
        
        for (int i = 0; i < fileLines.length; i++) {
            
            try {
                
                tmpString = fileLines[i].toLowerCase();
                
                if (tmpString.equalsIgnoreCase("[worlds]")) {
                    if (fileLines[0].toLowerCase().equalsIgnoreCase("# jamochamud ini file version 1.0")) {
                        // Old style file... must be converted!!
                        if (DEBUG) {
                            System.err.println("Worlds in old format, converting...");
                        }
                        convertMuckWorld(i);
                        // System.exit(0);
                    } else {
                        muckWorld(i);
                    }
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.WORLD + "]")) {
                    muckWorld(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.FOREGROUNDCOLOUR + "]")) {
                    setColours(i, true);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.BACKGROUNDCOLOUR + "]")) {
                    setColours(i, false);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.MAINWINDOW + "]")) {
                    mainWindow(i, true);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.DATABAR + "]")) {
                    mainWindow(i, false);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.MACROFRAME + "]")) {
                    macroWindow(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.FONTFACE + "]")) {
                    fontFace(i);
                }
                
                        /*
                        if (tmpString.equalsIgnoreCase("[" + JMConfig.MACROS + "]")) {
                        }
                         */
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.BROWSER1 + "]")) {
                    browser(i, true);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.BROWSER2 + "]")) {
                    browser(i, false);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.FTPCLIENT + "]")) {
                    fTPClient(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.EMAILCLIENT + "]")) {
                    eMailClient(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.TIMERS + "]")) {
                    jMTimers(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.AUTOFOCUSINPUT + "]")) {
                    autoFocusInput(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.AUTOLOGGING + "]")) {
                    autoLogging(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.LOCALECHO + "]")) {
                    localEcho(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.SYNCWINDOWS + "]")) {
                    jMSyncWindows(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.USEUNICODE + "]")) {
                    jMUseUnicode(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.TFKEYEMU + "]")) {
                    jMTFKeyEmu(i);
                }
                if (tmpString.equalsIgnoreCase("[" + JMConfig.PROXY + "]")) {
                    jMSetProxy(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.DOUBLEBUFFER + "]")) {
                    jMSetDoubleBuffer(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.SPLITVIEW + "]")) {
                    jMSetSplitView(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.RELEASEPAUSE + "]")) {
                    jMSetReleasePause(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.ALTFOCUS + "]")) {
                    jMSetAltFocus(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.LASTMU + "]")) {
                    jMSetLastMU(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.LOGPATH + "]")) {
                    jMSetLogPath(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.ANTIALIAS + "]")) {
                    jMSetAntiAliasing(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.LOWCOLOUR + "]")) {
                    jMSetLowColour(i);
                }
                
                if (tmpString.equalsIgnoreCase("[" + JMConfig.DIVIDERLOCATION + "]")) {
                    jMSetDivider(i);
                }
                
                if (tmpString.startsWith("/def")) {
                    jMAddDefinition(i);
                }
                
                if (tmpString.startsWith("/set")) {
                    jMAddVariable(i);
                }
                
                // default:
                
                //}
            } catch (Exception le) {
                if (DEBUG) {
                    System.err.println("Loop exception " + le);
                }
                le.printStackTrace();
                // System.exit(0);
            }
            
        }
        
        
        // Add the worlds to the hashtable if we have any
        if (muckName.size() > 0) {
            // settings.setMuckName(muckName);
            // settings.setMuckAddy(muckAddy);
            // settings.setMuckPort(muckPort);
            settings.setJMValue(JMConfig.MUCKNAME, muckName);
            settings.setJMValue(JMConfig.MUCKADDY, muckAddy);
            settings.setJMValue(JMConfig.MUCKPORT, muckPort);
        }
        
        // Do a sanity-check on colours
        Color tempColour1 = settings.getJMColor(settings.FOREGROUNDCOLOUR);
        Color tempColour2 = settings.getJMColor(settings.BACKGROUNDCOLOUR);
        
        // Make certain our two colours are not the same!
        if (tempColour1.equals(tempColour2)) {
            int red, green, blue;
            red = tempColour1.getRed();
            blue = tempColour1.getBlue();
            green = tempColour1.getGreen();
            red = red + 128;
            if (red > 255) {
                red = red - 255;
            }
            green = green + 128;
            if (green > 255) {
                green = green -255;
            }
            
            blue = blue + 128;
            if (blue > 255) {
                blue = blue - 255;
            }
            tempColour1 = new Color(red, green, blue);
            settings.setJMValue(JMConfig.FOREGROUNDCOLOUR, tempColour1);
        }
        
        
        // Get any Java2 specific settings
        if (settings.getJMboolean(JMConfig.USESWING)) {
            // Get the customer palette
            java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
            // java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(JMConfig.class);
            
            if (DEBUG) {
                System.err.println("JMParseRC getting custom palette from " + prefs);
            }
            int tmpCol = -1;
            Color[] newPal = new Color[16];
            
            try {
            for (int i = 0; i < 16; i++) {
                tmpCol = prefs.getInt("Palette" + i, -1);
                newPal[i] = new Color(tmpCol);
                if (DEBUG) {
                    System.err.println("Color " + i + " is " + newPal[i] + " (tmpCol " + tmpCol + ")");
                }
            }
            
//            if (tmpCol != -1) {
                settings.setJMObject(JMConfig.CUSTOMPALETTE, newPal);
//            } else {
//                if (DEBUG) {
//                    System.err.println("JMParseRC custom palette is null");
//                }
//            }
            } catch (Exception exc) {
                if (DEBUG) {
                    System.err.println("JMPraseRC custom error getting custom palette" + exc);
                }
            }
        }
        
    }
    
    /**
     * Section to read line and parse out remarks and/or blank lines
     * @return 
     */
    public String readParse() {
        readLoop = true;
        
        while (readLoop) {
            try {
                // Read in the line from the file, and trim extra characters
                str = (file.readLine()).trim();
                
                // Check for relevant information
                if (str.equals(null)) {
                    // We've run out of lines to read
                    readLoop = false;
                    stillLines = false;
                }
//				if (!str.equals("")) {
//                                    if (!(str.substring(0, 1)).equals("#")) {
                if (!str.equals("") && str.charAt(0) != '#') {
                    // if (!(str.substring(0, 1)).equals("#")) {
                    // Disregard as comment
                    // } else {
                    // This line is a keeper!
                    readLoop = false;  // This terminates the loop
                }
            } catch (NullPointerException ex) {
                // End of the file
                readLoop = false;
                stillLines = false;
                // } catch (StringIndexOutOfBoundsException ex) {
                // Hmmm...
            } catch (Exception ex) {
                // Mark for exception... probably no lines left
                if (DEBUG) {
                    System.err.println("JMParseRC: Exception... " + ex);
                }
                readLoop = false;
                stillLines = false;
            }
        }
        
        return str;
    }
    
//	public static void Content() {
//		JMParseRC a = new JMParseRC();
//	}
    
    /** Set our simple settings */
//        private void setValue(String setting, int index) {
//            settings.setJMValue(setting, fileLines[index + 1]);
//        }
    
    /**
     * Set the status of Auto-Focus Input
     */
    private void autoFocusInput(final int index) {
        // settings.setAutoFocusInput(fileLines[index + 1]);
        settings.setJMValue(settings.AUTOFOCUSINPUT, fileLines[index + 1]);
    }
    
    private void autoLogging(final int index) {
        settings.setJMValue(settings.AUTOLOGGING, fileLines[index + 1]);
    }
    
    /** The status of our Local Echo setting */
    private void localEcho(final int index) {
        // settings.setLocalEcho(fileLines[index + 1]);
        settings.setJMValue(JMConfig.LOCALECHO, fileLines[index + 1]);
        // settings.setLocalEcho(temp1);
        // jmSections.put(settings.LOCALECHO, "true");
    }
    
    /**
     * Read in the names of the 'worlds'
     */
    private void muckWorld(final int index) {
        
        // Parse the remaining 2 required muckWorld lines, checking for section flags
        muckName.addElement(fileLines[index + 1]);
        muckAddy.addElement(fileLines[index + 2]);
        muckPort.addElement(fileLines[index + 3]);
    }
    
    private void convertMuckWorld(final int origIndex) {
        int index = origIndex;
        
        boolean stillWorlds = true;
        
        while (stillWorlds) {
            index++;
            if (fileLines[index].startsWith("[") || fileLines[index].startsWith("#")) {
                stillWorlds = false;
            } else {
                
                if (!fileLines[index].trim().equals("")) {
                    muckName.addElement(fileLines[index]);
                    muckAddy.addElement(fileLines[index + 1]);
                    muckPort.addElement(fileLines[index + 2]);
                    index = index + 2;
                }
                
            }
            
        }
        
    }
    
    /**
     * Set the foreground and background colours for JamochaMUD
     */
    // public void setColours(String temp1) {
    private void setColours(final int index, final boolean foreground) {
        // Set either the foreground or the background colours
        try {
            tempInt1 = Integer.parseInt(fileLines[index + 1]);
            tempInt2 = Integer.parseInt(fileLines[index + 2]);
            tempInt3 = Integer.parseInt(fileLines[index + 3]);
            
            final Color tColour = new Color(tempInt1, tempInt2, tempInt3);
            
            if (foreground) {
                // settings.setForegroundColour(tColour);
                settings.setJMValue(settings.FOREGROUNDCOLOUR, tColour);
            } else {
                // settings.setBackgroundColour(tColour);
                settings.setJMValue(settings.BACKGROUNDCOLOUR, tColour);
            }
            
        } catch (Exception e) {
            if (DEBUG) {
                System.err.println("Your colours are buggered." + e);
            }
        }
    }
    
    /**
     * Set location of the Main Output window
     * and Data Bar (input window) location and size
     */
    // public void mainWindow(String temp1) {
    private void mainWindow(final int index, final boolean mainWindow) {
        // Set the location of the main text window
        try {
            temp1 = fileLines[index + 1];
            temp2 = fileLines[index + 2];
            temp3 = fileLines[index + 3];
            temp4 = fileLines[index + 4];
            
            final Rectangle tempRect = new Rectangle(Integer.parseInt(temp1.trim()),
                    Integer.parseInt(temp2.trim()),
                    Integer.parseInt(temp3.trim()),
                    Integer.parseInt(temp4.trim()));
            
            // Check to see if any of of these values contain flags
            if (mainWindow) {
                // Set the variables for the databar's
                // initial position and size
                
                    /*
                    settings.setMainWindow(new Rectangle(Integer.parseInt(temp1.trim()),
                                                         Integer.parseInt(temp2.trim()),
                                                         Integer.parseInt(temp3.trim()),
                                                         Integer.parseInt(temp4.trim())
                                                        )
                                                        );
                     */
                settings.setJMValue(JMConfig.MAINWINDOW, tempRect);
                
                // jmSections.put("DataBar", "true");
                //sectionFlag = 0;
            } else {
                // Set the variables for the window's
                // initial position and size
                    /*
                    settings.setDataBar(new Rectangle(Integer.parseInt(temp1.trim()),
                                                      Integer.parseInt(temp2.trim()),
                                                      Integer.parseInt(temp3.trim()),
                                                      Integer.parseInt(temp4.trim())
                                                     )
                                                     );
                     */
                
                settings.setJMValue(JMConfig.DATABAR, tempRect);
                
                // settings.setDataBar(tempD);
                // jmSections.put("mainWindow", "true");
                // sectionFlag = 0;
            }
        } catch (Exception mwe) {
            if (DEBUG) {
                System.err.println("Main window error" + mwe);
            }
        }
    }
    
    /**
     * Read in Macro Window's position and size
     */
    // public void macroWindow(String str) {
    private void macroWindow(final int index) {
        
        // Determine the size of the macro-window, and if visible.
        try {
            final Rectangle tempRect = new Rectangle(Integer.parseInt(fileLines[index + 1].trim()),
                    Integer.parseInt(fileLines[index + 2].trim()),
                    Integer.parseInt(fileLines[index + 3].trim()),
                    Integer.parseInt(fileLines[index + 4].trim())
                    );
            // settings.setMacroFrame(tempRect);
            settings.setJMValue(JMConfig.MACROFRAME, tempRect);
            
        } catch (Exception e) {
            if (DEBUG) {
                System.err.println("Error parsing MacroWindow from .rc file");
            }
            return;
        }
    }
    
    /**
     * Set the Font Face for both the input and output windows
     * @param index 
     */
    // public void fontFace(String temp1) {
    public void fontFace(final int index) {
        
        // Try and cast the second two variables into ints
        // temp2 and temp3 are font style and font size respectively
        
        try {
            final int tempInt2 = Integer.parseInt(fileLines[index + 2]);
            final int tempInt3 = Integer.parseInt(fileLines[index + 3]);
            
            // Transfer this information into the font
            // settings.setFontFace(new Font(fileLines[index + 1], tempInt2, tempInt3));
            settings.setJMValue(settings.FONTFACE, new Font(fileLines[index + 1], tempInt2, tempInt3));
            
        } catch (Exception e) {
            // The font section is corrupt
            if (DEBUG) {
                System.err.println("Font section corrupt " + e);
            }
            
            // This section will be expanded for multiple exception types
        }
        
    }
    
    /**
     * Read in the selected external browers/viewers
     * to deal with special file formats, etc.
     */
    private void browser(final int index, final boolean primary) {
        // Assign the browser
        // This section does not check to see if the location is valid or not
        String status = "false";
        final String bLine = fileLines[index + 1];
        
        if (bLine.equals("empty")) {
            temp1 = "";
        } else {
            final int ast = bLine.indexOf("*");
            
            if (ast >= 0) {
                temp1 = bLine.substring(0, ast);
                if (bLine.endsWith("true")) {
                    // status = new String("true");
                    status = "true";
                }
            } else {
                temp1 = "";
            }
        }
        
        
        if (primary) {
            // settings.setBrowser(JMConfig.BROWSER1, temp1);
            settings.setJMValue(JMConfig.BROWSER1, temp1);
            // settings.setBrowserInstance(JMConfig.BROWSER1, status);
            settings.setJMValue(JMConfig.BROWSERINSTANCE1, status);
        } else {
            // settings.setBrowser(JMConfig.BROWSER2, temp1);
            // settings.setBrowserInstance(JMConfig.BROWSER2, status);
            settings.setJMValue(JMConfig.BROWSER2, temp1);
            settings.setJMValue(JMConfig.BROWSERINSTANCE2, status);
        }
    }
    
    private void fTPClient(final int index) {
        // Set the FTP client location
        if (fileLines[index + 1].equals("empty")) {
            // settings.setBrowser(JMConfig.FTPCLIENT, fileLines[index + 1]);
            settings.setJMValue(JMConfig.FTPCLIENT, fileLines[index + 1]);
        } else {
            // settings.setBrowser(JMConfig.FTPCLIENT, "");
            settings.setJMValue(JMConfig.FTPCLIENT, fileLines[index + 1]);
        }
    }
    
    private void eMailClient(final int index) {
        // Set E-Mail Client location
        
        if (fileLines[index + 1].equals("empty")) {
            // settings.setBrowser(JMConfig.EMAILCLIENT, "");
            settings.setJMValue(JMConfig.EMAILCLIENT, "");
        } else {
            // settings.setBrowser(JMConfig.EMAILCLIENT, fileLines[index + 1]);
            settings.setJMValue(JMConfig.EMAILCLIENT, fileLines[index + 1]);
        }
    }
    
    /** Set the Timers key */
    /** This was all wrong!  We need the size of the timer window!!! */
    private void jMTimers(final int index) {
        try {
            
            // We will only get here if there is indeed a 'Timers' section
                /*
                settings.setTimers(new Rectangle(Integer.parseInt(fileLines[index + 1]),
                                                 Integer.parseInt(fileLines[index + 2]),
                                                 Integer.parseInt(fileLines[index + 3]),
                                                 Integer.parseInt(fileLines[index + 4])));
                 */
            settings.setJMValue(JMConfig.TIMERS, new Rectangle(Integer.parseInt(fileLines[index + 1]),
                    Integer.parseInt(fileLines[index + 2]),
                    Integer.parseInt(fileLines[index + 3]),
                    Integer.parseInt(fileLines[index + 4])));
            // settings.setTimersVisible(temp1.toLowerCase());
            settings.setJMValue(JMConfig.TIMERSVISIBLE, temp1.toLowerCase());
        } catch (Exception e) {
            if (DEBUG) {
                System.err.println("Timer exception in .rc file.");
            }
        }
    }
    
    /** Set the SyncWindows key */
    private void jMSyncWindows(final int index) {
        // settings.setSyncWindows(fileLines[index + 1]);
        settings.setJMValue(JMConfig.SYNCWINDOWS, fileLines[index + 1]);
    }
    
    /** Set the TinyFugue Key Emulation item */
    private void jMTFKeyEmu(final int index) {
        // settings.setTFKeyEmu(fileLines[index + 1]);
        settings.setJMValue(settings.TFKEYEMU, fileLines[index + 1]);
    }
    
    /**
     * Determine whether JamochaMUD should use Unicode or ASCII
     * to send strings to the MUD/MUCK Server
     */
    private void jMUseUnicode(final int index) {
        // settings.setUseUnicode(fileLines[index + 1]);
        settings.setJMValue(JMConfig.USEUNICODE, fileLines[index + 1]);
    }
    
    /** Set the DoubleBuffer item */
    private void jMSetDoubleBuffer(final int index) {
        // settings.setDoubleBuffer(fileLines[index + 1]);
        settings.setJMValue(JMConfig.DOUBLEBUFFER, fileLines[index + 1]);
    }
    
    /** Are we using the consolidated view, or the split view? */
    private void jMSetSplitView(final int index) {
        // settings.setSplitView(fileLines[index + 1]);
        settings.setJMValue(JMConfig.SPLITVIEW, fileLines[index + 1]);
    }
    
    private void jMSetReleasePause(final int index) {
        // settings.setReleasePause(fileLines[index + 1]);
        settings.setJMValue(JMConfig.RELEASEPAUSE, fileLines[index + 1]);
    }
    
    private void jMSetAltFocus(final int index) {
        // settings.setAltFocus(fileLines[index + 1]);
        settings.setJMValue(JMConfig.ALTFOCUS, fileLines[index + 1]);
    }
    
    private void jMSetLastMU(final int index) {
        // settings.setLastMU(fileLines[index + 1]);
        settings.setJMValue(JMConfig.LASTMU, fileLines[index + 1]);
    }
    
    private void jMSetLogPath(final int index) {
        settings.setJMValue(JMConfig.LOGPATH, fileLines[index + 1]);
    }
    
    private void jMSetAntiAliasing(final int index) {
        settings.setJMValue(JMConfig.ANTIALIAS, fileLines[index + 1]);
    }
    
    private void jMSetLowColour(final int index) {
        settings.setJMValue(JMConfig.LOWCOLOUR, fileLines[index + 1]);
    }
    
    private void jMSetDivider(final int index) {
        settings.setJMValue(JMConfig.DIVIDERLOCATION, fileLines[index + 1]);
    }
    
    /**
     * Read in and configure proxy support for JamochaMUD
     */
    private void jMSetProxy(final int index) {
        
        // settings.setProxy(fileLines[index + 1].trim());
        settings.setJMValue(JMConfig.PROXY, fileLines[index + 1].trim());
        
        if (fileLines[index + 2].equals("null")) {
            // settings.setProxy(false);
            settings.setJMValue(JMConfig.PROXY, false);
        } else {
            // settings.setProxyHost(fileLines[index + 2]);
            // settings.setProxyPort(fileLines[index + 3]);
            settings.setJMValue(JMConfig.PROXYHOST, fileLines[index + 2]);
            settings.setJMValue(JMConfig.PROXYPORT, fileLines[index + 3]);
        }
        
    }
    
    private void jMAddDefinition(final int index) {
        String temp, name, value;
        int eqSign;
        
        temp = (fileLines[index].substring(4)).trim();
        
        eqSign = temp.indexOf("=");
        name = temp.substring(0, eqSign).trim();
        value = temp.substring(eqSign + 1);
        
        settings.addDefinition(name, value);
    }
    
    private void jMAddVariable(final int index) {
        String temp, name, value;
        int eqSign;
        
        temp = (fileLines[index].substring(4)).trim();
        
        eqSign = temp.indexOf("=");
        name = temp.substring(0, eqSign).trim();
        value = temp.substring(eqSign + 1);
        
        settings.addVariable(name, value);
    }
    
    /**
     * Section to create .jamocha.rc if one doesn't exist.
     * Prompt user to make sure this is okay, if not
     * program will end (can't think of anything else to do, otherwise, hee!)
     */
    public void createRC() {
        // Prompt user that a .jamocha.rc file will be created
        // Vector tempVector = new Vector();
        final anecho.gui.ResReader bundle = new anecho.gui.ResReader(settings.BUNDLEBASE);
        
        boolean createFile = false;
        
        // This is a hack to give the dialogue a "frame" to float above
        workingFrame = new Frame();
        
        // final String message = anecho.gui.AbstractMessageFormat.wrap(bundle.langString("createSettingsFile"));
        final String message = anecho.gui.AbstractMessageFormat.wrap(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("createSettingsFile"));
        
        if (settings.getJMboolean(JMConfig.USESWING)) {
            final int confirm = javax.swing.JOptionPane.showConfirmDialog(workingFrame,
                    //bundle.langArray("createSettingsFile"),
                    message,
                    // bundle.langString("createSettingsFileTitle"),
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("createSettingsFileTitle"),            
                    javax.swing.JOptionPane.OK_CANCEL_OPTION,
                    javax.swing.JOptionPane.INFORMATION_MESSAGE);
            
            if (confirm == javax.swing.JOptionPane.OK_OPTION) {
                createFile = true;
            }
            
        } else {
            // final OKBox check = new OKBox(workingFrame, bundle.langString("createSettingsFileTitle"), true);
            final OKBox check = new OKBox(workingFrame, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("createSettingsFileTitle"), true);
            // Add in some other settings here
            
                /*
                Vector tempText = RBL("createSettingsFile");
                for (int j = 0; j < tempText.size(); j++) {
                    check.append((String)tempText.elementAt(j) + '\n');
                    }
                 */
            check.append(message);
            
            check.addButton(check.OKAY);
            check.addButton(check.CANCEL);
            
            check.setVisible(true);
            if (check.getResult().equals(check.OKAY)) {
                createFile = true;
            }
        }
        
        
        // if (check.getResult().equals(check.OKAY)) {
        if (createFile) {
            // File rcFile = new File(settings.getUserDirectory());
            final File rcFile = new File(settings.getJMString(JMConfig.USERDIRECTORY));
            
            // We'll use this opportunity to set a few defaults, just for the road!
            Rectangle tempRect = new Rectangle(20, 20, 500, 400);
            settings.setJMValue(JMConfig.MAINWINDOW, tempRect);
            tempRect = new Rectangle(20, 440, 500, 100);
            settings.setJMValue(JMConfig.DATABAR, tempRect);
            
            // Local Echo should be on by default (http://www.cryosphere.org/mud-protocol.html)
            settings.setJMValue(JMConfig.LOCALECHO, true);
            // Colours should start as white type on black background (some MU*'s make this assumption)
            settings.setJMValue(JMConfig.BACKGROUNDCOLOUR, new Color(0, 0, 0));
            settings.setJMValue(JMConfig.FOREGROUNDCOLOUR, new Color(255, 255, 255));
            
            // For convenience, we'll turn on the TinyFugue short-cut keys, too
            settings.setJMValue(JMConfig.TFKEYEMU, true);
            
            // Another nicety is having auto-focus to input enabled by default
            settings.setJMValue(JMConfig.AUTOFOCUSINPUT, true);
            // First, we see if the directory exists
            if (!rcFile.exists()) {
                // Create a new user directory
                if (DEBUG) {
                    System.err.println("Creating directory(s): " + rcFile);
                }
                rcFile.mkdirs();
            }
        } else {
            System.exit(0);
        }
    }
    
    /**
     * Add a new Macros section to .jamocha.rc
     */
    public void newMacros() {
        
        String mLabel[] = new String[8];
        String mDef[] = new String[8];
        
        for (int i = 0; i < 8; i++) {
            mLabel[i] = ("Macro" + (i + 1));
            mDef[i] = ("");
        }
        // settings.setMacroLabels(mLabel);
        // settings.setMacroDefs(mDef);
        settings.setJMValue(JMConfig.MACROLABELS, mLabel);
        settings.setJMValue(JMConfig.MACRODEFS, mDef);
        
        // As of 12/09/98, this method has been altered to serialise
        // macros in the .macros.rc file, instead of placing them in
        // the basic .jamocha.rc file
        try {
            // FileOutputStream outputFile = new FileOutputStream(settings.getUserDirectory() + ".macros.rc");
            final FileOutputStream outputFile = new FileOutputStream(settings.getJMString(JMConfig.USERDIRECTORY) + ".macros.rc");
            final ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
            serializeStream.writeObject(mLabel);
            serializeStream.writeObject(mDef);
            serializeStream.flush();
        } catch (Exception e) {
            if (DEBUG) {
                System.err.println("Macro serialization error " + e);
            }
        }
        
    }
    
    /**
     * Read in the serialised macros.  This method, as of 98/12/09 replaces
     * the older method of storing macros in the .jamocha.rc file
     */
    public void readSerialisedMacros() {
        
        try {
            // FileInputStream inputFile = new FileInputStream(settings.getUserDirectory() + ".macros.rc");
            final FileInputStream inputFile = new FileInputStream(settings.getJMString(JMConfig.USERDIRECTORY) + ".macros.rc");
            final ObjectInputStream serializeStream = new ObjectInputStream(inputFile);
            
            // settings.setMacroLabels((String[]) serializeStream.readObject());
            // settings.setMacroDefs((String[]) serializeStream.readObject());
            settings.setJMValue(JMConfig.MACROLABELS, (String[])serializeStream.readObject());
            settings.setJMValue(JMConfig.MACRODEFS, (String[])serializeStream.readObject());
            
        } catch (FileNotFoundException e) {
            // The file does not exist, but will be written later
            // This is not a bad thing
            // We'll create the info needed now:
            newMacros();
        } catch (Exception e) {
            if (DEBUG) {
                System.err.println("Error during serialization " + e);
            }
            // The file probably does not exist
            // We'll create the info needed now:
            newMacros();
        }
        
        // return;
        
    }
    
    /**
     * This is a generic bit to access the
     * ResReader.class, for localization
     * (Multi-language support)
     */
    // This supports multi-line messages
//        private static Vector RBL(String itemTarget) {
//            ResReader reader = new ResReader();
//            return reader.LangVector(JMConfig.BUNDLEBASE, itemTarget);
//        }
    
    
}

