/**
 * JMUD for JamochaMUD is the "main" section for JamochaMUD
 * $Id: JMUD.java,v 1.29 2004/08/03 02:06:40 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;

// import anecho.gui.JMText;
import anecho.gui.JSyncFrame;
import anecho.gui.SyncFrame;
import anecho.gui.SyncFrameGroup;

public class JMUD {

    public static CHandler connections;  // This class will handle all our connections
    public static volatile JMConfig settings;  // This class contains all our settings
    public MuckMain mainProg;          // Our main text window
    public Frame mainFrame;
    // public Frame mainFrame;          // Our main text window
    // public SyncFrame inputFrame;        // A Frame to hold our DataIn class
    public DataIn inputFrame;
    public EnumPlugIns plugEnum;
    public SyncFrameGroup frameGroup;   // Our SyncFrame group
    private Object splash;
    private boolean USESWING = false;
    private static final boolean DEBUG = false;

    /**
     * The main method for JamochaMUD.  This is where it all begins!
     * @param args 
     */
    public static void main(final String[] args) {
        // Create a new instance of our program for your running pleasure!
        final JMUD proggy = new JMUD(args);
        // Bye-bye
    }

    // public void run() {
    /**
     * 
     * @param args 
     */
    public JMUD(String[] args) {

        // Create our "settings" container
        // settings = new JMConfig();
        settings = JMConfig.getInstance();

        // Let's put ourselves in the settings, so we're accessable for a QUIT or somethin'
        settings.setJMCore(this);

        // Set some defaults
        settings.setJMValue(JMConfig.USESWING, true);  // Use Swing components by default
        // settings.setJMValue(JMConfig.USESWINGENTRY, false);  // Java 1.2 and 1.3 requestFocus is "broken"
        settings.setJMValue(JMConfig.USESWINGENTRY, true);  // Java 1.2 and 1.3 requestFocus is "broken"
        settings.setJMValue(JMConfig.BGPAINT, false);    // Paint background on Swing text component

        // Check to see if we're forcing "single user mode" or not
        if (args.length > 0) {
            String tempArg;
            for (int i = 0; i < args.length; i++) {
                // System.out.println("Arguments #" + (i + 1) + ": " + args[i]);
                tempArg = args[i].toLowerCase();
                if (tempArg.equals("-h") || tempArg.equals("-?")) {
                    System.out.println("JamochaMUD " + AboutBox.verNum);
                    System.out.println("A Java MUD/Muck client, (C)2003 Jeff Robinson.");
                    System.out.println();
                    System.out.println("Current accepted arguments:");
                    System.out.println("-h/-?     This screen");
                    System.out.println("-s        Force single-user mode");
                    System.out.println("-swing    Use Java2 Swing components (default)");
                    System.out.println("-noswing  Use only Java 1.1.x AWT components");
                    System.out.println("-nosentry Use Swing except for the text-entry area");
                    System.out.println("-nobg     Do not paint text background colours (default)");
                    System.out.println("-bg       Paint text background colours");
                    System.out.println("-v        Version of the program");
                    System.exit(0);
                }

                if (tempArg.equals("-s")) {
                    // Force single user mode
                    // settings.setSingleUserMode(true);
                    settings.setJMValue(JMConfig.SINGLEUSERMODE, true);
                }

                if (tempArg.equals("-v")) {
                    System.out.println("JamochaMUD " + AboutBox.verNum);
                    System.exit(0);
                }

                if (tempArg.equals("-swing")) {
                    settings.setJMValue(JMConfig.USESWING, true);
                    System.out.println("-swing option is deprecated... enabled by default.");
                }

                if (tempArg.equals("-noswing")) {
                    settings.setJMValue(JMConfig.USESWING, false);
                    settings.setJMValue(JMConfig.USESWINGENTRY, false);
                    System.out.println("Disabling use of Swing components.");
                }

                if (tempArg.equals("-nosentry")) {
                    settings.setJMValue(JMConfig.USESWINGENTRY, false);
                    System.out.println("Using AWT for the text entry area.");
                }

                if (tempArg.equals("-sentry")) {
                    settings.setJMValue(JMConfig.USESWINGENTRY, true);
                    System.out.println("Forcing Swing-based text-entry component.");
                }

                if (tempArg.equals("-nobg")) {
                    settings.setJMValue(JMConfig.BGPAINT, false);
                    System.out.println("Background text painting disabled.");
                }

                if (tempArg.equals("-bg")) {
                    settings.setJMValue(JMConfig.BGPAINT, true);
                    System.out.println("Background text painting enabled.");
                }
            }
        }

        // Test the system to see if Swing is available (if chosen)
        USESWING = settings.getJMboolean(JMConfig.USESWING);

        // if (settings.getJMboolean(JMConfig.USESWING)) {
        if (USESWING) {
            try {
                Class swingTest = Class.forName("javax.swing.JButton");
                if (DEBUG) {
                    System.err.println("Swing test passed..");
                }

                // Try setting the look and feel for testing purposes
                // javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                // javax.swing.UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                // javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");

            } catch (Exception except) {
                System.err.println("Swing is not currently available, switching to use the Java AWT.");
                if (DEBUG) {
                    System.err.println(except);
                }

                settings.setJMValue(JMConfig.USESWING, false);
                settings.setJMValue(JMConfig.USESWINGENTRY, false);
                USESWING = false;
            }
        }

        // Create our SplashScreen
        if (USESWING) {
            splash = (Object)new anecho.gui.SplashScreen(null, "Getting system information", new javax.swing.ImageIcon(JMainMenu.class.getResource("JMUDSplash.png")));
            ((anecho.gui.SplashScreen)splash).setVisible(true);
        }

        // Get our system information
        getSysInfo();

        // Read in our "profile"
        if (USESWING) {
            ((anecho.gui.SplashScreen)splash).updateMessage("Reading JamochaMUD settings...");
        }
        getSettings();

//        // Create a connection handler
        //        connections = new CHandler(this, settings);
        // Read in our plugins
        // plugEnum = new EnumPlugIns(settings);
        // loadPlugins();

        frameGroup = new SyncFrameGroup();
        // Create the frame/frames for JamochaMUD
        // mainFrame = new MuckMain(settings);
        if (USESWING) {
            ((anecho.gui.SplashScreen)splash).updateMessage("Loading main program...");
        }
        mainProg = new MuckMain(settings);
        // mainFrame = (SyncFrame)settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        frameGroup.add(mainFrame);
        // settings.setMainWindowVariable(mainFrame);
        settings.setMainWindowVariable(mainProg);

        // Create a connection handler
        // connections = new CHandler(settings, mainFrame);
        // connections = new CHandler(settings, mainProg);
        connections = new CHandler(mainProg);
        // connections.connectToNewMU();
        settings.setConnectionHandler(connections);

        // inputFrame = new DataIn(settings);
        inputFrame = new DataIn();
        frameGroup.add(inputFrame);
        settings.setDataInVariable(inputFrame);

        // Add our text-window to the main frame
        // mainFrame.setMainLayout();
        mainProg.setMainLayout();

        // Set the visual state of our components
        setupFrames();

        if (USESWING) {
            ((anecho.gui.SplashScreen)splash).updateMessage("Loading plug-ins...");
        }
        loadPlugins();

        // if (settings.getJMboolean(JMConfig.USESWING)) {
        if (USESWING) {
            ((anecho.gui.SplashScreen)splash).setVisible(false);
        }

        connections.connectToNewMU();

        // mainFrame.setVisible(true);
        // inputFrame.setVisible(true);

        // Present the Muck Connector the first time

        // Do any necessary clean-up
        // haltPlugins();
    }

    /** Read in our settings.  We make this a separate method
     * in hopes that it will fall out of scope and destroy our
     * JMParseRC class when it is done... */
    private void getSettings() {
        // We'll pass our 'settings' variable to get things set up correctly
        // new JMParseRC(settings);
        new JMParseRC();
    }

    /** Gather system-specific information about the platform
     * we're running on */
    private void getSysInfo() {
//        new SysInfo(settings);
        new SysInfo();
    }

    /** Setup the visual elements for the user */
    private void setupFrames() {
        settings.setJMValue(JMConfig.MUCKMAINTITLE, "JamochaMUD");

        // Set the size of our windows
        Rectangle tempRect;
        tempRect = settings.getJMRectangle(JMConfig.MAINWINDOW);

        if (tempRect != null) {
            mainFrame.setBounds(settings.getJMRectangle(JMConfig.MAINWINDOW));
        } else {
            mainFrame.setBounds(new Rectangle(0, 10, 600, 355));
        }

        tempRect = settings.getJMRectangle(JMConfig.DATABAR);

        if (tempRect != null) {
            inputFrame.setBounds(settings.getJMRectangle(JMConfig.DATABAR));
        } else {
            inputFrame.setBounds(new Rectangle(0, 385, 600, 60));
        }


        // boolean sync = settings.getSyncWindows();
        boolean sync = false;
        if (settings.getJMboolean(JMConfig.SPLITVIEW)) {
            sync = settings.getJMboolean(JMConfig.SYNCWINDOWS);
        }

        // Do this for now, but fix the setGroupSync function in SyncFrame/SyncGroup!!!
        // Fix me XXX
        // ((SyncFrame)mainFrame).setSyncFrameGroup(frameGroup);
        inputFrame.setSyncFrameGroup(frameGroup);
        // ((SyncFrame)mainFrame).setSync(sync);
        inputFrame.setSync(sync);

        // Create our area that will hold our output "windows"
        if (settings.getJMboolean(JMConfig.USESWING)) {
            if (DEBUG) {
                System.out.println("Swing being used by JMUD.");
            }
            ((JSyncFrame)mainFrame).setSyncFrameGroup(frameGroup);
            ((JSyncFrame)mainFrame).setSync(sync);
        } else {
            if (DEBUG) {
                System.out.println("We're not using swing in JMUD.");
            }
            // anecho.JamochaMUD.legacy.JMTabPanel textPanel = new anecho.JamochaMUD.legacy.JMTabPanel();
            ((SyncFrame)mainFrame).setSyncFrameGroup(frameGroup);
            ((SyncFrame)mainFrame).setSync(sync);
        }

    }

    private void loadPlugins() {
        // plugEnum = new EnumPlugIns(settings);
//        plugEnum = EnumPlugIns.getInstance(settings);
        plugEnum = EnumPlugIns.getInstance();
        settings.setPlugEnumerator(plugEnum);
        plugEnum.loadPlugIns(splash);
    }

    /** Tell our plug-ins that we are shutting down, so they better save their data! */
    private void haltPlugins() {
        plugEnum.haltPlugIns();
    }

    /** This method collects all the data needed to write
     * a new .rc file of the user's settings, and do
     * any other necessary clean-up */
    public void quitJamochaMUD() {
        // Gather all our settings that remain.
        Rectangle test;

        test = mainFrame.getBounds();
        if (checkVisible(test)) {
            // settings.setMainWindow(test);
            settings.setJMValue(JMConfig.MAINWINDOW, test);
            
        }

        test = inputFrame.getBounds();
        if (checkVisible(test)) {
            // settings.setDataBar(test);
            settings.setJMValue(JMConfig.DATABAR, test);
        }

        // final JMWriteRC done = new JMWriteRC(settings);
           final JMWriteRC done = new JMWriteRC();
        done.writeRCToFile();

        haltPlugins();

        System.exit(0);
    }

    /** Check the bounds of our rectangle to see if it is visible
     * or not.  This is basically a hack, but better'n nothing.
     */
    private boolean checkVisible(final Rectangle testRect) {
        int xAxis, yAxis;   // Our location on the screen
        boolean retVal = true;
        xAxis = testRect.x;
        yAxis = testRect.y;

        if (xAxis < 0 || yAxis < 0) {
            // Our object is probably minimised, so use the settings from JMConfig
            retVal = false;
        }

        // Our object is probably visible on-screen, so we'll return true
        return retVal;
    }

    /**
     * Change our fonts globally across all windows
     * @param newStyle 
     */
    public void setAllFonts(final Font newStyle) {
        // Change the font style of all our connections
        connections.setAllFonts(newStyle);

        // Change the font style of the input bar
        inputFrame.setFont(newStyle);
    }

    /**
     * Change our colours globally across all windows
     * @param foreground 
     * @param background 
     */
    public void setAllColours(final Color foreground, final Color background) {
        // Change the colours of our connections
        connections.setAllColours(foreground, background);

        // set the colour of our input frame
        inputFrame.setBackgroundColour(background);
        inputFrame.setForegroundColour(foreground);
    }

    /**
     * Change the synchronisation status of our windows
     * @param sync 
     */
    public void setAllSync(final boolean sync) {
        // settings.setSyncWindows(sync);
        // Only change our Sync value if we're using split panes
        if (settings.getJMboolean(JMConfig.SPLITVIEW)) {
            settings.setJMValue(JMConfig.SYNCWINDOWS, sync);
            ((SyncFrame)mainFrame).setSync(sync);
            inputFrame.setSync(sync);
}
    }

    /** Change the main title */
    public void setMainWindowTitle() {
        // settings.setMuckMainTitle(title);
        // mainFrame.setWindowTitle();
        mainProg.setWindowTitle();
        inputFrame.setWindowTitle();
    }
}
