/**
 * WriteRC, a replacement for WriteINI (January 17, 1999)
 * Write .jamocha.rc from all information available
 * $Id: JMWriteRC.java,v 1.18 2004/07/28 03:13:05 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.Color;
// import java.awt.Frame;
import java.awt.Font;
import java.awt.Rectangle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

import java.util.Hashtable;
// import java.util.Properties;
import java.util.Vector;

/**
 * WriteRC, a replacement for WriteINI (January 17, 1999)
 * Write .jamocha.rc and from all
 * from all information available
 * @version $Id: JMWriteRC.java,v 1.18 2004/07/28 03:13:05 jeffnik Exp $
 * @author Jeff Robinson
 */
public class JMWriteRC{
    
    private boolean readLoop;
    // private File renamedFile;//, oldFile;
    private FileOutputStream outFile;
    // private Hashtable jmSections;
    private PrintWriter out;
    // private String str;
    // private RandomAccessFile file;
    private Vector newFile; // oldRC;
    private JMConfig settings;
    private String jmTempFile = ".jamocha.rc.temp";
    private String empty = "empty";
    private String space = " ";
    private static final boolean DEBUG = false;
    
    /**
     * 
     */
    public JMWriteRC() {
        // public JMWriteRC(JMConfig mainSettings){
        // this.settings = mainSettings;
        this.settings = JMConfig.getInstance();
    }
    
    public synchronized void writeRCToFile() {
        // jmSections = new Hashtable();
        
        readLoop = true;
        // oldRC = new Vector(0, 1);
        newFile = new Vector(0, 1);
        
        // First make sure the vector is empty
        newFile.removeAllElements();
        
        // addObj the new information to the new vector
        jMBuildNewRC();
        
        // Delete the old temporary file if it exists
        try {
            // File orig = new File(settings.getUserDirectory() + jmTempFile);
            final File orig = new File(settings.getJMString(JMConfig.USERDIRECTORY) + jmTempFile);
            orig.delete();
        } catch (Exception exc) {
            System.out.println("Execption deleting old temporary file.");
        }
        
        // Now it is time to write this information to a new temp file
        try {
            // outFile = new FileOutputStream(settings.getUserDirectory() + jmTempFile, false);
            outFile = new FileOutputStream(settings.getJMString(JMConfig.USERDIRECTORY) + jmTempFile, false);
            out = new PrintWriter(outFile, true);
            
            // Loop through until all the information is written out
            for (int i = 0; i<newFile.size(); i++) {
                out.println(newFile.elementAt(i).toString());
            }
            outFile.close();
        } catch (Exception exc) {
            System.out.println("JMWriteRC: (outFile) Exception generated : " + exc);
            exc.printStackTrace();
        }
        
        // We've written the temporary file.
        // now copy this file onto the original after erasing the previous version
        try {
            // File delFile = new File(settings.getUserDirectory() + ".jamocha.rc");
            final File delFile = new File(settings.getJMString(JMConfig.USERDIRECTORY) + ".jamocha.rc");
            delFile.delete();
        } catch (Exception exc) {
            System.out.println("Error deleting old .jamocha.rc");
        }
        
        try {
            // RandomAccessFile fromFile = new RandomAccessFile(settings.getUserDirectory() + jmTempFile, "r");
            final RandomAccessFile fromFile = new RandomAccessFile(settings.getJMString(JMConfig.USERDIRECTORY) + jmTempFile, "r");
            // RandomAccessFile toFile = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc", "rw");
            final RandomAccessFile toFile = new RandomAccessFile(settings.getJMString(JMConfig.USERDIRECTORY) + ".jamocha.rc", "rw");
            int fileData;
            // while((fileData = fromFile.read()) >= 0){
            fileData = fromFile.read();
            while(fileData >= 0){
                toFile.write(fileData);
                fileData = fromFile.read();
            }
            
            try {
                toFile.close();
            } catch (Exception fcexc) {
                System.out.println("JMWriteRC: toFile.close exception");
            }
            
            try {
                fromFile.close();
            } catch (Exception fcexc) {
                System.out.println("JMWriteRC: fromFile.close exception");
            }
            
        } catch (Exception exc) {
            System.out.println("JMWriteRC: Renaming file exception : " + exc);
        }
        
        // We have successfully written the .rc file
        // and it is now safe to delete the temp file
        try {
            // File tempFile = new File(settings.getUserDirectory() + jmTempFile);
            final File tempFile = new File(settings.getJMString(JMConfig.USERDIRECTORY) + jmTempFile);
            tempFile.delete();
        } catch (Exception delexc) {
            System.out.println("Temp file delete exception " + delexc);
        }
        
        // Last but not least, lets serialise the macros
        serialiseMacros();
        
    }
    
    // These section will each write the data for their relevant area
    /**
     * Write the list of worlds out to .jamocha.rc
     */
    private void writeWorlds() {
        
        Vector muckName = new Vector(0, 1);
        Vector muckAddy = new Vector(0, 1);
        Vector muckPort = new Vector(0, 1);
        // muckName = settings.getMuckName();
        // muckAddy = settings.getMuckAddy();
        // muckPort = settings.getMuckPort();
        muckName = settings.getJMVector(JMConfig.MUCKNAME);
        muckAddy = settings.getJMVector(JMConfig.MUCKADDY);
        muckPort = settings.getJMVector(JMConfig.MUCKPORT);
        
        // loop through until all worlds are gone
        for (int i = 0; i < muckName.size(); i++) {
            newFile.addElement("[" + JMConfig.WORLD + "]");
            // addObj all the world elements to the vector
            
            try {
                addObj(muckName.elementAt(i));
                addObj(muckAddy.elementAt(i));
                addObj(muckPort.elementAt(i));
            } catch (Exception exc) {
                System.out.println("JMWriteRC: Exception writing worlds " + exc);
            }
            
            newFile.addElement("");
        }
        
        // jmSections.put("MUWorlds", "false");
    }
    
    /**
     * Write the foreground colour of the text areas out to .jamocha.rc
     */
    private void writeForegroundColour() {
        // Get the colour of the font from the window
        // Color tempColour = MuckMain.mainText.getForeground();
        // Color tempColour = settings.getForegroundColour();
        final Color tempColour1 = settings.getJMColor(settings.FOREGROUNDCOLOUR);
            /*
            Color tempColour2 = settings.getJMColor(settings.BACKGROUNDCOLOUR);
             
            // Make certain our two colours are not the same!
            if (tempColour1 == tempColour2) {
                int red, green, blue;
                red = tempColour1.getRed();
                blue = tempColour1.getBlue();
                green = tempColour1.getGreen();
                red = red + 128;
                if (red > 255) {
                    red = red - 255;
                }
                green = green + 128;
                if (green > 255) {
                    green = green -255;
                }
             
                blue = blue + 128;
                if (blue > 255) {
                    blue = blue - 255;
                }
                tempColour1 = new Color(red, green, blue);
                }
             */
        
        addObj("[" + JMConfig.FOREGROUNDCOLOUR + "]");
        Add(tempColour1.getRed());
        Add(tempColour1.getGreen());
        Add(tempColour1.getBlue());
        addObj("");
        // jmSections.put("ForegroundColour", "false");
    }
    
    /**
     * Write out the text area's background colours to .jamocha.rc
     */
    private void writeBackgroundColour() {
        // Get the colour of the font from the window
        //Color tempColour = MuckMain.mainText.getBackground();
        // Color tempColour = settings.getBackgroundColour();
        final Color tempColour1 = settings.getJMColor(settings.BACKGROUNDCOLOUR);
            /*
            Color tempColour2 = settings.getJMColor(settings.FOREGROUNDCOLOUR);
             
            if (tempColour1 == tempColour2) {
                int red, green, blue;
                red = tempColour1.getRed();
                blue = tempColour1.getBlue();
                green = tempColour1.getGreen();
                red = red + 128;
                if (red > 255) {
                    red = red - 255;
                }
                green = green + 128;
                if (green > 255) {
                    green = green -255;
                }
             
                blue = blue + 128;
                if (blue > 255) {
                    blue = blue - 255;
                }
                tempColour1 = new Color(red, green, blue);
                }
             */
        
        addObj("[" + JMConfig.BACKGROUNDCOLOUR + "]");
        Add(tempColour1.getRed());
        Add(tempColour1.getGreen());
        Add(tempColour1.getBlue());
        addObj("");
        // jmSections.put("BackgroundColour", "false");
    }
    
    /**
     * Write out the dimension and location of the Main (output) window
     */
    private void writeMainWindow() {
        newFile.addElement("[" + JMConfig.MAINWINDOW + "]");
        
        // writeRect(settings.getMainWindow());
        writeRect(settings.getJMRectangle(JMConfig.MAINWINDOW));
        
        addObj("");
        // jmSections.put("MainWindow", "false");
    }
    
    /**
     * Write the size and location of the databar (input) window to .jamocha.rc
     */
    private void writeDataBar() {
        addObj("[" + JMConfig.DATABAR + "]");
        
        // writeRect(settings.getDataBar());
        writeRect(settings.getJMRectangle(JMConfig.DATABAR));
        addObj("");
        // jmSections.put("DataBar", "false");
    }
    
    /**
     * Write the size and position of the Macro Window out to .jamocha.rc
     */
    private void writeMacroWindow() {
        
        // These two lines will be correct regardless
        addObj("[" + JMConfig.MACROFRAME + "]");
        
        if (settings.getJMboolean(JMConfig.MACROVISIBLE)) {
            addObj("true");
        } else {
            addObj("false");
        }
        // writeRect(settings.getMacroFrame());
        final Rectangle tempRect = settings.getJMRectangle(JMConfig.MACROFRAME);
        if (tempRect != null) {
            writeRect(settings.getJMRectangle(JMConfig.MACROFRAME));
        }
        // MacroBar isn't visible, so use the
        // information provided from the
        // static variables
        addObj("");
        // jmSections.put("MacroWindow", "false");
    }
    
    /**
     * Write the style of font used in the text areas to .jamocha.rc
     */
    private void writeFontFace() {
        addObj("[" + JMConfig.FONTFACE + "]");
        // Font temp = settings.getFontFace();
        final Font temp = settings.getJMFont(settings.FONTFACE);
        addObj(temp.getName());
        Add(temp.getStyle());
        Add(temp.getSize());
        addObj("");
        // jmSections.put("FontFace", "false");
    }
    
    /**
     * Stub from the old version of .jamocha.rc, since macros are no longer
     * contained with the .jamocha.rc, instead having their own .plugins.rc
     */
    // private void WriteMacros() {
    // }
    
    /**
     * Write the browser locations to the .jamocha.rc file
     * @param number 
     */
    public void writeBrowser(final String number) {
        if (number.equals("1")) {
            addObj("[" + JMConfig.BROWSER1 + "]");
            try {
                // String temp1 = settings.getBrowser("Browser1");
                final String temp1 = settings.getJMString(JMConfig.BROWSER1);
                if (temp1.equals("")) {
                    addObj(empty);
                } else {
                    // String status = new String();
                    // if (settings.getBrowserInstance("Browser1")) {
                    // if (settings.getBrowserInstance(JMConfig.BROWSER1)) {
                    if (settings.getJMboolean(JMConfig.BROWSERINSTANCE1)) {
                        // status = "true";
                        addObj(temp1 + "*true");
                    } else {
                        // status = "false";
                        addObj(temp1 + "*false");
                    }
                    // addObj(temp1 + "*" + status);
                }
            } catch (Exception exc) {
                addObj(empty);
            }
            
        } else {
            addObj("[" + JMConfig.BROWSER2 + "]");
            try {
                // String temp1 = new String(settings.getBrowser("Browser2"));
                // String temp1 = new String(settings.getBrowser(JMConfig.BROWSER2));
                final String temp1 = new String(settings.getJMString(JMConfig.BROWSER2));
                if (temp1.equals("")) {
                    // temp1 = new String(empty);
                    addObj(empty);
                } else {
                    // String status = new String();
                    // if (settings.getBrowserInstance("Browser2")) {
                    //if (settings.getBrowserInstance(JMConfig.BROWSER2)) {
                    if (settings.getJMboolean(JMConfig.BROWSERINSTANCE1)) {
                        // status = "true";
                        addObj(temp1 + "*true");
                    } else {
                        // status = "false";
                        addObj(temp1 + "*false");
                    }
                    // addObj(temp1 + "*" + status);
                }
            } catch (Exception exc) {
                addObj(empty);
            }
        }
        
        addObj("");
    }
    
    /**
     * Write the FTP Client location out to .jamocha.rc
     */
    public void writeFTPClient() {
        addObj("[" + JMConfig.FTPCLIENT + "]");
        
        // addObj the configured client
        try {
            // String temp1 = new String(settings.getBrowser("FTPClient"));
            // String temp1 = new String(settings.getBrowser(JMConfig.FTPCLIENT));
            String temp1 = settings.getJMString(JMConfig.FTPCLIENT);
            if (temp1.equals("")) {
                temp1 = empty;
            }
            addObj(temp1);
        } catch (Exception exc) {
            addObj(empty);
        }
        
        addObj(space);
        
    }
    
    /**
     * Write the location of the E-mail client out to .jamocha.rc
     */
    public void writeEMailClient() {
        addObj("[" + JMConfig.EMAILCLIENT + "]");
        
        try {
            // String temp1 = settings.getBrowser("EMailClient");
            String temp1 = settings.getJMString(JMConfig.EMAILCLIENT);
            if (temp1.equals("")) {
                temp1 = empty;
            }
            addObj(temp1);
        } catch (Exception exc) {
            addObj(empty);
        }
        
        addObj(space);
        
    }
    
    public void jMTimers() {
        addObj("[" + JMConfig.TIMERS + "]");
        // if (settings.getTimersVisible()) {
        if (settings.getJMboolean(JMConfig.TIMERSVISIBLE)) {
            addObj("true");
            // writeRect(Timers.timerFrame.getBounds());
        } else {
            addObj("false");
            // writeRect(settings.getTimers());
        }
        // writeRect(settings.getTimers());
        final Rectangle tempRect = settings.getJMRectangle(JMConfig.TIMERS);
        if (tempRect != null) {
            writeRect(tempRect);
        }
        
        addObj(space);
    }
    
        /*
         public void JMSyncWindows() {
         addObj("[SyncWindows]");
         // addObj(settings.getSyncWindows() + "");
         addObj(settings.getJMboolean(JMConfig.SYNCWINDOWS) + "");
         addObj(space);
         }
         */
    
        /*
        public void JMTFKeyEmu() {
                addObj("[TFKeyEmu]");
                // addObj(settings.getTFKeyEmu() + "");
                addObj(settings.getJMboolean(JMConfig.TFKEYEMU) + "");
                addObj(space);
                }
         */
    
    /**
     * Write the user's preference to using Unicode or ASCII to .jamocha.rc
     */
        /*
        public void JMUseUnicode() {
                addObj("[Unicode]");
                // addObj(settings.getUseUnicode() + "");
                addObj(settings.getJMboolean(JMConfig.USEUNICODE) + "");
                addObj(space);
                }
         */
    
    /** Write the double-buffer setting */
        /*
        public void JMDoubleBuffer() {
            addObj("[DoubleBuffer]");
            //addObj(settings.getDoubleBuffer() + "");
            addObj(settings.getJMboolean(JMConfig.DOUBLEBUFFER) + "");
            addObj(space);
            }
         */
    
    /** Write out the view state, split (true) or combined (false) */
        /*
        public void JMSplitView() {
            addObj("[SplitView]");
            // addObj(settings.getSplitView() + "");
            addObj(settings.getJMboolean(JMConfig.SPLITVIEW) + "");
            addObj(space);
            }
         */
    
    /** Write out the &quot;Release pause on copy" option */
        /*
        public void JMReleasePause() {
            addObj("[ReleasePause]");
            // addObj(settings.getReleasePause() + "");
            addObj(settings.getJMboolean(JMConfig.RELEASEPAUSE) + "");
            addObj(space);
            }
         */
    
    /** Write out the Alt-focus option */
        /*
        public void JMAltFocus() {
            addObj("[AltFocus]");
            // addObj(settings.getAltFocus() + "");
            addObj(settings.getJMboolean(JMConfig.ALTFOCUS) + "");
            addObj(space);
            }
         */
    
    /**
     * Serialise the user's macros to the .macros.rc file.
     * This replaces the old method of WriteMacros
     */
    public void serialiseMacros() {
        // This new method (as of 12/09/98) will serialise the macro
        // labels and their associated actions
        try {
            // FileOutputStream outputFile = new FileOutputStream(settings.getUserDirectory() + ".macros.rc");
            final FileOutputStream outputFile = new FileOutputStream(settings.getJMString(JMConfig.USERDIRECTORY) + ".macros.rc");
            final ObjectOutputStream sStream = new ObjectOutputStream(outputFile);
            // sStream.writeObject(settings.getMacroLabels());
            // sStream.writeObject(settings.getMacroDefs());
            sStream.writeObject(settings.getJMStringArray(JMConfig.MACROLABELS));
            sStream.writeObject(settings.getJMStringArray(JMConfig.MACRODEFS));
            sStream.flush();
        } catch (Exception exc) {
            System.out.println("(JMWriteRC) Macro serialization error " + exc);
        }
        
    }
    
    /**
     * Write out the user's preference to Auto Focus Input (the MUD client
     * automagicall shifting focus to the input box (Databar) when they type
     */
        /*
        private void JMWriteAutoFocusInput() {
                addObj("[AutoFocusInput]");
                // addObj(settings.getAutoFocusInput() + "");
                addObj(settings.getJMboolean(settings.AUTOFOCUSINPUT) + "");
                addObj("");
                // jmSections.put("AutoFocusInput", "false");
                }
         */
    
    /** Write out our Local Echo variable */
        /*
        private void JMWriteLocalEcho() {
            addObj("[LocalEcho]");
            // addObj(settings.isLocalEchoEnabled() + "");
            addObj(settings.getJMboolean(JMConfig.LOCALECHO) + "");
            addObj("");
            // jmSections.put(settings.LOCALECHO, "false");
            }
         */
    
    /**
     * Write out the proxy information to the .jamocha.rc file
     */
    private void jMWriteProxy() {
        addObj("[" + JMConfig.PROXY + "]");
        
        // if (settings.getProxy()) {
        if (settings.getJMboolean(JMConfig.PROXY)) {
            addObj("true");
        } else {
            addObj("false");
        }
        // if (settings.getProxyHost().equals("null") || settings.getProxyHost().equals("")) {
        if ((settings.getJMString(JMConfig.PROXYHOST)).equals("null") || (settings.getJMString(JMConfig.PROXYHOST)).equals("")) {
            addObj("null");
        } else {
            // addObj(settings.getProxyHost());
            addObj(settings.getJMString(JMConfig.PROXYHOST));
            // addObj(settings.getProxyPort() + "");
            Add(settings.getJMint(JMConfig.PROXYPORT));
        }
        
        addObj("");
        // jmSections.put(settings.PROXY, "false");
    }
    
        /*
        private void JMWriteLastMU() {
            addObj("[LastMU]");
            // addObj(settings.getLastMU());
            addObj(settings.getJMString(JMConfig.LASTMU));
            addObj("");
        }
         
        private void JMWriteLogPath() {
        addObj("[LogPath]");
        addObj(settings.getJMString(JMConfig.LOGPATH));
        addObj("");
        }
         */
    
    private void JMWriteCustomPalette() {
        java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
        // java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(JMConfig.class);
        if (DEBUG) {
            System.err.println("JMWriteRC writing custom palette from " + prefs);
        }
        
        Color[] newPal = (Color[])settings.getJMObject(JMConfig.CUSTOMPALETTE);
        if (newPal != null) {
            for (int i = 0; i<16; i++) {
                prefs.putInt("Palette" + i, newPal[i].getRGB());
            }
        } else {
            if (DEBUG) {
                System.err.println("JMWriteRC: The custom palette was null");
            }
        }
    }
    
    private void jMWriteEntry(final String title, final String value) {
        addObj("[" + title + "]");
        addObj(value);
        // jMWriteEntry("[LogPath]", settings.getJMString(JMConfig.LOGPATH));
        addObj("");
    }
    
    private void jMWriteVariables() {
        final Hashtable vars = settings.getAllVariables();
        String name, value;
        
        final java.util.Enumeration keys = vars.keys();
        
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            value = vars.get(name).toString();
            addObj("/set " + name + "=" + value);
        }
    }
    
    private void jMWriteDefinitions() {
        final Hashtable vars = settings.getAllDefinitions();
        String name, value;
        
        final java.util.Enumeration keys = vars.keys();
        
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            value = vars.get(name).toString();
            addObj("/def " + name + "=" + value);
        }
    }
    
    /**
     * Build the new .jamocha.rc file, first filling a vector with
     * the necessary information sections, and then writing
     * it out to the actual file
     */
    private void jMBuildNewRC() {
        // Build the new .rc vector
        // First, empty the newFile vector
        newFile.removeAllElements();
        
        /* Version identifier */
        addObj("# JamochaMUD INI file version 1.1");
        
        writeWorlds();
        writeForegroundColour();
        writeBackgroundColour();
        writeMainWindow();
        writeDataBar();
        writeMacroWindow();
        writeFontFace();
        jMWriteProxy();
        
        // addObj "constant" items
        jMTimers();
        // JMWriteAutoFocusInput();
        jMWriteEntry(JMConfig.AUTOFOCUSINPUT, settings.getJMString(JMConfig.AUTOFOCUSINPUT));
        jMWriteEntry(JMConfig.AUTOLOGGING, settings.getJMString(JMConfig.AUTOLOGGING));
        // JMWriteLocalEcho();
        jMWriteEntry(JMConfig.LOCALECHO, settings.getJMString(JMConfig.LOCALECHO));
        // JMSyncWindows();
        jMWriteEntry(JMConfig.SYNCWINDOWS, settings.getJMString(JMConfig.SYNCWINDOWS));
        // JMUseUnicode();
        jMWriteEntry(JMConfig.USEUNICODE, settings.getJMString(JMConfig.USEUNICODE));
        // JMTFKeyEmu();
        jMWriteEntry(JMConfig.TFKEYEMU, settings.getJMString(JMConfig.TFKEYEMU));
        // JMDoubleBuffer();
        jMWriteEntry(JMConfig.DOUBLEBUFFER, settings.getJMString(JMConfig.DOUBLEBUFFER));
        // JMSplitView();
        jMWriteEntry(JMConfig.SPLITVIEW, settings.getJMString(JMConfig.SPLITVIEW));
        // JMReleasePause();
        jMWriteEntry(JMConfig.RELEASEPAUSE, settings.getJMString(JMConfig.RELEASEPAUSE));
        // JMAltFocus();
        jMWriteEntry(JMConfig.ALTFOCUS, settings.getJMString(JMConfig.ALTFOCUS));
        jMWriteEntry(JMConfig.ANTIALIAS, settings.getJMString(JMConfig.ANTIALIAS));
        jMWriteEntry(JMConfig.LOWCOLOUR, settings.getJMString(JMConfig.LOWCOLOUR));
        jMWriteEntry(JMConfig.DIVIDERLOCATION, settings.getJMString(JMConfig.DIVIDERLOCATION));
        
        // now add the External programs
        writeBrowser("1");
        writeBrowser("2");
        writeFTPClient();
        writeEMailClient();
        
        // Some system defined variables
        // JMWriteLastMU();
        jMWriteEntry(JMConfig.LASTMU, settings.getJMString(JMConfig.LASTMU));
        // JMWriteLogPath();
        jMWriteEntry(JMConfig.LOGPATH, settings.getJMString(JMConfig.LOGPATH));
        
        // Now some user defined variables and definitions
        jMWriteVariables();
        jMWriteDefinitions();
        
        /** Write out any Java 1.2-specific items */
        if (settings.getJMboolean(JMConfig.USESWING)) {
            JMWriteCustomPalette();
        }
    }
    
    /** A method to add Objects (as strings) to the newFile vector */
    private void addObj(Object newForVector) {
        newFile.addElement(newForVector.toString());
    }
    
    /**
     * Any primitive integers must first be wrappered and then sent to 'addObj(Object)'
     */
    private void Add(int convertInt) {
        addObj(new Integer(convertInt));
    }
    
    /** A common method to write 'rectangles' to the .rc file */
    private void writeRect(Rectangle source) {
        Add((source.getLocation()).x);
        Add((source.getLocation()).y);
        Add(source.getSize().width);
        Add(source.getSize().height);
    }
}
