/**
 * JMainMenu.java, the main menu for JamochaMUD made of Swing components
 * $Id: JMainMenu.java,v 1.5 2004/07/28 03:13:05 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * vesion 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

// import java.awt.MenuShortcut;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import javax.swing.KeyStroke;

import javax.swing.ImageIcon;

import anecho.gui.ResReader;

/** Create a menu for the Main Window */
public class JMainMenu {

    private static JMainMenu _instance;  // We'll try playing with a Singleton!

    private JMenuBar tWMenuBar;
    private JCheckBoxMenuItem tWMacro, tWSyncWindowsItem, tWUseUnicodeItem, tWTFKeysItem, tWLocalEchoItem;
    private JCheckBoxMenuItem splitFramesItem;
    private JCheckBoxMenuItem tWAutoFocus, tWTimers, tWReleasePauseItem, tWAltFocus, tWAntiAliasItem, tWLowColourItem;
    private JMenu tWMUListMenu;
    private JMenuItem cTM, dFM, rTM, closeMU;
    private JMenuItem dumpOutputItem, quitItem;
    private JMenuItem pingMUItem;
    private JMenuItem copyItem, pasteItem, findItem;
    private JMenuItem configItem;
    private JMenuItem coloursItem, externalProgramsItem;
    private JMenuItem serverOptionsItem;
    private JMenuItem contentsItem, tfKeysItem, troubleshootingItem, aboutJamochaMUDItem;
    private JMenuItem installPlugIn, removePlugIn;
    private JMConfig settings;
    protected static JMenu tWPlugInMenu;

    private static final int COMBINED = 0;     // Combined frame style
    private static final int SPLIT = 1;        // Split frame style

    private int viewStyle;

    private ResReader reader;

    private static final boolean DEBUG = false;

    private JMainMenu() {
        reader = new ResReader();
    }

    // For lazy initialization
    /**
     * 
     * @return 
     */
    public static synchronized JMainMenu getInstance() {
        if (_instance==null) {
            _instance = new JMainMenu();
        }
        return _instance;
    }

    /**
     * 
     * @param parent 
     * @param mainProg 
     */
//    public void buildMenu(JFrame parent, MuckMain mainProg, JMConfig settings) {
    public void buildMenu(final JFrame parent, final MuckMain mainProg) {
        // this.settings = settings;
        settings = JMConfig.getInstance();
        tWMenuBar = new JMenuBar();

        parent.setJMenuBar(tWMenuBar);

        final JMenu tWFileMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("file"));
        tWFileMenu.setMnemonic(KeyEvent.VK_F);
        tWMenuBar.add(tWFileMenu);

        dumpOutputItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("dumpOutput"), new ImageIcon(JMainMenu.class.getResource("icons/22/filesave.png")));
        dumpOutputItem.setMnemonic(KeyEvent.VK_D);
        // dumpOutputItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
        dumpOutputItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));
        // dumpOutputItem = buildMenuItem("dumpOutput",            // Name of item
        // "icons/22/filesave.png", // Item icon
        // KeyEvent.VK_D,           // Mnemonic
        // true,                    // Has an accelerator?
        // KeyEvent.VK_D,           // Accelerator key
        // true);                   // use CTRL?

        tWFileMenu.add(dumpOutputItem);
        // new MenuShortcut(KeyEvent.VK_D, false)));
        dumpOutputItem.setActionCommand(dumpOutputItem.getText());
        dumpOutputItem.addActionListener(mainProg);

        tWFileMenu.addSeparator();
        tWFileMenu.add(quitItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("quit"), new ImageIcon(JMainMenu.class.getResource("icons/22/exit.png"))));
        quitItem.setMnemonic(KeyEvent.VK_Q);
        quitItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.CTRL_MASK));
        quitItem.setActionCommand(quitItem.getText());
        quitItem.addActionListener(mainProg);

        tWFileMenu.addActionListener(mainProg);

        // Add the Edit menu items
        final JMenu tWEditMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("edit"));
        tWEditMenu.setMnemonic(KeyEvent.VK_E);
        tWMenuBar.add(tWEditMenu);
        // I'm making it the right key for OS/2, damn't!
        // if (settings.getOSName().equals("OS/2")) {
        if ((settings.getJMString(JMConfig.OSNAME)).equals("OS/2")) {
        // if (settings.getJMString(settings.OSNAME).equals("OS/2")) {
            copyItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("copyFromMainWindow"), new ImageIcon(JMainMenu.class.getResource("icons/22/editcopy.png")));
            copyItem.setMnemonic(KeyEvent.VK_C);
            copyItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_INSERT, ActionEvent.CTRL_MASK));
        } else {
            copyItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("copyFromMainWindow"), new ImageIcon(JMainMenu.class.getResource("icons/22/editcopy.png")));
            copyItem.setMnemonic(KeyEvent.VK_C);
            copyItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        }
        copyItem.setActionCommand(copyItem.getText());
        copyItem.addActionListener(mainProg);
        tWEditMenu.add(copyItem);

        pasteItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("paste"), new ImageIcon(JMainMenu.class.getResource("icons/22/editpaste.png")));
        pasteItem.setMnemonic(KeyEvent.VK_P);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, ActionEvent.CTRL_MASK));
        pasteItem.setActionCommand(pasteItem.getText());
        pasteItem.addActionListener(mainProg);
        tWEditMenu.add(pasteItem);

        tWEditMenu.addSeparator();

        findItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("find"), new ImageIcon(JMainMenu.class.getResource("icons/22/find.png")));
        findItem.setMnemonic(KeyEvent.VK_F);
        findItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, ActionEvent.CTRL_MASK));
        findItem.setActionCommand(findItem.getText());
        findItem.addActionListener(mainProg);
        findItem.setEnabled(false);
        tWEditMenu.add(findItem);
        tWEditMenu.addActionListener(mainProg);


        // Add CONNECTION menu items
        final JMenu tWConnectMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("connection"));
        tWConnectMenu.setMnemonic(KeyEvent.VK_C);
        tWMenuBar.add(tWConnectMenu);
        cTM = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("connectToMU"), new ImageIcon(JMainMenu.class.getResource("icons/22/connect_established.png")));
        cTM.setMnemonic(KeyEvent.VK_C);
        cTM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        cTM.setActionCommand(cTM.getText());
        cTM.addActionListener(mainProg);
        tWConnectMenu.add(cTM);

        rTM = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("reconnectToMU"), new ImageIcon(JMainMenu.class.getResource("icons/22/reload.png")));
        rTM.setMnemonic(KeyEvent.VK_R);
        rTM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
        rTM.setActionCommand(rTM.getText());
        rTM.addActionListener(mainProg);
        tWConnectMenu.add(rTM);

        dFM = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("disconnectFromMU"), new ImageIcon(JMainMenu.class.getResource("icons/22/connect_no.png")));
        dFM.setMnemonic(KeyEvent.VK_D);
        dFM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, ActionEvent.CTRL_MASK));
        dFM.setActionCommand(dFM.getText());
        dFM.addActionListener(mainProg);
        dFM.setEnabled(false);
        tWConnectMenu.add(dFM);

        closeMU = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("closeThisView"), new ImageIcon(JMainMenu.class.getResource("icons/22/round_stop.png")));
        closeMU.setMnemonic(KeyEvent.VK_V);
        closeMU.addActionListener(mainProg);
        closeMU.setEnabled(false);
        tWConnectMenu.add(closeMU);

        /*
        tWConnectMenu.add(pingMUItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("pingMU")));
        pingMUItem.addActionListener(mainProg);
        pingMUItem.setEnabled(false);
        tWConnectMenu.addActionListener(mainProg);
        */

        final JMenu tWOptionMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("options"));
        tWOptionMenu.setMnemonic(KeyEvent.VK_O);
        tWMenuBar.add(tWOptionMenu);

        tWOptionMenu.add(configItem = new JMenuItem("Configure JamochaMUD", new ImageIcon(JMainMenu.class.getResource("icons/22/configure.png"))));
        configItem.setMnemonic(KeyEvent.VK_C);
        // configItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        configItem.setActionCommand(configItem.getText());
        configItem.addActionListener(mainProg);
        
        // Add ****Edit Options**** Submenu
        final JMenu tWEditOptionsMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editOptions"));
        tWEditOptionsMenu.setMnemonic(KeyEvent.VK_E);
        tWOptionMenu.add(tWEditOptionsMenu);
        tWEditOptionsMenu.add(externalProgramsItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("externalPrograms"), new ImageIcon(JMainMenu.class.getResource("icons/22/configure.png"))));
        externalProgramsItem.setMnemonic(KeyEvent.VK_E);
        externalProgramsItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, ActionEvent.CTRL_MASK));
        externalProgramsItem.setActionCommand(externalProgramsItem.getText());
        externalProgramsItem.addActionListener(mainProg);

        installPlugIn = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("installPlugin"), new ImageIcon(JMainMenu.class.getResource("icons/22/fileexport.png")));
        installPlugIn.setMnemonic(KeyEvent.VK_I);
        installPlugIn.setActionCommand(installPlugIn.getText());
        installPlugIn.addActionListener(mainProg);

        removePlugIn = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("removePlugin"));
        removePlugIn.setMnemonic(KeyEvent.VK_R);
        removePlugIn.setEnabled(false);
        removePlugIn.setActionCommand(removePlugIn.getText());
        removePlugIn.addActionListener(mainProg);

        tWEditOptionsMenu.add(serverOptionsItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("serverOptions"), new ImageIcon(JMainMenu.class.getResource("icons/22/configure.png"))));
        serverOptionsItem.setMnemonic(KeyEvent.VK_S);
        tWEditOptionsMenu.addActionListener(mainProg);
        serverOptionsItem.addActionListener(mainProg);

        final JMenu tWDisplayOptionsMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("displayOptions"));
        tWOptionMenu.add(tWDisplayOptionsMenu);

        tWDisplayOptionsMenu.add(coloursItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("fontsAndColours"), new ImageIcon(JMainMenu.class.getResource("icons/22/fonts.png"))));
        coloursItem.setMnemonic(KeyEvent.VK_F);
        coloursItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, ActionEvent.CTRL_MASK));
        coloursItem.setActionCommand(coloursItem.getText());
        coloursItem.addActionListener(mainProg);

        tWAntiAliasItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("antiAlias"), true);
        tWDisplayOptionsMenu.add(tWAntiAliasItem);
        tWAntiAliasItem.setState(settings.getJMboolean(JMConfig.ANTIALIAS));
        tWAntiAliasItem.addItemListener(mainProg);
        
        tWLowColourItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Low_colour_display"), false);
        tWDisplayOptionsMenu.add(tWLowColourItem);
        tWLowColourItem.setState(settings.getJMboolean(JMConfig.LOWCOLOUR));
        tWLowColourItem.addItemListener(mainProg);

        // Continue with normal option menu
        tWOptionMenu.addSeparator();

        tWMacro = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("showMacroBar"), false);
        tWOptionMenu.add(tWMacro);
        tWMacro.addItemListener(mainProg);
        tWMacro.setEnabled(false);

        tWTimers = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("showTimers"), false);
        tWTimers.setMnemonic(KeyEvent.VK_T);
        tWTimers.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, ActionEvent.CTRL_MASK));
        tWTimers.setActionCommand(tWTimers.getText());
        tWOptionMenu.add(tWTimers);
        tWTimers.addItemListener(mainProg);
        tWTimers.addActionListener(mainProg);
        // Fix mainProg XXX!!  Right now we have no option for timers at all
        tWTimers.setEnabled(false);

        splitFramesItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("splitFrames"), false);
        tWOptionMenu.add(splitFramesItem);

        if (settings.getJMboolean(JMConfig.SPLITVIEW)) {
            viewStyle = SPLIT;
            splitFramesItem.setState(true);
        } else {
            viewStyle = COMBINED;
        }
        splitFramesItem.addItemListener(mainProg);

        tWSyncWindowsItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("syncWindows"), true);
        tWOptionMenu.add(tWSyncWindowsItem);
        // Set this to false for now, as it breaks things in the current incarnation
        // Fix this XXX!
        // tWSyncWindowsItem.setState(settings.getJMboolean(JMConfig.SYNCWINDOWS));
        tWSyncWindowsItem.setState(false);
        tWSyncWindowsItem.setEnabled(false);
        tWSyncWindowsItem.addItemListener(mainProg);

        tWOptionMenu.addSeparator();

        tWAutoFocus = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("autoFocusInput"), true);
        tWOptionMenu.add(tWAutoFocus);
        tWAutoFocus.setState(settings.getJMboolean(settings.AUTOFOCUSINPUT));
        tWAutoFocus.addItemListener(mainProg);

        tWAltFocus = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("altFocus"), true);
        tWOptionMenu.add(tWAltFocus);
        tWAltFocus.setState(settings.getJMboolean(JMConfig.ALTFOCUS));
        if (!splitFramesItem.getState()) {
            tWAltFocus.setEnabled(false);
        }
        tWAltFocus.addItemListener(mainProg);

        tWLocalEchoItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("localEcho"), true);
        tWOptionMenu.add(tWLocalEchoItem);
        tWLocalEchoItem.setState(settings.getJMboolean(JMConfig.LOCALECHO));
        tWLocalEchoItem.addItemListener(mainProg);

        tWReleasePauseItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("releasePause"), true);
        tWOptionMenu.add(tWReleasePauseItem);
        tWReleasePauseItem.setState(settings.getJMboolean(JMConfig.RELEASEPAUSE));
        tWReleasePauseItem.addItemListener(mainProg);

        tWTFKeysItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("tinyFugueKeys"), true);
        tWOptionMenu.add(tWTFKeysItem);
        tWTFKeysItem.setState(settings.getJMboolean(settings.TFKEYEMU));
        tWTFKeysItem.addItemListener(mainProg);

        tWUseUnicodeItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("useUnicode"), false);
        tWOptionMenu.add(tWUseUnicodeItem);
        tWUseUnicodeItem.setState(settings.getJMboolean(settings.USEUNICODE));
        tWUseUnicodeItem.addItemListener(mainProg);

        tWUseUnicodeItem = new JCheckBoxMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("autoLogging"), false);
        tWOptionMenu.add(tWUseUnicodeItem);
        tWUseUnicodeItem.setState(settings.getJMboolean(settings.AUTOLOGGING));
        tWUseUnicodeItem.addItemListener(mainProg);

        // Add the ActionListener to mainProg menu
        tWOptionMenu.addActionListener(mainProg);


        // Add the Plug-in menu items
        tWPlugInMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("plugIn"));
        tWPlugInMenu.setMnemonic(KeyEvent.VK_P);
        tWMenuBar.add(tWPlugInMenu);
        tWPlugInMenu.addActionListener(mainProg);

        // List for our active MU*s
        tWMUListMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MUList"));
        tWMUListMenu.setMnemonic(KeyEvent.VK_M);
        tWMenuBar.add(tWMUListMenu);
        tWMUListMenu.addActionListener(mainProg);

        //Add HELP menu items
        final JMenu tWHelpMenu = new JMenu(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("help"));
        tWHelpMenu.setMnemonic(KeyEvent.VK_H);
        tWMenuBar.add(tWHelpMenu);
        /*
        tWHelpMenu.add(contentsItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("contents"), new ImageIcon(JMainMenu.class.getResource("icons/22/contents.png"))));
        contentsItem.setMnemonic(KeyEvent.VK_H);
        contentsItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, ActionEvent.CTRL_MASK));
        contentsItem.setActionCommand(contentsItem.getText());
        contentsItem.addActionListener(mainProg);
        */

        tWHelpMenu.add(troubleshootingItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("reportABug"), new ImageIcon(JMainMenu.class.getResource("icons/22/contents.png"))));
        troubleshootingItem.addActionListener(mainProg);
        tWHelpMenu.add(tfKeysItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("tinyFugueKeyCodes"), new ImageIcon(JMainMenu.class.getResource("icons/22/contents.png"))));
        tfKeysItem.addActionListener(mainProg);


        tWHelpMenu.addSeparator();
        tWHelpMenu.add(aboutJamochaMUDItem = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("aboutJamochaMUD"), new ImageIcon(JMainMenu.class.getResource("kehza.gif"))));
        aboutJamochaMUDItem.addActionListener(mainProg);
        tWHelpMenu.addActionListener(mainProg);

    }

    /**
     * 
     * @param state 
     */
    public synchronized void setCloseMUEnabled(final boolean state) {
        closeMU.setEnabled(state);
    }

    /**
     * This method removes all plug-in entries from the plug-ins menu
     */
    public void removeAllPlugins() {
        tWPlugInMenu.removeAll();
        tWPlugInMenu.add(installPlugIn);
        tWPlugInMenu.add(removePlugIn);
        tWPlugInMenu.addSeparator();
    }

    /**
     * 
     * @param plug 
     */
    public void addPlugin(final anecho.JamochaMUD.plugins.PlugInterface plug) {

        if (DEBUG) {
            System.err.println("JMainMenu.addPlugin: " + plug);
            System.err.println("JMainMenu adding plug-in: " + plug.plugInName());
        }

        final String name = plug.plugInName();
        final boolean state = plug.isActive();
        final boolean properties = plug.hasProperties();

        final JMenu tempName = new JMenu(name);
        if (state) {
            tempName.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/Sphere_Green.png")));
        } else {
            tempName.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/Sphere_Red.png")));
        }

        final JMenuItem prop = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("properties"));
        prop.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/configure.png")));

        if (properties) {
            prop.setActionCommand("plugin:" + name);
            prop.addActionListener(settings.getMainWindowVariable());
        } else {
            // No settings are available for this item
            prop.setEnabled(false);
        }

        final JMenuItem action = new JMenuItem();
        // Check to see if we should offer the enable or disable menu item
        if (state) {
            action.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("disable"));
            action.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/button_cancel.png")));
            action.setActionCommand("disable:" + name);
        } else {
            action.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("enable"));
            action.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/button_ok.png")));
            action.setActionCommand("enable:" + name);
        }

        action.addActionListener(settings.getMainWindowVariable());

        final JMenuItem desc = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("description"), new ImageIcon(JMainMenu.class.getResource("icons/22/info.png")));
        desc.setActionCommand("description:" + name);
        desc.addActionListener(settings.getMainWindowVariable());

        tempName.add(prop);
        tempName.add(action);
        tempName.addSeparator();
        tempName.add(desc);

        tWPlugInMenu.add(tempName);

    }

    /** This method allows the plug-in and menu items to be updated to reflect
     * the current state of the plug-in.
     * @param state     the new state of our plug-in
     * @param actCom    the action-command we use to locate our menu item
     * true means the plug-in is active
     * false means the plug-in is inactive
     */
    public void changePlugInState(final boolean state, final String actCom) {
        if (DEBUG) {
            System.err.println("JMainMenu.changePlugInState() called.");
        }

        /*
        if (state) {
            action.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("disable"));
            action.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/button_cancel.png")));
            action.setActionCommand("disable:" + name);
        } else {
            action.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("enable"));
            action.setIcon(new ImageIcon(JMainMenu.class.getResource("icons/22/button_ok.png")));
            action.setActionCommand("enable:" + name);
            }
            */

    }

    /**
     * 
     * @param mainProg 
     */
    public void updateConnectionMenu(final MuckMain mainProg) {
        final MuckMain mainVar = settings.getMainWindowVariable();

        // First, check to see if we have any connections.
        // If not, then we don't need to do any more here
        if (DEBUG) {
            System.err.println("JMainMenu.updateConnectionMenu: checking total connections");
        }

        final CHandler connHandler = settings.getConnectionHandler();
        final int totalCon = connHandler.totalConnections();

        if (DEBUG) {
            System.err.println("JMainMenu.updateConnectionMenu: total connections successful");
        }

        // if (connHandler.totalConnections() < 1) {
        if (totalCon < 1) {
            return;
        }


        // Clear the current list of MU*'s
        tWMUListMenu.removeActionListener(mainVar);
        tWMUListMenu.removeAll();

        // Add the two generic entries... the next and previous choices
        StringBuffer tempName;
        JMenuItem tempMenu;

        tempMenu = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("previousMU"), new ImageIcon(JMainMenu.class.getResource("icons/22/1leftarrow.png")));
        tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, ActionEvent.CTRL_MASK));
        tempMenu.setActionCommand(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("previousMU"));
        tempMenu.addActionListener(mainProg);

        if (DEBUG) {
            System.err.println("JMainMenu.updateConnectionMenu: checking total connections.");
        }


        if (totalCon < 2) {
            tempMenu.setEnabled(false);
        }

        if (DEBUG) {
            System.err.println("JmainMenu.updateConnectionMenu: completd checking total connections.");
        }

        tWMUListMenu.add(tempMenu);

        tempMenu = new JMenuItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("nextMU"), new ImageIcon(JMainMenu.class.getResource("icons/22/1rightarrow.png")));
        tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, ActionEvent.CTRL_MASK));
        tempMenu.setActionCommand(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("nextMU"));
        tempMenu.addActionListener(mainProg);
        if (totalCon < 2) {
            tempMenu.setEnabled(false);
        }
        tWMUListMenu.add(tempMenu);

        tWMUListMenu.addSeparator();

        final int tlist = totalCon - 1;
        final int activeConnection = connHandler.getActiveMUIndex();

        // Loop through our connections and build a new menu
        for (int i = 0; i <= tlist; i++) {
            if (DEBUG) {
                System.err.println("JMainMenu: Getting muck name for menu.");
            }

            tempName = new StringBuffer(connHandler.getTitle(i));

            if (DEBUG) {
                System.err.println("JMainMenu: Menu name: " + tempName);
            }

            if (i == activeConnection) {
                // This is our active MU*
                // We'll just differentiate with a check beside it's name
                tWMUListMenu.add(new JCheckBoxMenuItem(tempName.toString(), true));
            } else {
                tempMenu = new JMenuItem(tempName.toString());
                tempMenu.addActionListener(mainProg);

                switch(i) {
                case 0:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.CTRL_MASK));
                    break;
                case 1:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2, ActionEvent.CTRL_MASK));
                    break;
                case 2:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3, ActionEvent.CTRL_MASK));
                    break;
                case 3:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_4, ActionEvent.CTRL_MASK));
                    break;
                case 4:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_5, ActionEvent.CTRL_MASK));
                    break;
                case 5:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_6, ActionEvent.CTRL_MASK));
                    break;
                case 6:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_7, ActionEvent.CTRL_MASK));
                    break;
                case 7:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_8, ActionEvent.CTRL_MASK));
                    break;
                case 8:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_9, ActionEvent.CTRL_MASK));
                    break;
                case 9:
                    tempMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_0, ActionEvent.CTRL_MASK));
                    break;
                default:
                    break;
                }

                tempMenu.setActionCommand("ChangeMU:" + i);
                tempMenu.addActionListener(mainVar);
                tWMUListMenu.add(tempMenu);
            }
        }

        tWMUListMenu.addActionListener(mainVar);

    }

    /**
     * Set the menus to reflect if we're connected (true) or not (false)
     * @param state 
     */
    public void setConnected(final boolean state) {
        // This changes the flags on the MuckMain menu to 'connected'
        // Connect to MU*
        cTM.setEnabled(true);
        // Disconnect from MU*
        dFM.setEnabled(state);
        // Reconnect to MU*
        rTM.setEnabled(!state);
    }

    /**
     * 
     * @return 
     */
    public boolean isAutoFocus() {
        return tWAutoFocus.getState();
    }

    /**
     * 
     * @return 
     */
    public boolean isReleasePause() {
        return tWReleasePauseItem.getState();
    }

//    private String RB(String itemTarget) {
//        return reader.langString(anecho.JamochaMUD.JMConfig.BUNDLEBASE, itemTarget);
//    }

}