/*
 * MuckConn.java
 *
 * Created on April 30, 2005, 9:32 PM
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;


/**
 *
 * @author  jeffnik
 */
public class MuckConn extends javax.swing.JDialog {
    
    /**
     * Creates new form MuckConn
     * @param settings 
     */
    public MuckConn(JMConfig settings) {
        super(settings.getJMFrame(JMConfig.MUCKMAINFRAME), true);
        this.settings = settings;
        editName = settings.getJMVector(JMConfig.MUCKNAME);
        editAddy = settings.getJMVector(JMConfig.MUCKADDY);
        editPort = settings.getJMVector(JMConfig.MUCKPORT);
        
        initComponents();
        
        java.awt.Point tPoint = anecho.gui.PosTools.findCenter();
        java.awt.Dimension tSize= this.size();
        this.setLocation(tPoint.x - (int)(tSize.width/2) , tPoint.y - (int)(tSize.height/2));
        
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jmMUNames = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        connButton = new javax.swing.JButton();
        addB = new javax.swing.JButton();
        removeB = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        editB = new javax.swing.JButton();
        dontB = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUDConnector"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        compileNames();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jmMUNames, gridBagConstraints);

        connButton.setMnemonic('C');
        connButton.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("connect"));
        connButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connButtonActionPerformed(evt);
            }
        });

        jPanel1.add(connButton);

        addB.setMnemonic('A');
        addB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addBActionPerformed(evt);
            }
        });

        jPanel1.add(addB);

        removeB.setMnemonic('R');
        removeB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("removeMU"));
        removeB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeBActionPerformed(evt);
            }
        });

        jPanel1.add(removeB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jPanel1, gridBagConstraints);

        editB.setMnemonic('E');
        editB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        editB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editBActionPerformed(evt);
            }
        });

        jPanel2.add(editB);

        dontB.setMnemonic('D');
        dontB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("dontConnect"));
        dontB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dontBActionPerformed(evt);
            }
        });

        jPanel2.add(dontB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jPanel2, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void dontBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dontBActionPerformed
        dontConnect();
    }//GEN-LAST:event_dontBActionPerformed

    private void editBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editBActionPerformed
        editMU();
    }//GEN-LAST:event_editBActionPerformed

    private void removeBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeBActionPerformed
        removeMU();
    }//GEN-LAST:event_removeBActionPerformed

    private void addBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addBActionPerformed
        addMU();
    }//GEN-LAST:event_addBActionPerformed

    private void connButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connButtonActionPerformed
        connectToMU();
    }//GEN-LAST:event_connButtonActionPerformed
                        
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
        
        // If the main window is not visible then we'll terminate the program.
        if (!(settings.getJMFrame(settings.MUCKMAINFRAME)).isVisible()) {
            System.exit(0);
        }
    }//GEN-LAST:event_closeDialog
    
    /**
     * Call the methods necessary for the user to add
     * a new MUD/MUCK to the list of worlds
     */
    private void addMU() {
        
        boolean okaySelect = false;
            String jmEditName = "";
            String jmEditAddy = "";
            String jmEditPort = "";
        
        // Call the AddEdit box
        final AddEdit addMU = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addMU.setLocation(anecho.gui.PosTools.findCenter(this, addMU));
        addMU.setVisible(true);
        okaySelect = addMU.isOkay();
            jmEditName = addMU.getName();
            jmEditAddy = addMU.getAddress();
            jmEditPort = addMU.getPort();
       
        
//        if (addMU.isOkay()) {
        if (okaySelect) {
//            String jmEditName = addMU.getName();
//            String jmEditAddy = addMU.getAddress();
//            String jmEditPort = addMU.getPort();
            
            jmEditName.trim();
            jmEditAddy.trim();
            jmEditPort.trim();
            
            if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
                // Check to see if the first entry is a 'valid'
                // MU*, or just a place-marker
                if ((settings.getJMVector(JMConfig.MUCKNAME)).size() < 1) {
                    jmMUNames.removeAll();
                }
                
                // Add the new entry to the list of available MU*s
                editName.addElement(jmEditName);
                editAddy.addElement(jmEditAddy);
                editPort.addElement(jmEditPort);
                jmMUNames.addItem(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")");
                // Put new vector into the hashtable
                settings.setJMValue(JMConfig.MUCKNAME, editName);
                settings.setJMValue(JMConfig.MUCKADDY, editAddy);
                settings.setJMValue(JMConfig.MUCKPORT, editPort);
                
                // Display new MU* in choice
                // jmMUNames.select(jmMUNames.getItemCount() - 1);
                jmMUNames.setSelectedIndex(jmMUNames.getItemCount() - 1);
                connButton.requestFocus();
                
                
            }
        }
        
    }
    
    /**
     * Remove the currently selected MUD/MUCK from the list
     * of available worlds (and the .jamocha.rc file).
     */
    private void removeMU() {
        // Remove MU* from list
        java.util.Vector muckName = new java.util.Vector(0, 1);
        java.util.Vector muckAddy = new java.util.Vector(0, 1);
        java.util.Vector muckPort = new java.util.Vector(0, 1);
        
        muckName = settings.getJMVector(JMConfig.MUCKNAME);
        muckAddy = settings.getJMVector(JMConfig.MUCKADDY);
        muckPort = settings.getJMVector(JMConfig.MUCKPORT);
        
        muckName.removeElementAt(jmMUNames.getSelectedIndex());
        muckAddy.removeElementAt(jmMUNames.getSelectedIndex());
        muckPort.removeElementAt(jmMUNames.getSelectedIndex());
        
        if (muckName.size() < 1) {
            jmMUNames.removeAll();
            muckName.addElement("None");
            muckAddy.addElement(blank);
            muckPort.addElement(blank);
            jmMUNames.addItem("None (" + blank + " Port: " + blank + ")");
        } else {
            // jmMUNames.remove(jmMUNames.getSelectedIndex());
            jmMUNames.removeItemAt(jmMUNames.getSelectedIndex());
        }
        
        // Now place the vectors back in the Hashtable
        settings.setJMValue(JMConfig.MUCKNAME, muckName);
        settings.setJMValue(JMConfig.MUCKADDY, muckAddy);
        settings.setJMValue(JMConfig.MUCKPORT, muckPort);
    }
    
    /**
     * The user has opted to connect to the currently selected
     * MUD/MUCK, so we honour their wishes here!
     */
    private void connectToMU() {
        
        java.util.Vector tempAddy = new java.util.Vector(0, 1);
        java.util.Vector tempPort = new java.util.Vector(0, 1);
        
        tempAddy = settings.getJMVector(JMConfig.MUCKADDY);
        tempPort = settings.getJMVector(JMConfig.MUCKPORT);
        
        if (tempAddy.size() < 1) {
            // We don't have any valid MU*'s listed
            return;
        }
        
        if (DEBUG) {
            System.err.println("MuckConn.JMConnectToMU setVisible(false)");
        }
        
        final java.awt.Frame mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        
        if (!mainFrame.isVisible()) {
            mainFrame.setVisible(true);
        }
        
        final int selection = jmMUNames.getSelectedIndex();
        
        chosenName = editName.elementAt(selection).toString();
        finalAddress = tempAddy.elementAt(selection).toString();
        chosenPort = (Integer.parseInt(tempPort.elementAt(selection).toString()));
        
        settings.setJMValue(JMConfig.CONNMUCK, finalAddress);
        settings.setJMValue(JMConfig.CONNPORT, chosenPort);
        settings.setJMValue(JMConfig.LASTMU, jmMUNames.getSelectedItem());
        
        setVisible(false);
        
        // We only want to set the Main Layout once
        if (!settings.getJMboolean(JMConfig.MAINLAYOUTVALID)) {
            (settings.getMainWindowVariable()).setMainLayout();
        }
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        if (DEBUG) {
            System.err.println("MuckConn.JMConnectToMU returning focus to main frame.");
        }
        
        mainFrame.requestFocus();
        
    }
    
    /**
     * Call the methods to allow the user to edit the MUD/MUCK
     * Name/address/port of the currently selected world
     */
    private void editMU() {
        // edit current MU* entry
        final AddEdit editBox = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        
        final int index = jmMUNames.getSelectedIndex();
        editBox.setName((String)editName.elementAt(index));
        editBox.setAddress((String)editAddy.elementAt(index));
        editBox.setPort((String)editPort.elementAt(index));
        editBox.setLocation(anecho.gui.PosTools.findCenter(this, editBox));
        editBox.setVisible(true);
        
        // Call the AddEdit box
        
        if (editBox.isOkay()) {
            final String jmEditName = editBox.getName();
            final String jmEditAddy = editBox.getAddress();
            final String jmEditPort = editBox.getPort();
            
            jmEditName.trim();
            jmEditAddy.trim();
            jmEditPort.trim();
            
            if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
                // Replace the edited MU* info
                editName.removeElementAt(index);
                editAddy.removeElementAt(index);
                editPort.removeElementAt(index);
                
                editName.insertElementAt(jmEditName, index);
                editAddy.insertElementAt(jmEditAddy, index);
                editPort.insertElementAt(jmEditPort, index);
                
                // Put new vector into the hashtable
                settings.setJMValue(JMConfig.MUCKNAME, editName);
                settings.setJMValue(JMConfig.MUCKADDY, editAddy);
                settings.setJMValue(JMConfig.MUCKPORT, editPort);
                
                // Replace the choice entry
                jmMUNames.remove(index);
                // jmMUNames.insert(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", index);
                // jmMUNames.select(index);
                jmMUNames.insertItemAt(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", index);
                jmMUNames.setSelectedIndex(index);
                connButton.requestFocus();
                
            }
        }
    }
    
    /**
     * Compile the MU* names
     * and then write them into the
     * choice of jmMCFrame
     */
    private void compileNames() {
        // First grab the vectors
        java.util.Vector muckAddy = new java.util.Vector(0, 1);
        java.util.Vector muckName = new java.util.Vector(0, 1);
        java.util.Vector muckPort = new java.util.Vector(0, 1);
        
        muckName = settings.getJMVector(JMConfig.MUCKNAME);
        muckAddy = settings.getJMVector(JMConfig.MUCKADDY);
        muckPort = settings.getJMVector(JMConfig.MUCKPORT);
        
        /* We have no listed MU*'s, so we'll put in a default */
        if (muckName.size() < 1) {
            muckName.addElement("None");
            muckAddy.addElement(blank);
            muckPort.addElement(blank);
        }
        
        for (int i=0; i < muckName.size(); i++) {
            jmMUNames.addItem(muckName.elementAt(i) + " (" + muckAddy.elementAt(i) + " Port: " + muckPort.elementAt(i) + ")");
        }
        
        
        // Set the 'focus' on the last-selected MU*
        if (settings.getJMString(JMConfig.LASTMU) != null) {
            // jmMUNames.select(settings.getJMString(JMConfig.LASTMU));
            jmMUNames.setSelectedItem(settings.getJMString(JMConfig.LASTMU));
        }
        
    }
    
    /**
     *
     * @return
     */
    public String getName() {
        return chosenName;
    }
    
    /**
     *
     * @return
     */
    public String getAddress() {
        return finalAddress;
    }
    
    /**
     *
     * @return
     */
    public int getPort() {
        return chosenPort;
    }
    
    private void dontConnect() {
        setVisible(false);
        
        final java.awt.Frame mmFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        if (!mmFrame.isVisible()) {
            mmFrame.setVisible(true);
        }
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        // Send the focus to out main program... just a nice thing to do
        mmFrame.requestFocus();
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addB;
    private javax.swing.JButton connButton;
    private javax.swing.JButton dontB;
    private javax.swing.JButton editB;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JComboBox jmMUNames;
    private javax.swing.JButton removeB;
    // End of variables declaration//GEN-END:variables
    private java.util.Vector editName = new java.util.Vector(0, 1);
    private java.util.Vector editAddy = new java.util.Vector(0, 1);
    private java.util.Vector editPort = new java.util.Vector(0, 1);
    private JMConfig settings;
    private static final boolean DEBUG = false;
    private String chosenName = null;
    private String finalAddress = null;
    private int chosenPort;
    private String blank = "----";
}
