/*
 * CustomColour.java
 *
 * Created on December 10, 2005, 3:28 AM
 */

package anecho.JamochaMUD.PrefPanels.CustomColours;

import anecho.JamochaMUD.CHandler;
import anecho.JamochaMUD.JMConfig;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author  jeffnik
 */
public class CustomColour extends javax.swing.JPanel implements anecho.JamochaMUD.PrefPanels.PrefInterface {
// public class CustomColour extends anecho.JamochaMUD.PrefPanels.PrefInterface {
    
    /** Creates new form CustomColour */
     public CustomColour() {
//    private CustomColour() {
        if (DEBUG) {
            System.err.println("Creating new CustomColour instance");
        }
  //       initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        colourTable = new javax.swing.JTable(new colourTableModel());
        colourTable.setDefaultRenderer(Color.class, new ColourCellRenderer());
        colourTable.setDefaultEditor(Color.class, new ColourCellEditor());
        resetAll = new javax.swing.JButton();
        standardButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setBackground(javax.swing.UIManager.getDefaults().getColor("InternalFrame.activeTitleBackground"));
        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("Custom output colour");
        jLabel1.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jLabel1, gridBagConstraints);

        setPrefPaletteColours();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(colourTable, gridBagConstraints);

        resetAll.setText("Reset All");
        resetAll.setToolTipText("Reset all colours to current palette");
        resetAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetAllActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(resetAll, gridBagConstraints);

        standardButton.setText("Standard Colours");
        standardButton.setToolTipText("Change colours to \"standard\" ANSI colours");
        standardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                standardButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(standardButton, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void resetAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetAllActionPerformed
        // Reset the colours the most recent colour settings
        setPrefPaletteColours();
    }//GEN-LAST:event_resetAllActionPerformed

    private void standardButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_standardButtonActionPerformed
        // Set the current palette to the standard colours
        setStandardColours();
    }//GEN-LAST:event_standardButtonActionPerformed
    
    /**
     * This method is required by our Interface to return a human-readable title for
     * our module.
     * @return A string representing the human-readable name of our module.
     */
    public String getModuleName() {
        final String retStr = "Custom Colours";
        return retStr;
    }
    
    /**
     * 
     * @return 
     */
    public JPanel loadPanel() {
        // Check to see if components have already been initialised
        if (colourTable == null) {
            if (DEBUG) {
                System.err.println("CustomColour.Loading new panel");
            }
            // Initialise our components
            initComponents();
            
            // Setup the colours in our table
            setPrefPaletteColours();
        } else {
            if (DEBUG) {
                System.err.println("CustomColour.Panel already loaded");
            }
        }
        
        return this;
    }
    
    /**
     * Save the settings for this module
     */
    public void applySettings() {
        if (DEBUG) {
            System.err.println("CustomColour.applySettings() has been called.");
        }
        setNewPaletteColours();
    }
    
    class colourTableModel extends AbstractTableModel {
        private String[] columnNames = {"Colour",
                "Normal",
                "Bold"};
                private Object[][] data = {
                    {"Black", new Color(153, 0, 153), new Color(153, 0, 153)},
                    {"Red", new Color(51, 51, 153), new Color(153, 0, 153)},
                    {"Green", new Color(51, 102, 51), new Color(153, 0, 153)},
                    {"Yellow", Color.red, new Color(153, 0, 153)},
                    {"Blue", Color.red, new Color(153, 0, 153)},
                    {"Magenta", Color.red, new Color(153, 0, 153)},
                    {"Cyan", Color.red, new Color(153, 0, 153)},
                    {"White", Color.pink, new Color(153, 0, 153)}
                };
                
                /**
                 * This method returns the number of columns in our table.
                 * @return Number of columns in our table
                 */
                public int getColumnCount() {
                    final int cCount = columnNames.length;
                    
                    return cCount;
                }
                
                /**
                 * This method returns the number of rows in our table.
                 * @return Number of rows in our table.
                 */
                public int getRowCount() {
                    final int rCount = data.length;
                    
                    return rCount;
                }
                
                /**
                 * 
                 * @param row 
                 * @param col 
                 * @return 
                 */
                public Object getValueAt(final int row, final int col) {
                    final Object retObj = data[row][col];
                    
                    return retObj;
                }
                
        /*
         * JTable uses this method to determine the default renderer/
         * editor for each cell.  If we didn't implement this method,
         * then the last column would contain text ("true"/"false"),
         * rather than a check box.
         */
                /**
                 * 
                 * @param col 
                 * @return 
                 */
                public Class getColumnClass(final int col) {
                    final Class retClass = getValueAt(0, col).getClass();
                    return retClass;
                }
                
                /**
                 * This method returns a boolean indicating whether this cell may be edited.
                 * @param row The row of our selected table cell.
                 * @param col The column of our selected table cell.
                 * @return This boolean represents whether the cell may be:
                 * <CODE>true</CODE> edited
                 * <CODE>false</CODE> not edited
                 */
                public boolean isCellEditable(final int row, final int col) {
                    boolean retVal = true;
                    
                    if (col < 1) {
                        retVal = false;
                    }
                    
                    return retVal;
                }
                
                /**
                 * This method sets the value for a given cell in our table.
                 * @param value This object represents the value that our table cell should contain.
                 * @param row This represents the table row of our selected cell.
                 * @param col This represents the table column of our selected cell.
                 */
                public void setValueAt(final Object value, final int row, final int col) {
                    
                    data[row][col] = value;
                    fireTableCellUpdated(row, col);
                    
                }
                
    }
    
    private void setPrefPaletteColours() {
        final JMConfig settings = JMConfig.getInstance();
        java.awt.Color[] newPal = (Color[])settings.getJMObject(JMConfig.CUSTOMPALETTE);
        
        if (newPal == null) {
            if (DEBUG) {
                System.err.println("We got a null result for JMConfig.CUSTOMPALETTE");
            }
            final CHandler handler = settings.getConnectionHandler();
            final anecho.gui.JMSwingText jmst = handler.getActiveMUDSwingText();
            if (jmst != null) {
                newPal = jmst.getCurrentPalette();
            } else {
                final anecho.gui.JMSwingText tempText = new anecho.gui.JMSwingText();
                newPal = tempText.getCurrentPalette();
                
                if (DEBUG) {
                    System.err.println("PrefDialogue.setPrefPaletteColours: we have no active connections" +
                            "creating a temporary JMSwingText to get a palette.");
                }
            }
        }
        
        if (newPal == null) {
            if (DEBUG) {
                System.err.println("PrefDialogue.setPrefPaletteColours returned null");
            }
            return;
        }
        
        int xCol, yCol;
        final colourTableModel mtm = (colourTableModel)colourTable.getModel();
        
        for (int i = 0; i < 16; i++) {
            if (i < 8) {
                xCol = 1;
                yCol = i;
            } else {
                xCol = 2;
                yCol = i - 8;
            }
            
            mtm.setValueAt(newPal[i], yCol, xCol);
        }
    }
    
    private void setNewPaletteColours() {
        // This should be written to a configuration file, or our settings
        final JMConfig settings = JMConfig.getInstance();
        final CHandler handler = settings.getConnectionHandler();
        
        // Collect the colours
        Color[] newPal = new Color[16];
        int xCol, yCol;
        final colourTableModel mtm = (colourTableModel)colourTable.getModel();
        
        for (int i = 0; i < 16; i++) {
            if (i < 8) {
                xCol = 1;
                yCol = i;
            } else {
                xCol = 2;
                yCol = i - 8;
            }
            newPal[i] = (Color)mtm.getValueAt(yCol, xCol);
            if (DEBUG) {
                System.err.println("Writing out " + newPal[i]);
            }
        }
        
        // Save the new palette to our configuration
        settings.setJMValue(JMConfig.CUSTOMPALETTE, newPal);
        
        handler.setCustomPalette(newPal);
    }
    
    /** Write out all the preferences */
//    private void writePreferences() {
//        // loop through each of our panels and write out the new preferences
//        setNewPaletteColours();
//    }
    
    /** Write out only the preference on the current page */
//    private void applyPref() {
//        setNewPaletteColours();
//    }
    
    /** set our new palette to the standard palette */
    private void setStandardColours() {
        final JMConfig settings = JMConfig.getInstance();
        final CHandler handler = settings.getConnectionHandler();
        // final anecho.gui.JMSwingText jmst = handler.getActiveMUDSwingText();
        
        final anecho.gui.JMSwingText jmst;
        
        if (handler.totalConnections() > 0) {
            jmst = handler.getActiveMUDSwingText();
        } else {
            jmst = new anecho.gui.JMSwingText();
        }
        
        // Collect the colours
        final Color[] newPal = jmst.getStandardColours();
        
        int xCol, yCol;
        final colourTableModel mtm = (colourTableModel)colourTable.getModel();
        
        for (int i = 0; i < 16; i++) {
            if (i < 8) {
                xCol = 1;
                yCol = i;
            } else {
                xCol = 2;
                yCol = i - 8;
            }
            
            mtm.setValueAt(newPal[i], yCol, xCol);
        }
        
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable colourTable;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton resetAll;
    private javax.swing.JButton standardButton;
    // End of variables declaration//GEN-END:variables
    private static final boolean DEBUG = false;
    // private CustomColour cusCol;
}
