/*
 * PrefInterface.java
 *
 * Created on December 10, 2005, 3:12 AM
 *
 * Part of JamochaMUD, this interface helps define new "Panels" to be shown
 * in the JamochaMUD preferences dialogue.  This way, panels may be loaded
 * in a lazy fashion, giving an apparent speed-boost to the Prefs dialogue.
 */

package anecho.JamochaMUD.PrefPanels;

import javax.swing.JPanel;

/**
 * This interface defines methods to be used by other "PrefPanel" classes.
 * These classes appear as separate items in the JamochaMUD preferences
 * dialogue allowing the user to customise how JamochaMUD operates.
 * @author Jeff Robinson
 */
public interface PrefInterface {
// public abstract class PrefInterface extends javax.swing.JPanel {

    /**
     * The human-readable name for our module
     * @return This string represents the human-readable name of the given module.
     */
    String getModuleName();
    
    /**
     * 
     * @return 
     */
    JPanel loadPanel();
    
    void applySettings();

//    public String getModuleName() {
//        return "Module Name";
//    }
//    
//    public JPanel loadPanel() {
//        return new JPanel();
//        
//    }
//    
//    public void applySettings() {
//        // La-dee-dah!
//    }
    
}
