/* This PlugIn strips the [fmcl] indicators
 * from FurryMUCK locations, and places them
 * as the window'start title
 */

package anecho.JamochaMUD.plugins;

import anecho.JamochaMUD.JMConfig;
// import anecho.JamochaMUD.JMUD;
import anecho.JamochaMUD.MuSocket;

import java.util.*;

// These import statements are specific to this plug-in
// import MuckConn;
// import MuckMain;

/**
 * This PlugIn strips the [fmcl] indicators
 * from FurryMUCK locations, and places them
 * as the window'start title
 * @version $Id: FBLocationPlugIn.java,v 1.10 2004/08/03 02:07:13 jeffnik Exp $
 * @author Jeff Robinson
 */

public class FBLocationPlugIn implements PlugInterface {

    // public void setLoader(Object o) {
    // }

    JMConfig settings;
    private boolean active = false;

    /**
     * 
     * @param mainSettings 
     */
    public void setSettings(final JMConfig mainSettings) {
        this.settings = mainSettings;
    }

    /**
     * 
     * @return 
     */
    public String plugInName() {
        return "FurryMUCK Location Plug-in";
    }

    /**
     * 
     * @return 
     */
    public String plugInDescription() {
        return "This PlugIn strips the [fmcl] indicators from FurryMUCK locations, and places them as the window's title.";
    }

    /**
     * 
     * @return 
     */
    public String plugInType() {
        return "Output";
    }

    /**
     * 
     * @param jamochaString 
     * @param mSock 
     * @return 
     */
    public String plugMain(final String jamochaString, final MuSocket mSock) {
        // When we receive a string beginning with [fmcl],
        // we'll parse it down to get the location'start name
        // and then use that as the title for the main window

        String retString;

        if (jamochaString.startsWith("[fmcl")) {
            // We have a qualifying string

            // Tokenize the string
            final StringTokenizer mainString = new StringTokenizer(jamochaString);
            StringBuffer newTitle = new StringBuffer("");
            String finalTitle;

            // Discard the first two tokens
            mainString.nextToken();
            mainString.nextToken();

            while (mainString.hasMoreTokens()) {
                newTitle.append(mainString.nextToken());
                newTitle.append(" ");
            }

            // Now remove any nasty 'escapes' that may be in there
            int start, finish;
            String temp;
            while ((newTitle.toString()).indexOf('\u001b') > 0) {
                // Remove the escape
                // temp = new String(newTitle.toString());
                temp = newTitle.toString();
                start = temp.indexOf('\u001b');
                finish = temp.indexOf("m", start);
                newTitle = new StringBuffer(temp.substring(0, start) + temp.substring(finish));
                System.out.println(" " + newTitle);
            }

            // finalTitle = new String(newTitle.toString());
            finalTitle = newTitle.toString();
            finalTitle.trim();

            mSock.setTitle(finalTitle);
            retString = "";
        } else {
            retString = jamochaString;
        }

        return retString;
    }

    public void plugInProperties() {
    }

    public void initialiseAtLoad(){
    }

    public void setAtHalt(){
        // We'll restore the title of the main window
        // back to 'JamochaMUD' again.
        // Fix this XXX
        // MuckMain.muckMainTitle = new String("JamochaMUD");
        // MuckMain.setWindowTitle();
    }

    /**
     * We don't require a directory for our settings
     * @return 
     */
    public boolean haveConfig() {
        return false;
    }

    /**
     * We have no editable properties
     * @return 
     */
    public boolean hasProperties() {
        return false;
    }

    public void activate() {
        active = true;
    }

    public void deactivate() {
        active = false;
    }

    /**
     * 
     * @return 
     */
    public boolean isActive() {
        return active;
    }
}
