// 
/* PlugInterface.java
 * Creates an interface that all plug-ins declare
 * to interact with JamochaMUD
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.plugins;

/** Creates an interface used by all JamochaMUD plugins
 * @version $Id: PlugInterface.java,v 1.9 2004/08/03 02:07:13 jeffnik Exp $
 * @author Jeff Robinson
 */

import anecho.JamochaMUD.JMConfig;
import anecho.JamochaMUD.MuSocket;

public interface PlugInterface {
    // This lists the methods that can be called by JamochaMUD
    /**
     * Set the loader of the module. This is necessary to know if you want to
     * contact the modules parent.
     * @param settings 
     */
    // public void setLoader(Object loader);
    void setSettings(JMConfig settings);

    /**
     * Returns the plugin's proper name
     * @return 
     */
    String plugInName();

    /**
     * Returns a description, eg. author, date, build...
     * @return 
     */
    String plugInDescription();

    /**
     * Returns a type of either input, output, or other
     * @return 
     */
    String plugInType();

    /**
     * the core of the plugin
     * @param jamochaString 
     * @param mSock 
     * @return 
     */
    String plugMain(String jamochaString, MuSocket mSock);

    /** Any user configurable options for the plugin */
    void plugInProperties();

    /**
     * Check to see if the plug-in has configurable properties
     * @returns <pre>true</pre> - plug-in can be configured
     * <pre>false</pre> - plug-in cannot be configured
     * @return 
     */
    boolean hasProperties();

    /** This function is called at load-up, in case
     * properties are needed... eg. lists, settings */
    void initialiseAtLoad();

    /**
     * This function tells the plug-in that it should be functioning.
     * See Deactive() for the inverse function.  activate may be called
     * more than once.
     */
    void activate();

    /**
     * This function tells the plug-in that it should not be active.
     * deactivate may be called more than once.
     * Formerly this function was handled by setAtHalt.
     */
    void deactivate();

    /* Returns a result of true if the plug-in is active, or false if it is not
     */
    /**
     * 
     * @return 
     */
    boolean isActive();

    /**
     * Previously this function did most of the functions of deactivate()
     * but now this is reserved solely for shutting down the plug-in
     * and doing any necessary clean-up.
     */
    void setAtHalt();

    /**
     * This function indicates whether a directory
     * is required to hold settings for our plug-in.
     * It is recommended for consistency to let JamochaMUD
     * create and handle any plug-in directories.  Plus,
     * it means you can use less code in your plug-in!
     * @returns <pre>true</pre> - create a settings directory
     * <pre>false</pre> - no directory required
     * @return 
     */
    boolean haveConfig();
}
