/*
 * Trigger.java
 *
 * Created on April 5, 2004, 6:22 PM
 * $Id: Trigger.java,v 1.26 2004/08/03 02:07:13 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2004  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, audStream published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.plugins;

/** This plug-in allows users to set highlights and gags based on
 * incoming text from the connect MU*s.
 * @author Jeff Robinson
 */
public class Trigger implements anecho.JamochaMUD.plugins.PlugInterface {
    
    /** Creates a new instance of Trigger */
//    public Trigger() {
//    }
    //

    private boolean active = false;

    public void activate() {
        active = true;
    }
    
    /** The method deactivates the plug-in */    
    public void deactivate() {
        active = false;
    }

    /**
     * 
     * @return 
     */
    public boolean isActive() {
        return active;
    }

    /** This tells the main program whether the plug-in has user-accessible
     * properties.
     * @return True indicates properties are available, false indicates none
     */    
    public boolean hasProperties() {
        return true;
    }
    
    /**
     * This method initialises any variables needed by the plug-in audStream soon
     * audStream it is loaded.
     */    
    public void initialiseAtLoad() {
        readTriggers();
        andStr = "and";
        andTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND");
        andTrans = andTrans.toLowerCase();
        notStr = "not";
        notTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT");
        notTrans = notTrans.toLowerCase();
        modStr = "modifier";
        modTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER");
        modTrans = modTrans.toLowerCase();
        
    }
    
    /** This method returns a String with a brief description of the plug-in's function.
     * @return The description of the plug-in.
     */    
    public String plugInDescription() {
        return(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("description"));
    }
    
    /** This returns the name of the plug-in for display to the user.
     * @return The human-readable name of the plug-in
     */    
    public String plugInName() {
        return(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Gags_and_Highlights"));
    }
    
    /** Displays properties for the plug-in that users can adjust. */    
    public void plugInProperties() {
        // Create our dialogues and slip them the new rules
        // java.awt.Frame parentFrame = settings.getJMFrame(anecho.JamochaMUD.JMConfig.MUCKMAINFRAME);
        // anecho.JamochaMUD.plugins.TriggerDir.TriggerGUI plugGUI = new anecho.JamochaMUD.plugins.TriggerDir.TriggerGUI(mainRules, this);
        final anecho.JamochaMUD.plugins.TriggerDir.TriggerGUI plugGUI = anecho.JamochaMUD.plugins.TriggerDir.TriggerGUI.getInstance(mainRules, this);
        plugGUI.setVisible(true);
        
//        if (plugGUI.saveNewRules()) {
//            if (DEBUG) {
//                System.err.println("Writing rules to file");
//            }
//            // get our new rules
//            mainRules = plugGUI.getNewRules();
//            // Write the rules out to a file
//            writeRulesToFile();
//        } else {
//            if (DEBUG) {
//                System.err.println("Not writing out rules.");
//            }
//        }
        
    }
    
    /** Type of plug-in: input, output, or other.
     * @return
     */    
    public String plugInType() {
        return "Output";
    }
    
    /**
     * The main method of the plug-in.
     * @param jamochaString
     * @param mSock
     * @return
     */    
    public String plugMain(final String jamochaString, final anecho.JamochaMUD.MuSocket mSock) {
        // final String finalString = new String(parseGags(jamochaString));
        final String finalString = parseGags(jamochaString);
        return finalString;
    }
    
    /** This is called when JamochaMUD stops, and can be used for any final
     * clean-up, file saving, etc.
     */    
    public void setAtHalt() {
    }
    
    /** Returns whether there is a (GUI) configuration available for the plug-in.
     * @return
     */    
    public boolean haveConfig() {
        return true;
    }
    
    /**
     * @param settings
     */    
    public void setSettings(final anecho.JamochaMUD.JMConfig settings) {
        this.settings = settings;
        plugIns = settings.getJMString(anecho.JamochaMUD.JMConfig.USERPLUGINDIR);
        triggerDir = plugIns + pathSeparator + "TriggerDir";
        triggerFile = new java.io.File(triggerDir + pathSeparator + ".trigger.rc");
    }
    
    /** Go through the rules and see if have anything that matches */
    private String parseGags(final String input) {
        String retString;
        
        if (mainRules == null || mainRules.size() < 1) {
            // We have no rules yet
            retString = input;
        } else {
            
            StringBuffer grinder = new StringBuffer(input);
            
            // Loop through all the rules...
            int numRules = 0;
            boolean gag, mod;
            int ruleResult = NO_MATCH;
            
            final int mRuleSize = mainRules.size();
            
            // for (int set = 0; set < mainRules.size(); set++) {
            for (int set = 0; set < mRuleSize; set++) {
                
                gag = false; // Reset this for each rule, otherwise we can have "fall through"
                mod = false; // Check if any rule "modifiers" have been successful
                
                // How many rules are in this rule set?
                numRules = Integer.parseInt(pullRule(mainRules.elementAt(set), RULES));
                
                for (int j = 0; j < numRules; j++) {
                    ruleResult = checkRule(input, set, j);
                    
                    if (ruleResult == TRUE_MATCH) {
                        gag = true;
                    }
                    if (ruleResult == FALSE_MATCH) {
                        gag = false;
                        break;
                    }
                    
                    if (ruleResult == MODIFIER_MATCH) {
                        mod = true;
                    }
                }
                
                // We'll see if this gag is appropriate...
                if (gag) {
                    grinder = new StringBuffer(applyGag(grinder, set));
                    
                    /* The colour needs some additional modifications */
                    if (mod) {
                        if (DEBUG) {
                            System.err.println("Trigger adding mod colouring.");
                        }
                        grinder.insert(0, "\u001b[3m");
                        grinder.append("\u001b[0m");
                    }
                    
                    // If audio is applicable, we'll call that audStream well!
                    final String rule = pullRule(mainRules.elementAt(set), MEDIA);
                    if (!rule.equals("None")) {
                        playMedia(pullRule(mainRules.elementAt(set), MEDIA));
                    }
                    
                }
                
            }
            
            retString = grinder.toString();
        }
        
        if (DEBUG) {
            System.err.println("Completed trigger: " + retString);
        }
        
        return retString;
    }
    
    /** Search through the string for the rule name,
     * and extract its information
     */
    private String pullRule(final Object ruleObj, final String ruleName) {
        final String rule = ruleObj.toString();
        int start, end;
        start = rule.indexOf(ruleName);
        start = start + ruleName.length();
        end = rule.indexOf("$", start + 1);
        
        return rule.substring(start, end);
    }
    
    /** Check the passed string to see if it matches one of our rules
     * @param input The input string that the rule will be checked against
     * @param set The rule-set to check.  A rule-set is a complete rule.
     * @param rule The specific rule within a set to check against.  Usually a condition.
     */
    private int checkRule(final String inString, final int set, final int rule) {
        String input = inString;
        final String chkRule = new String(pullRule(mainRules.elementAt(set), "$" + rule + ":"));
        final String matchType = transToType(chkRule, false);
        // chkRule = chkRule.toLowerCase();
        // chkRule = transToType(chkRule, false);
        final String match = (chkRule.substring(chkRule.indexOf(":") + 1)).toLowerCase();
        input = input.toLowerCase();
        int state = NO_MATCH;
        
        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND"))) {
        // if (chkRule.startsWith(andStr) || chkRule.startsWith(andTrans)) {
        if (matchType.startsWith(andStr)) {
            // if (matchType.startsWith(AND)) {
            // if (input.indexOf(match) > 0 || input.startsWith(match)) {
            if (input.indexOf(match) > -1) {
                state = TRUE_MATCH;
            } else {
                // We didn't meet an "AND" condition, so this trigger fails
                state = FALSE_MATCH;
            }
        }
        
        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("OR"))) {
        //            if (matchType.startsWith(orStr)) {
        //                // if (input.indexOf(match) > 0 || input.startsWith(match)) {
        //                if (input.indexOf(match) > -1) {
        //                    state = TRUE_MATCH;
        //                }
        //            }
        
        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT"))) {
        // if (chkRule.startsWith(notStr) || chkRule.startsWith(notTrans)) {
        if (matchType.startsWith(notStr) && (input.indexOf(match) > -1)) {
            // if (matchType.startsWith(NOT)) {
            // if (input.indexOf(match) > 0 || input.startsWith(match)) {
            // if (input.indexOf(match) > -1) {
                state = FALSE_MATCH;
            // }
        }
        
        // if (chkRule.startsWith(MODIFIER)) {
        // if (chkRule.startsWith(modStr) || chkRule.startsWith(modTrans)) {
        if (matchType.startsWith(modStr) && (input.indexOf(match) > -1)) {
            // if (input.indexOf(match) > -1) {
                state = MODIFIER_MATCH;
            // }
        }
        return state;
    }
    
    /** Apply the Gag to the String we were passed from the main program */
    private String applyGag(final StringBuffer sBuffer, final int set) {
    // private String applyGag(StringBuffer sBuffer, int set, boolean matchOnly, String matchTerm) {
        String colour = pullRule(mainRules.elementAt(set), COLOUR);
        // colour = new String(colour.toLowerCase());
        colour = colour.toLowerCase();
        // String colourCode = new String();
        String colourCode = "";
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("gag"))) {
            return "";	// Not a colour, but a gag!
        }
        
        // Make the colour our colour name by default, change if necessary
        
        // if (colour.startsWith("#")) {
        if (colour.charAt(0) == '#') {
            colourCode = '\u001b' + "[" + colour + "m";
        }
        
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("black"))) {
            colourCode = '\u001b' + "[30m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("red"))) {
            colourCode = '\u001b' + "[31m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("green"))) {
            colourCode = '\u001b' + "[32m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("yellow"))) {
            colourCode = '\u001b' + "[33m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("blue"))) {
            colourCode = '\u001b' + "[34m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("magenta"))) {
            colourCode = '\u001b' + "[35m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("cyan"))) {
            colourCode = '\u001b' + "[36m";
        }
        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("white"))) {
            colourCode = '\u001b' + "[37m";
        }

        if (sBuffer.length() > 0 && sBuffer.charAt(0) != '\u001b') {
            int start = 0;
            int end = sBuffer.length();
      
            // Check to see if we only need to match the specific area of text
            // if (matchOnly) {
            final String match = pullRule(mainRules.elementAt(set), this.MATCHONLY).toLowerCase();
            if (match.equals("true")) {
                if (DEBUG) {
                    System.err.println("Trigger.ApplyGag(): Going to exact match text");
                }
                // Determine the new start and beginning
                final int numRules = Integer.parseInt(pullRule(mainRules.elementAt(set), RULES));
                int ruleResult;
                String input;
                String matchTerm;
                
                for (int j = 0; j < numRules; j++) {
                    input = sBuffer.toString();
                    ruleResult = checkRule(input, set, j);
                    matchTerm = this.pullRule(mainRules.elementAt(set), "$" + j + ":");
                    matchTerm = matchTerm.substring(matchTerm.indexOf(':') + 1);
                    if (DEBUG) {
                        System.err.println("Trigger.ApplyGag() checking for: " + matchTerm);
                        System.err.println("Our ruleRest returned: " + ruleResult);
                    }
                    if (ruleResult == TRUE_MATCH) {
                        start = input.indexOf(matchTerm);
                        end = start + matchTerm.length();
                        // We insert the "End" first so that the beginning doesn't
                        // change our index number!!
                        sBuffer.insert(end, '\u001b' + "[0m");
                        sBuffer.insert(start, colourCode);
                        if (DEBUG) {
                            System.err.println("Trigger.ApplyGag() apply matchTerm " + matchTerm + " to start: " + start + " and end: " + end);
                        }
                    }
                }

            } else {
                sBuffer.insert(0, colourCode);
                sBuffer.append('\u001b' + "[0m");
                // sBuffer.insert(start, colourCode);
                // sBuffer.insert(end, '\u001b' + "[0m");
                 if (DEBUG) {
                            System.err.println("Trigger.ApplyGag() applying highlight to entire line");
                        }

            }
        }
        
        return sBuffer.toString();
    }
    
    /** Play media is triggered, so let's make some noise! */
    private void playMedia(final String audioFileName) {
        // This stuff is drawn from the Applet.AudioClip class.  Yuckyweird.
        // try {
        // AudioClip myClip = getAudioClip(new URL(getCodeBase(), "clip.au"));
        // } catch (Exception e) {
        // }
        try {
            sun.audio.AudioDataStream audioDataStream;
            final sun.audio.AudioPlayer audioPlayer = sun.audio.AudioPlayer.player;
            final java.io.FileInputStream fis = new java.io.FileInputStream( new java.io.File(audioFileName) );
            final sun.audio.AudioStream audStream = new sun.audio.AudioStream( fis ); // header plus audio data
            final sun.audio.AudioData audData = audStream.getData(); // audio data only, no header
            audioDataStream = new sun.audio.AudioDataStream( audData );
            audioPlayer.start( audioDataStream );
        } catch (Exception e) {
            System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("An_exception_occured_trying_to_play_this_file:"));
            System.out.println(e);
        }
        
    }
    
    /** Do a look-up from a language translation to its rule */
    private String transToType(final String trans, final boolean upper) {
        String retType = "";
        String lowerTrans = "";
        final int cpos = trans.indexOf(":");
        
        // Remove any markings if this is still part of our rule
        if (cpos > -1) {
            lowerTrans = trans.substring(0, cpos).toLowerCase();
        } else {
            lowerTrans = trans.toLowerCase();
        }
        
        // String match = (chkRule.substring(chkRule.indexOf(":") + 1)).toLowerCase();
        
        if (lowerTrans.equals(andTrans) || lowerTrans.equals(andStr)) {
            retType = andStr;
        }
        
        if (lowerTrans.equals(notTrans) || lowerTrans.equals(notStr)) {
            retType = notStr;
        }
        
        if (lowerTrans.equals(modTrans) || lowerTrans.equals(modStr)) {
            retType = modStr;
        }
        
        if (upper) {
            retType = retType.toUpperCase();
        }
        
        return retType;
    }
    
    /** Do an "installation check", and read in triggers
     * if they already exist.  If not, create the proper space
     */
    private void readTriggers() {
        // if (!triggerFile.exists()) return;
        // No trigger file, no need to continue
        // We'll open the .trigger.rc file and read in the rulesets
        java.io.RandomAccessFile reader;
        boolean loop = true;
        
        if (DEBUG) {
            System.err.println("Trying to read in triggers...");
            System.err.println("Trigger File: " + triggerFile.toString());
        }
        
        try {
            reader = new java.io.RandomAccessFile(triggerFile.toString(), "r");
            
            
            String line;
            final StringBuffer fullLine = new StringBuffer("");
            
            while (loop) {
                try {
                    line = reader.readLine();
                } catch (Exception e) {
                    // We're all out of lines
                    break;
                }
                
                if (line == null || line.trim().equals("")) {
                    loop = false;
                    break;
                }
                
                line.trim();
                fullLine.append(line);
                
                if (DEBUG) {
                    System.err.println("Read rule: " + line);
                }
                
                
                if (line != null && line.indexOf("$DONE") > 0) {
                    mainRules.addElement(fullLine.toString());
                    // fullLine = new StringBuffer("");
                    fullLine.setLength(0);
                }
                
            }
            
            reader.close();
            // SetChoices();  // Fix Me XXX - removed for refactored plug-in
            
        } catch(Exception e) {
            // We can't find our trigger rules.  Chances are they will be created on the first-run
            if (DEBUG) {
                System.out.println("Trigger plugin could not access " + triggerFile + ", exception " + e);
                e.printStackTrace();
            }
        }
        
//        return;
    }
    
    /** Upon approval by the user, we'll write the rules back to the file
     * @param newRules
     */
    public void writeRulesToFile(final java.util.Vector newRules) {
        
        mainRules = newRules;
        
        if (triggerFile.exists()) {
            triggerFile.delete();
        }
        
        String writeOut;
        // We'll open the .trigger.rc file and read in the rulesets
        java.io.RandomAccessFile writer;
        
        try {
            writer = new java.io.RandomAccessFile(triggerFile.toString(), "rw");
            
            final int mRuleSize = mainRules.size();
            
            // for (int i = 0; i < mainRules.size(); i++) {
            for (int i = 0; i < mRuleSize; i++) {
                // writeOut = new String((String)mainRules.elementAt(i));
                writeOut = mainRules.elementAt(i).toString();
                writer.writeBytes(writeOut.trim() + '\n');
                if (DEBUG) {
                    System.err.println("Trigger.WriteRulesToFile: " + writeOut.trim());
                }
            }
            
            writer.close();
            
        } catch (Exception e) {
            System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Some_sort've_error_while_writing_out_plugins") + e);
        }
        
    }
    
    private java.util.Vector mainRules = new java.util.Vector(0, 1);
    private anecho.JamochaMUD.JMConfig settings;
    
    private String pathSeparator = java.io.File.separator;
    private String plugIns;       // our plugins directory
    private String triggerDir;    // the directory where we keep our trigger rules
    private java.io.File triggerFile;     // the file where we keep our trigger rules
    
    private static final String RULES = "$RULES:";
//    private static final String RULENAME = "$NAME:";
    private static final String COLOUR = "$COLOUR:";
//    private static final String LAUNCH = "$LAUNCH:";
    private static final String MEDIA = "$MEDIA:";
//    private static final String NAME = "$NAME:";
//    private static final String DONE = "$DONE:";
    private static final String MATCHONLY = "$MATCHONLY:";
    
    private static final int NO_MATCH = 0;
    private static final int TRUE_MATCH = 1;
    private static final int FALSE_MATCH = 2;
    private static final int MODIFIER_MATCH = 3;
    
    private static final boolean DEBUG = false;
    
//    private static final String AND = "AND";
//    private static final String NOT = "NOT";
//    private static final String MODIFIER = "MODIFIER";
    private static String andStr, andTrans;
    private static String notStr, notTrans;
    private static String modStr, modTrans;
    //
}
