/*
 * Trigger.java
 *
 * Created on March 18, 2004, 9:49 PM
 * $Id: TriggerGUI.java,v 1.1 2004/08/03 02:08:07 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD.plugins.TriggerDir;

// import anecho.JamochaMUD.JMConfig;

/** The GUI to allow users to change the rules for their gags and highlights.
 * @author Jeff Robinson
 */
//public class TriggerGUI extends java.awt.Frame implements anecho.JamochaMUD.plugins.PlugInterface {
public class TriggerGUI extends java.awt.Frame {
    
    /** Creates new form Trigger
     * @param editableRules A vector of rules passed to the GUI
     * @param parentClass The parent class of this class, used to do a call-back if the rules have changed
     * @return Returns the instance of our TriggerGUI class
     */
    public static synchronized TriggerGUI getInstance(final java.util.Vector editableRules, final anecho.JamochaMUD.plugins.Trigger parentClass) {
        if (_instance==null) {
            _instance = new TriggerGUI(editableRules, parentClass);
        }

        return _instance;
        
    }
    
    private TriggerGUI(java.util.Vector editableRules, anecho.JamochaMUD.plugins.Trigger parentClass) {
        // We need to keep track of this to update the rules when we're done
        // As we use a Frame, there is no other clearly visible way of getting
        // this done.
        this.parentClass = parentClass;
        
        int ers = editableRules.size();
        
        mainRules.removeAllElements();
        originalRules.removeAllElements();
        
        for (int i = 0; i < ers; i++) {
            mainRules.addElement(editableRules.elementAt(i));
            originalRules.addElement(editableRules.elementAt(i));
        }
        
        initComponents();
        
        // We'll keep all our schtuff here in lower-case to make faster comparisons
        andTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND");
        andTrans = andTrans.toLowerCase();

        notTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT");
        notTrans = notTrans.toLowerCase();

        modTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER");
        modTrans = modTrans.toLowerCase();
        
        // Fill our forms with the proper information
        selectRule();
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        ruleListPanel = new java.awt.Panel();
        label1 = new java.awt.Label();
        ruleNameChoice = new java.awt.Choice();
        editButton = new java.awt.Button();
        addRuleButton = new java.awt.Button();
        removeRuleButton = new java.awt.Button();
        saveRulesButton = new java.awt.Button();
        cancelButton = new java.awt.Button();
        label2 = new java.awt.Label();
        activationEx = new java.awt.TextArea();
        ruleDetailsPanel = new java.awt.Panel();
        java.awt.CheckboxGroup typeGroup = new java.awt.CheckboxGroup();
        label3 = new java.awt.Label();
        ruleSetName = new java.awt.TextField();
        label4 = new java.awt.Label();
        ruleList = new java.awt.List();
        newRuleButton = new java.awt.Button();
        deleteRuleButton = new java.awt.Button();
        okayButton = new java.awt.Button();
        ruleSetCancel = new java.awt.Button();
        ruleOption = new java.awt.Choice();
        ruleWord = new java.awt.TextField();
        gagCheck = new java.awt.Checkbox();
        gagCheck.setCheckboxGroup(typeGroup);

        highlightCheck = new java.awt.Checkbox();
        highlightCheck.setCheckboxGroup(typeGroup);
        customColourCheck = new java.awt.Checkbox();
        colourButton = new java.awt.Button();
        customColour = new java.awt.TextField();
        mediaCheck = new java.awt.Checkbox();
        mediaPath = new java.awt.TextField();
        mediaButton = new java.awt.Button();
        matchOnlyCheck = new java.awt.Checkbox();

        setLayout(new java.awt.CardLayout());

        setTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Gags_and_Highlights"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        ruleListPanel.setLayout(new java.awt.GridBagLayout());

        ruleListPanel.setName("ruleList");
        label1.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Rule_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 2);
        ruleListPanel.add(label1, gridBagConstraints);

        ruleNameChoice.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                ruleNameChoiceItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(7, 2, 2, 2);
        ruleListPanel.add(ruleNameChoice, gridBagConstraints);

        editButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("editThisRule"));
        editButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                editButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleListPanel.add(editButton, gridBagConstraints);

        addRuleButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Add_A_Rule"));
        addRuleButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addRuleButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 2);
        ruleListPanel.add(addRuleButton, gridBagConstraints);

        removeRuleButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Remove_This_Rule"));
        removeRuleButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                removeRuleButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleListPanel.add(removeRuleButton, gridBagConstraints);

        saveRulesButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Save_All_Rules"));
        saveRulesButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                saveRulesButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 7, 7, 2);
        ruleListPanel.add(saveRulesButton, gridBagConstraints);

        cancelButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Cancel_All_Changes"));
        cancelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 2, 7, 7);
        ruleListPanel.add(cancelButton, gridBagConstraints);

        label2.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("This_rule_will_activate_if_a_line:"));
        label2.setVisible(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleListPanel.add(label2, gridBagConstraints);

        activationEx.setEditable(false);
        activationEx.setVisible(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 7, 7);
        ruleListPanel.add(activationEx, gridBagConstraints);

        add(ruleListPanel, "ruleList");

        ruleDetailsPanel.setLayout(new java.awt.GridBagLayout());

        ruleDetailsPanel.setName("ruleDetails");
        label3.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Rule_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 2, 2);
        ruleDetailsPanel.add(label3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 2, 2, 7);
        ruleDetailsPanel.add(ruleSetName, gridBagConstraints);

        label4.setText("Rule set:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleDetailsPanel.add(label4, gridBagConstraints);

        ruleList.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                ruleListItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleDetailsPanel.add(ruleList, gridBagConstraints);

        newRuleButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Add_Rule"));
        newRuleButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                newRuleButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 2);
        ruleDetailsPanel.add(newRuleButton, gridBagConstraints);

        deleteRuleButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Delete_Rule"));
        deleteRuleButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                deleteRuleButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleDetailsPanel.add(deleteRuleButton, gridBagConstraints);

        okayButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Okay"));
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 2);
        ruleDetailsPanel.add(okayButton, gridBagConstraints);

        ruleSetCancel.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Cancel"));
        ruleSetCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ruleSetCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(7, 2, 7, 7);
        ruleDetailsPanel.add(ruleSetCancel, gridBagConstraints);

        ruleOption.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                ruleOptionItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 2);
        ruleDetailsPanel.add(ruleOption, gridBagConstraints);

        ruleWord.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                ruleWordKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleDetailsPanel.add(ruleWord, gridBagConstraints);

        gagCheck.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Gag"));
        gagCheck.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                gagCheckItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleDetailsPanel.add(gagCheck, gridBagConstraints);

        highlightCheck.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Highlight"));
        highlightCheck.setState(true);
        highlightCheck.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                highlightCheckItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleDetailsPanel.add(highlightCheck, gridBagConstraints);

        customColourCheck.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("colour"));
        customColourCheck.setState(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 2);
        ruleDetailsPanel.add(customColourCheck, gridBagConstraints);

        colourButton.setEnabled(false);
        colourButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Choose_colour"));
        colourButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                colourButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 7);
        ruleDetailsPanel.add(colourButton, gridBagConstraints);

        customColour.setColumns(6);
        customColour.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleDetailsPanel.add(customColour, gridBagConstraints);

        mediaCheck.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Media"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 2);
        ruleDetailsPanel.add(mediaCheck, gridBagConstraints);

        mediaPath.setColumns(6);
        mediaPath.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        ruleDetailsPanel.add(mediaPath, gridBagConstraints);

        mediaButton.setEnabled(false);
        mediaButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Browse"));
        mediaButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mediaButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 7);
        ruleDetailsPanel.add(mediaButton, gridBagConstraints);

        matchOnlyCheck.setLabel("Highlight matching text only");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 7, 2, 7);
        ruleDetailsPanel.add(matchOnlyCheck, gridBagConstraints);

        add(ruleDetailsPanel, "ruleDetails");

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
    
    private void ruleOptionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_ruleOptionItemStateChanged
        // Change the rule type
        updateRule();
    }//GEN-LAST:event_ruleOptionItemStateChanged
    
    private void ruleWordKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_ruleWordKeyReleased
        // Add your handling code here:
        // help get rid of the need to hit "update" after typing new rules
        final int selected = ruleList.getSelectedIndex();
        updateRule();
        ruleList.select(selected);
    }//GEN-LAST:event_ruleWordKeyReleased
    
    private void ruleListItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_ruleListItemStateChanged
        // Add your handling code here:
        // Update the rule options
        final int selected = ruleList.getSelectedIndex();
        showRuleWord(selected);
    }//GEN-LAST:event_ruleListItemStateChanged
    
    private void highlightCheckItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_highlightCheckItemStateChanged
        // Add your handling code here:
        changeOptionStates(true);
    }//GEN-LAST:event_highlightCheckItemStateChanged
    
    private void gagCheckItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_gagCheckItemStateChanged
        // Add your handling code here:
        final boolean state = gagCheck.getState();
        
        if (state) {
            changeOptionStates(false);
        }
        
    }//GEN-LAST:event_gagCheckItemStateChanged
    
    private void ruleNameChoiceItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_ruleNameChoiceItemStateChanged
        // Add your handling code here:
        final String rTitle = ruleNameChoice.getSelectedItem();
        ruleSetName.setText(rTitle);
    }//GEN-LAST:event_ruleNameChoiceItemStateChanged
    
    private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
        // Add your handling code here:
        if (DEBUG) {
            System.err.println("Rule has been accepted.");
        }
        
        writeNewRule();
        
        if (editing) {
            editing = false;
        } else {
            editing = true;
        }
        
        setEditStatus(false);
        
    }//GEN-LAST:event_okayButtonActionPerformed
    
    private void ruleSetCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ruleSetCancelActionPerformed
        // Add your handling code here:
        editAddRule(ruleNameChoice.getSelectedIndex());
        
        if (editing) {
            editing = false;
        } else {
            editing = true;
        }
        
        setEditStatus(false);  // Fix this XXX - probably remove boolean from method
        
    }//GEN-LAST:event_ruleSetCancelActionPerformed
    
    private void mediaButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mediaButtonMouseClicked
        // Add your handling code here:
        selectFile(mediaPath, mediaPath.getText());
    }//GEN-LAST:event_mediaButtonMouseClicked
    
    private void colourButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_colourButtonMouseClicked
        // Add your handling code here:
        // Create our colour selector!!
        String oldColour = customColour.getText();
        
        // Create a valid colour
        if (oldColour.length() < 6 || oldColour.length() > 7) {
            oldColour = "FFFFFF";
        } else {
            oldColour = oldColour.substring(1, 7);
        }
        
        int red, green, blue; //
        try {
            red = Integer.parseInt(oldColour.substring(0, 2), 16);
            green = Integer.parseInt(oldColour.substring(2, 4), 16);
            blue = Integer.parseInt(oldColour.substring(4, 6), 16);
        } catch (Exception colourErr) {
            // Not a valid number
            red = 255;
            green = 255;
            blue = 255;
        }
        
        final java.awt.Color baseColour = new java.awt.Color(red, green, blue);
        
        final anecho.gui.ColourPicker chooser = new anecho.gui.ColourPicker(this, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Choose_a_colour"), baseColour);
        // this.setVisible(false);
        // anecho.gui.ColourPicker chooser = new anecho.gui.ColourPicker(parentFrame, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Choose_a_colour"), baseColour);
        // set the colour selector visible
        chooser.show();
        // this.setVisible(true);
        // update customColour textArea
        if (chooser.getColour() != null) {
            customColour.setText("#" + chooser.getHexColour());
        }
        
    }//GEN-LAST:event_colourButtonMouseClicked
    
    private void deleteRuleButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_deleteRuleButtonMouseClicked
        // Add your handling code here:
        if (ruleList.getSelectedItem() != null) {
            deleteSubRule(ruleList.getSelectedIndex());
        }
    }//GEN-LAST:event_deleteRuleButtonMouseClicked
    
    private void newRuleButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newRuleButtonMouseClicked
        // Add your handling code here:
        addNewSubRule();
    }//GEN-LAST:event_newRuleButtonMouseClicked
    
    private void cancelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cancelButtonMouseClicked
        // Add your handling code here:
        // This is the end of the line for us!
        // ruleFrame.setVisible(false);
        this.setVisible(false);
        
        // Since we don't want to keep our changes, we're are going to
        // read the rules back in so that we are synched up for the next
        // time our instance is called
//        if (DEBUG) {
//            System.err.println("Reverting to our original rules.");
//            System.err.println("---------------------------------");
//            System.err.println("originals: " + originalRules);
//            System.err.println("---------------------------------");
//            System.err.println("pre-change: " + mainRules);
//            System.err.println("---------------------------------");
//        }
        
        final int ors = originalRules.size();
        
        mainRules.removeAllElements();
        
        for (int i = 0; i < ors; i++) {
            mainRules.addElement(originalRules.elementAt(i));
        }
        
        // mainRules = originalRules;
//        if (DEBUG) {
//            System.err.println("post-change: " + mainRules);
//            System.err.println("---------------------------------");
//        }
        
        selectRule();
        
        // Remove our "lock"
        inProcess = false;
        
        // ruleFrame.dispose();
        this.dispose();
        
    }//GEN-LAST:event_cancelButtonMouseClicked
    
    private void saveRulesButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveRulesButtonMouseClicked
        // Add your handling code here:
        // We'll write out all the rules and clean up our frame
        // writeRulesToFile();  // Old method
        if (DEBUG) {
            System.err.println("Setting saveRules to true.");
        }
        // saveRules = true;
        parentClass.writeRulesToFile(mainRules);
        if (DEBUG) {
            System.err.println("saveRulesButtonMouseClicked Setting originalRules to mainRules.");
        }
        originalRules = mainRules;
        
        // ruleFrame.setVisible(false);
        this.setVisible(false);
        inProcess = false;
        //ruleFrame.dispose();
        this.dispose();
    }//GEN-LAST:event_saveRulesButtonMouseClicked
    
    private void removeRuleButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_removeRuleButtonMouseClicked
        // Add your handling code here:
        // Remove this rule from the list
        // if (ruleName.getItemCount() < 1) return; // No rules to remove
        if (ruleNameChoice.getItemCount() > 0) {
            
            final int rule = ruleNameChoice.getSelectedIndex();
            ruleNameChoice.remove(rule);
            mainRules.removeElementAt(rule);
            
            // Make certain our rules show the proper info after removal
            editAddRule(ruleNameChoice.getSelectedIndex());
        }
    }//GEN-LAST:event_removeRuleButtonMouseClicked
    
    private void addRuleButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_addRuleButtonMouseClicked
        // Add your handling code here:
        addBlankRule();
        // mainRules.addElement("$RULES:1$0:AND:Blank$COLOUR:red$LAUNCH:None$MEDIA:None$NAME:Blank$DONE");
        // ruleName.add("Blank");
        // ruleName.select(mainRules.size() - 1);
        // editAddRule(mainRules.size() - 1);
                 /*
                if (editing) {
                    editing = false;
                } else {
                    editing = true;
                }
                  
                setEditStatus(editing);
                  */
        setEditStatus(true);  // Fix this XXX - I don't think we need the boolean anymore
    }//GEN-LAST:event_addRuleButtonMouseClicked
    
    private void editButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_editButtonMouseClicked
        // Add your handling code here:
        if (DEBUG) {
            System.err.println("ruleNameChoice index is: " + ruleNameChoice.getSelectedIndex());
            System.err.println("ruleNameChoice: " + ruleNameChoice);
        }
        setEditStatus(true);  // Fix this XXX - I don't think we need to boolean anymore
        
        if (DEBUG) {
            System.err.println("ruleNameChoice index is: " + ruleNameChoice.getSelectedIndex());
        }
        
    }//GEN-LAST:event_editButtonMouseClicked
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        // System.exit(0);
        this.setVisible(false);
        
        // Remove our "lock"
        inProcess = false;
    }//GEN-LAST:event_exitForm
    
//    public void Activate() {
//    }
    
//    public void Deactivate() {
//    }
    
//    public boolean HasProperties() {
//        return true;
//    }
    
//    public void InitialiseAtLoad() {
//        // Initialise the components
//        initComponents();
//
//        // We'll keep all our schtuff here in lower-case to make faster comparisons
//        andStr = "and";
//        andTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND");
//        andTrans = andTrans.toLowerCase();
//        notStr = "not";
//        notTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT");
//        notTrans = notTrans.toLowerCase();
//        modStr = "modifier";
//        modTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER");
//        modTrans = modTrans.toLowerCase();
//
//        // We'll call a class in the TriggerDir to scoop any existing .trigger.rc info
//        // The triggers must be read at initialisation so that they are available as
//        // soon as the MU* client connects.
//
//        ReadTriggers();
//    }
    
//    public String PlugInDescription() {
//        return(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("description"));
//    }
    
//    public String PlugInName() {
//        return(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Gags_and_Highlights"));
//    }
    
//    public void PlugInProperties() {
//        // We'll call the configuration dialogue for this plugin.
//        // Since it is rather extensive, we've put it into its own
//        // package.  (That way we can store the user configs there, too).
//
//
//
//        if (!inProcess) {
//            editing = false;
//            inProcess = true;
//            selectRule();
//        }
//    }
    
//    public String PlugInType() {
//        return "Output";
//    }
    
//    public String PlugMain(String jamochaString, anecho.JamochaMUD.MuSocket mu) {
//        String finalString = new String(ParseGags(jamochaString));
//        return finalString;
//    }
    
//    public void SetAtHalt() {
//    }
    
//    public boolean haveConfig() {
//        return true;
//    }
    
//    public void setSettings(anecho.JamochaMUD.JMConfig settings) {
//        this.settings = settings;
//        // plugIns = settings.getUserPlugInDir();
//        plugIns = settings.getJMString(JMConfig.USERPLUGINDIR);
//        triggerDir = plugIns + pathSeparator + "TriggerDir";
//        triggerFile = new java.io.File(triggerDir + pathSeparator + ".trigger.rc");
//    }
    
//    /** Go through the rules and see if have anything that matches */
//    private String ParseGags(String input) {
//        String retString;
//
//        if (mainRules == null || mainRules.size() < 1) {
//            // We have no rules yet
//            // return input;
//            retString = input;
//        } else {
//
//            StringBuffer grinder = new StringBuffer(input);
//
//            // Loop through all the rules...
//            int numRules = 0;
//            boolean gag, mod;
//            int ruleResult = NO_MATCH;
//
//            int mRuleSize = mainRules.size();
//
//            // for (int set = 0; set < mainRules.size(); set++) {
//            for (int set = 0; set < mRuleSize; set++) {
//
//                gag = false; // Reset this for each rule, otherwise we can have "fall through"
//                mod = false; // Check if any rule "modifiers" have been successful
//
//                // How many rules are in this rule set?
//                numRules = Integer.parseInt(pullRule(mainRules.elementAt(set), RULES));
//
//                for (int j = 0; j < numRules; j++) {
//                    ruleResult = CheckRule(input, set, j);
//
//                    if (ruleResult == TRUE_MATCH) {
//                        gag = true;
//                    }
//                    if (ruleResult == FALSE_MATCH) {
//                        gag = false;
//                        break;
//                    }
//
//                    if (ruleResult == MODIFIER_MATCH) {
//                        mod = true;
//                    }
//                }
//
//                // We'll see if this gag is appropriate...
//                if (gag) {
//                    grinder = new StringBuffer(ApplyGag(grinder, set));
//
//                    /* The colour needs some additional modifications */
//                    if (mod) {
//                        if (DEBUG) {
//                            System.err.println("Trigger adding mod colouring.");
//                        }
//                        grinder.insert(0, "\u001b[3m");
//                        grinder.append("\u001b[0m");
//                    }
//
//                    // If audio is applicable, we'll call that as well!
//                    String rule = pullRule(mainRules.elementAt(set), MEDIA);
//                    if (!rule.equals("None")) {
//                        playMedia(pullRule(mainRules.elementAt(set), MEDIA));
//                    }
//
//                }
//
//            }
//
//            // return grinder.toString();
//            retString = grinder.toString();
//        }
//
//        if (DEBUG) {
//            System.err.println("Completed trigger: " + retString);
//        }
//
//        return retString;
//    }
    
    /** Search through the string for the rule name,
     * and extract its information
     */
    private String pullRule(final Object ruleObj, final String ruleName) {
        final String rule = ruleObj.toString();
        int start, end;
        start = rule.indexOf(ruleName);
        start = start + ruleName.length();
        end = rule.indexOf("$", start + 1);
        
        return rule.substring(start, end);
    }
    
//    /** Check the passed string to see if it matches one of our rules
//     * @param input The input string that the rule will be checked against
//     * @param set The rule-set to check.  A rule-set is a complete rule.
//     * @param rule The specific rule within a set to check against.  Usually a condition.
//     */
//    private int CheckRule(String inString, int set, int rule) {
//        String input = inString;
//        String chkRule = new String(pullRule(mainRules.elementAt(set), "$" + rule + ":"));
//        String matchType = transToType(chkRule, false);
//        // chkRule = chkRule.toLowerCase();
//        // chkRule = transToType(chkRule, false);
//        String match = (chkRule.substring(chkRule.indexOf(":") + 1)).toLowerCase();
//        input = input.toLowerCase();
//        int state = NO_MATCH;
//
//        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND"))) {
//        // if (chkRule.startsWith(andStr) || chkRule.startsWith(andTrans)) {
//        if (matchType.startsWith(andStr)) {
//            // if (input.indexOf(match) > 0 || input.startsWith(match)) {
//            if (input.indexOf(match) > -1) {
//                state = TRUE_MATCH;
//            } else {
//                // We didn't meet an "AND" condition, so this trigger fails
//                state = FALSE_MATCH;
//            }
//        }
//
//        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("OR"))) {
//        //            if (matchType.startsWith(orStr)) {
//        //                // if (input.indexOf(match) > 0 || input.startsWith(match)) {
//        //                if (input.indexOf(match) > -1) {
//        //                    state = TRUE_MATCH;
//        //                }
//        //            }
//
//        // if (chkRule.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT"))) {
//        // if (chkRule.startsWith(notStr) || chkRule.startsWith(notTrans)) {
//        if (matchType.startsWith(notStr)) {
//            // if (input.indexOf(match) > 0 || input.startsWith(match)) {
//            if (input.indexOf(match) > -1) {
//                state = FALSE_MATCH;
//            }
//        }
//
//        // if (chkRule.startsWith("MODIFIER")) {
//        // if (chkRule.startsWith(modStr) || chkRule.startsWith(modTrans)) {
//        if (matchType.startsWith(modStr)) {
//            if (input.indexOf(match) > -1) {
//                state = MODIFIER_MATCH;
//            }
//        }
//        return state;
//    }
    
//    /** Apply the Gag to the String we were passed from the main program */
//    private String ApplyGag(StringBuffer sb, int set) {
//        String colour = pullRule(mainRules.elementAt(set), COLOUR);
//        colour = new String(colour.toLowerCase());
//        // String colourCode = new String();
//        String colourCode = "";
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("gag"))) {
//            return "";	// Not a colour, but a gag!
//        }
//
//        // Make the colour our colour name by default, change if necessary
//
//        if (colour.startsWith("#")) {
//            colourCode = '\u001b' + "[" + colour + "m";
//        }
//
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("black"))) {
//            colourCode = '\u001b' + "[30m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("red"))) {
//            colourCode = '\u001b' + "[31m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("green"))) {
//            colourCode = '\u001b' + "[32m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("yellow"))) {
//            colourCode = '\u001b' + "[33m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("blue"))) {
//            colourCode = '\u001b' + "[34m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("magenta"))) {
//            colourCode = '\u001b' + "[35m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("cyan"))) {
//            colourCode = '\u001b' + "[36m";
//        }
//        if (colour.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("white"))) {
//            colourCode = '\u001b' + "[37m";
//        }
//
//        if (sb.length() > 0 && sb.charAt(0) != '\u001b') {
//            sb.insert(0, colourCode);
//            sb.append('\u001b' + "[0m");
//        }
//
//        return sb.toString();
//    }
    
//    /** Play media is triggered, so let's make some noise! */
//    private void playMedia(String audioFileName) {
//        // This stuff is drawn from the Applet.AudioClip class.  Yuckyweird.
//        // try {
//        // AudioClip myClip = getAudioClip(new URL(getCodeBase(), "clip.au"));
//        // } catch (Exception e) {
//        // }
//        try {
//            sun.audio.AudioDataStream audioDataStream;
//            sun.audio.AudioPlayer audioPlayer = sun.audio.AudioPlayer.player;
//            java.io.FileInputStream fis = new java.io.FileInputStream( new java.io.File(audioFileName) );
//            sun.audio.AudioStream as = new sun.audio.AudioStream( fis ); // header plus audio data
//            sun.audio.AudioData ad = as.getData(); // audio data only, no header
//            audioDataStream = new sun.audio.AudioDataStream( ad );
//            audioPlayer.start( audioDataStream );
//        } catch (Exception e) {
//            System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("An_exception_occured_trying_to_play_this_file:"));
//            System.out.println(e);
//        }
//
//    }
    
//    /** Do an "installation check", and read in triggers
//     * if they already exist.  If not, create the proper space
//     */
//    private void ReadTriggers() {
//        // if (!triggerFile.exists()) return;
//        // No trigger file, no need to continue
//        // We'll open the .trigger.rc file and read in the rulesets
//        java.io.RandomAccessFile reader;
//        boolean loop = true;
//
//        if (DEBUG) {
//            System.err.println("Trying to read in triggers...");
//            System.err.println("Trigger File: " + triggerFile.toString());
//        }
//
//        try {
//            reader = new java.io.RandomAccessFile(triggerFile.toString(), "r");
//
//
//            String line;
//            StringBuffer fullLine = new StringBuffer("");
//
//            while (loop) {
//                try {
//                    line = reader.readLine();
//                } catch (Exception e) {
//                    // We're all out of lines
//                    break;
//                }
//
//                if (line == null || line.trim().equals("")) {
//                    loop = false;
//                    break;
//                }
//
//                line.trim();
//                fullLine.append(line);
//
//                if (DEBUG) {
//                    System.err.println("Read rule: " + line);
//                }
//
//
//                if (line != null && line.indexOf("$DONE") > 0) {
//                    mainRules.addElement(fullLine.toString());
//                    fullLine = new StringBuffer("");
//                }
//
//            }
//
//            reader.close();
//            setChoices();
//
//        } catch(Exception e) {
//            // We can't find our trigger rules.  Chances are they will be created on the first-run
//            if (DEBUG) {
//                System.out.println("Trigger plugin could not access " + triggerFile + ", exception " + e);
//                e.printStackTrace();
//            }
//        }
//
//        return;
//    }
    
    /** This displays a list of available rules, allowing the
     * user to add, edit, or delete rules. */
    private void selectRule() {
        // Show our rules dialogue (adapted for NetBeans)
        // if (DEBUG) {
        //    System.err.println("Trigger.selectRule calling initComponents");
        //}
        
        // initComponents();
        setChoices();
        
        // Set all the rule options
        ruleOption.removeAll();
        ruleOption.add(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND"));
        ruleOption.add(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT"));
        ruleOption.add(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER"));
        
        // Add our colours to the list
        //colourSample.removeAll();
        // colourSample.add("custom");
        //colourSample.add("black");
        //colourSample.add("blue");
        //colourSample.add("cyan");
        //colourSample.add("dark gray");
        //colourSample.add("gray");
        //colourSample.add("green");
        //colourSample.add("light gray");
        //colourSample.add("magenta");
        //colourSample.add("orange");
        //colourSample.add("pink");
        //colourSample.add("red");
        //colourSample.add("white");
        //colourSample.add("yellow");
        
        // Make certain we're showing the proper rule information
        // if (ruleName != null) {
        editAddRule(ruleNameChoice.getSelectedIndex());
        // }
        setEditStatus(editing);
        
        // Show 'em what we're made of!
        // ruleFrame.setVisible(true);
        this.setVisible(true);
    }
    
    /** read the new vector into the choices
     * for our main dialogue
     */
    private void setChoices() {
        if (DEBUG) {
            System.err.println("Trigger.SetChoices entered.  Clearing rules.");
        }
        
        ruleNameChoice.removeAll();
        String tempName;
        final int mRuleSize = mainRules.size();
        
        // for (int i = 0; i < mainRules.size(); i++) {
        for (int i = 0; i < mRuleSize; i++) {
            // tempName = new String(pullRule(mainRules.elementAt(i), RULENAME));
            tempName = pullRule(mainRules.elementAt(i), RULENAME);
            
            if (tempName != null) {
                ruleNameChoice.add(tempName);
            }
        }
        
        // Show information about our rule
        editAddRule(ruleNameChoice.getSelectedIndex());
    }
    
    /** Add a new rule or edit an existing rule
     * -1 indicates that we'll be dealing with a
     * new rule, otherwise we'll edit the rule
     * number passed by the int.
     */
    private void editAddRule(final int inRule) {
        int rule = inRule;
        // There is a posibility that we don't have any rules yet
        if (mainRules == null) {
            mainRules = new java.util.Vector(0, 1);
        }
        
        if (DEBUG) {
            System.err.println("mainRules size: " + mainRules.size());
        }
        
        // if (mainRules == null || mainRules.size() == 0) {
        if (mainRules.size() == 0) {
            // Create a new blank rule and set our pointer to that
            addBlankRule();
            rule = 0;
        }
        
        if (rule < 0) {
            rule = 0;
        }
        
        // if (rule >= 0) {
        theRules = new String((String)mainRules.elementAt(rule));
        ruleSetName.setText(pullRule(theRules, RULENAME));
        setupRules(); // Fill in the appropriate rule areas
        // }
    }
    
        /* Toggle the portions of the dialogue to either allow
         * or disallow editing of the current rule
         * ***NOTE NOTE NOTE***
         * With the use of Netbeans and the Cardlayout this method
         * has now underwent some rather dramatic changes and no
         * long needs to be as kludgy!
         */
    private void setEditStatus(final boolean editing) {
        if (editing) {
            ((java.awt.CardLayout)this.getLayout()).last(this);
            if (DEBUG) {
                System.err.println("Trying to show ruleDetails pane.");
            }
        } else {
            ((java.awt.CardLayout)this.getLayout()).first(this);
            if (DEBUG) {
                System.err.println("Trying to show ruleList pane.");
            }
        }
        
        if (editing) {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("Setting_up_rule_#") + ruleNameChoice.getSelectedIndex());
            }
            
            // Make certain all of our settings for this rule check out
            setupRules();
            editAddRule(ruleNameChoice.getSelectedIndex());
        }
        
    }
    
    private void addBlankRule() {
        mainRules.addElement("$RULES:1$0:AND:Blank$COLOUR:red$LAUNCH:None$MEDIA:None$NAME:Rule " + mainRules.size() + "$DONE");
        ruleNameChoice.add("Rule " + mainRules.size());
        ruleNameChoice.select(mainRules.size() - 1);
        editAddRule(mainRules.size() - 1);
    }
    
    /** This will read in a rule, breaking it up
     * for nice display in our little rule-mangler!
     */
    private void setupRules() {
        // First, we'll check to see if this is a GAG,
        // and if so, we'll disable half our options now
        if (pullRule(theRules, COLOUR).equalsIgnoreCase(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("GAG"))) {
            gagCheck.setState(true);
            changeOptionStates(false);
        } else {
            changeOptionStates(true);

            // Better safe than sorry, no?
            gagCheck.setState(false);

            // Set colour information
            String cName = pullRule(theRules, COLOUR).toLowerCase();
            
            if (cName.charAt(0) == '#') {
                customColour.setText(cName);
            } else {
                // This is support for "legacy" triggers that
                // used the colour name instead of code
                customColour.setText(nameToCode(cName));
            }
            
            cName = pullRule(theRules, this.MATCHONLY).toLowerCase();
            if (DEBUG) {
                System.err.println("TriggerGUI.SetupRules reads our MATCHONLY variable as *" + cName + "*");
            }
            if (cName.equals("true")) {
                if (DEBUG) {
                    System.err.println("TriggerGUI.SetupRules setting matchOnlyCheck to true");
                }
                matchOnlyCheck.setState(true);
            } else {
                if (DEBUG) {
                    System.err.println("TriggerGUI.SetupRules setting matchOnlyCheck to false");
                }
                matchOnlyCheck.setState(false);
            }
            // This is a custom colour
            customColour.setEnabled(true);
            colourButton.setEnabled(true);
            
        }
        
        // Fill in the media information
        final String text = pullRule(theRules, MEDIA);
        if (text.equals("None")) {
            mediaPath.setText("");
            mediaCheck.setState(false);
            setMediaState(false);
        } else {
            mediaPath.setText(text);
            mediaCheck.setState(true);
            setMediaState(true);
        }
        
        refreshRules();
        
        // For the convenience of the user, select the first rule
        ruleList.select(0);
        showRuleWord(0);
        
    }
    
    /** Toggle the state of the "media"-related widgets.  This
     * would generally be a simple matter but for the fact that
     * they are also controlled by the "GAG" checkbox
     */
    private void setMediaState(final boolean stat) {
        if (gagCheck.getState()) {
            mediaCheck.setEnabled(false);
            mediaPath.setEnabled(false);
            mediaButton.setEnabled(false);
        } else {
            mediaCheck.setEnabled(true);
            mediaPath.setEnabled(stat);
            mediaButton.setEnabled(stat);
        }
    }
    
    /** Parse the set of rules, writing it out
     * to our list
     */
    private void refreshRules() {
        // Get the number of rules that we're dealing with
        String ruleType, cleanType, tag;
        final int num = Integer.parseInt(pullRule(theRules, RULES));
        if (num < 1) {
            return;// This shouldn't happen... but y'never know
        }
        
        ruleList.removeAll();
        for (int i = 0; i < num; i++) {
            ruleType = pullRule(theRules, "$" + i + ":");
            cleanType = ruleType.substring(0, ruleType.indexOf(":"));
            tag = (ruleType.substring(ruleType.indexOf(":") + 1));
            
            
            if (cleanType.toLowerCase().equals(andStr)) {
                cleanType = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND");
            }
            
            if (cleanType.toLowerCase().equals(notStr)) {
                cleanType = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT");
            }
            
            if (cleanType.toLowerCase().equals(modStr)) {
                cleanType = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER");
            }
            
            ruleList.add(cleanType + " -> " + tag);
        }
    }
    
    /** Set up our ruleWord textArea and associated "choice"
     */
    private void showRuleWord(final int selected) {
        String ruleType, tag, typeName;
        ruleType = new String(pullRule(theRules, "$" + selected + ":"));
        tag = (ruleType.substring(ruleType.indexOf(":") + 1));
        typeName = ruleType.substring(0, ruleType.indexOf(":"));
        
        if (DEBUG) {
            System.err.println("showRuleWord typeName: " + typeName);
        }
        
        ruleOption.select(typeToTrans(typeName));
        ruleWord.setText(tag);
    }
    
    /** Add an additional subrule to an existing rule */
    private void addNewSubRule() {
        final int rules = Integer.parseInt(pullRule(theRules, RULES));
        final StringBuffer workString = new StringBuffer(RULES + (rules + 1));
        
        for (int i = 0; i < rules; i++) {
            workString.append("$" + i + ":" + (pullRule(theRules, "$" + i + ":")));
        }
        
        workString.append("$" + (rules) + ":" + "AND:blank");
        
        // Now, glean the rest of the info from out dialogues
        workString.append(COLOUR);
        workString.append(pullRule(theRules, COLOUR));

        workString.append(LAUNCH);
        workString.append(pullRule(theRules, LAUNCH));

        workString.append(MEDIA);
        workString.append(pullRule(theRules, MEDIA));

        workString.append(NAME);
        workString.append(pullRule(theRules, RULENAME));

        workString.append(DONE);
        
        theRules = workString.toString();
        refreshRules();
        ruleList.select(rules);
        showRuleWord(rules);
    }
    
    /** Delete a subrule from our current set of working rules. */
    private void deleteSubRule(final int ruleIndex) {
        int count = 0;
        final int rules = Integer.parseInt(pullRule(theRules, RULES));
        final StringBuffer workString = new StringBuffer(RULES + (rules - 1));
        
        for (int i = 0; i < rules; i++) {
            if (i != ruleIndex) {
                workString.append("$" + count + ":" + (pullRule(theRules, "$" + i + ":")));
                count++;
            }
        }
        
        // Now, glean the rest of the info from out dialogues
        // workString.append("$COLOUR:");
        workString.append(COLOUR);
        workString.append(pullRule(theRules, COLOUR));

        // workString.append("$LAUNCH:");
        workString.append(LAUNCH);
        workString.append(pullRule(theRules, LAUNCH));

        // workString.append("$MEDIA:");
        workString.append(MEDIA);
        workString.append(pullRule(theRules, MEDIA));

        // workString.append("$NAME:");
        workString.append(NAME);
        workString.append(pullRule(theRules, RULENAME));

        // workString.append("$DONE");
        workString.append(DONE);
        
        // Finished building the new rule, now we'll put it back in
        // into the "main array"
        theRules = workString.toString();
        refreshRules();
    }
    
    /** Modify an existing rule */
    private void updateRule() {
        final int item = ruleList.getSelectedIndex();
        
        if (ruleList.getSelectedItem() == null || ruleWord.getText().equals("")) {
            return;
        }
        
        changeRule(item, ruleOption.getSelectedItem(), ruleWord.getText());
        refreshRules();
        ruleList.select(item);
    }
    
    /** Show a file-selection dialogue and the insert the results
     * from the selection into the proper location
     */
    private void selectFile(final java.awt.TextField text, final String oldPath) {
        
        final java.awt.FileDialog fileChooser = new java.awt.FileDialog(this, "Select a file", java.awt.FileDialog.LOAD);
        
        if (!oldPath.equals("")) {
            fileChooser.setFile(oldPath);
        }
        
        fileChooser.setVisible(true);
        
        if (fileChooser.getFile() != null && fileChooser.getFile() != "") {
            text.setText(fileChooser.getDirectory() + fileChooser.getFile());
        }
        
    }
    
    /** Modify a given rule.*/
    private void changeRule(final int item, final String option, final String ruleWord) {
        final int rules = Integer.parseInt(pullRule(theRules, RULES));
        final StringBuffer workString = new StringBuffer(RULES + rules);
        
        for (int i = 0; i < rules; i++) {
            if (i == item) {
                // This is the rule we change
                workString.append("$" + i + ":" + transToType(option, true) + ":" + ruleWord);
            } else {
                workString.append("$" + i + ":" + (pullRule(theRules, "$" + i + ":")));
            }
        }
        
        workString.append(COLOUR + (pullRule(theRules, COLOUR)));
        workString.append(LAUNCH + (pullRule(theRules, LAUNCH)));
        workString.append(MEDIA + (pullRule(theRules, MEDIA)));
        workString.append(NAME + (pullRule(theRules, RULENAME)));
        workString.append(DONE);
        
        // Copy this as our new working rule, and then update the display
        theRules = workString.toString();
    }
    
    /** Write out our new rule in the proper format and
     * then update the main window */
    private void writeNewRule() {
        final int rules = Integer.parseInt(pullRule(theRules, RULES));
        final StringBuffer workString = new StringBuffer(RULES + rules);
        
        for (int i = 0; i < rules; i++) {
            workString.append("$" + i + ":" + (pullRule(theRules, "$" + i + ":")));
        }
        
        // Now, glean the rest of the info from out dialogues
        workString.append(COLOUR);
        if (gagCheck.getState()) {
            workString.append("GAG");
        } else {
            // Check whether we have a custom colour or not
            final String cusColour = customColour.getText();
            if (cusColour.length() >= 6 && cusColour.length() <= 7) {
                if (cusColour.length() == 6) {
                    workString.append("#" + customColour.getText());
                } else {
                    workString.append(customColour.getText());
                }
            } else {
                workString.append("#ffffff");
            }
            
            if (matchOnlyCheck.getState()) {
                workString.append(MATCHONLY);
                workString.append("true");
            }
        }

        workString.append(LAUNCH);
        workString.append("None");
        
        workString.append(MEDIA);
        if (mediaCheck.getState() && !mediaPath.getText().equals("")) {
            workString.append(mediaPath.getText());
        } else {
            workString.append("None");
        }

        workString.append(NAME);
        workString.append(ruleSetName.getText());

        workString.append(DONE);
        
        // Finished building the new rule, now we'll put it back in
        // into the "main array"
        int ruleIndex = ruleNameChoice.getSelectedIndex();
        
        if (ruleIndex < 0) {
            if (DEBUG) {
                System.err.println("ruleNameChoice.getSelectedIndex() is less than zero.");
            }
            ruleIndex = 0;
        }
        
        if (DEBUG) {
            System.err.println("ruleNameChoice selectedIndex: " + ruleNameChoice.getSelectedIndex());
            System.err.println("workString: " + workString.toString());
        }
        
        mainRules.setElementAt(workString.toString(), ruleIndex);
        setChoices();
        ruleNameChoice.select(pullRule(workString.toString(), RULENAME));
        editAddRule(ruleNameChoice.getSelectedIndex());
    }
    
    private void changeOptionStates(final boolean state) {
        customColourCheck.setEnabled(state);
        customColour.setEnabled(state);
        colourButton.setEnabled(state);
        mediaCheck.setEnabled(state);
        mediaPath.setEnabled(state);
        mediaButton.setEnabled(state);
        matchOnlyCheck.setEnabled(state);
    }
    
    /** convert standard colour names to hex codes */
    private String nameToCode(final String oldName) {
        final String compName = oldName.toLowerCase();
        String retName = "#ffffff";
        
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("black"))) {
            retName = "#000000";
        }
        
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("cyan"))) {
            retName = "#00ffff";
        }
        
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("dark_gray"))) {
            retName = "#a9a9a9";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("gray"))) {
            retName = "#808080";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("green"))) {
            retName = "#00ff00";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("light_gray"))) {
            retName = "#dcdcdc";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("magenta"))) {
            retName = "#ff00ff";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("orange"))) {
            retName = "#ffa500";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("pink"))) {
            retName = "#ffc0cb";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("red"))) {
            retName = "#ff0000";
        }
        if (compName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("yellow"))) {
            retName = "#ffff00";
        }
        
        return retName;
    }
    
    /** Do a look-up from a rule to it's language translation */
    private String typeToTrans(final String rule) {
        String retTrans = "";
        final String lowerRule = rule.toLowerCase();
        
        if (lowerRule.equals("and")) {
            retTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("AND");
        }
        
        if (lowerRule.equals("modifier")) {
            retTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("MODIFIER");
        }
        
        if (lowerRule.equals("not")) {
            retTrans = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TriggerDir/TriggerBundle").getString("NOT");
        }
        
        return retTrans;
    }
    
    /** Do a look-up from a language translation to its rule */
    private String transToType(final String trans, final boolean upper) {
        String retType = "";
        String lowerTrans = "";
        final int cpos = trans.indexOf(":");
        
        // Remove any markings if this is still part of our rule
        if (cpos > -1) {
            lowerTrans = trans.substring(0, cpos).toLowerCase();
        } else {
            lowerTrans = trans.toLowerCase();
        }
        
        if (lowerTrans.equals(andTrans) || lowerTrans.equals(andStr)) {
            retType = andStr;
        }
        
        if (lowerTrans.equals(notTrans) || lowerTrans.equals(notStr)) {
            retType = notStr;
        }
        
        if (lowerTrans.equals(modTrans) || lowerTrans.equals(modStr)) {
            retType = modStr;
        }
        
        if (upper) {
            retType = retType.toUpperCase();
        }
        
        return retType;
    }
    
    /** This method is over-ridden
     * @param state true sets our frame visible, false sets our frame hidden
     */
    public void setVisible(final boolean state) {
        if (DEBUG) {
            System.err.println("TriggerGUI setVisible called.");
        }
        
        ((java.awt.CardLayout)this.getLayout()).first(this);
        super.setVisible(state);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.TextArea activationEx;
    private java.awt.Button addRuleButton;
    private java.awt.Button cancelButton;
    private java.awt.Button colourButton;
    private java.awt.TextField customColour;
    private java.awt.Checkbox customColourCheck;
    private java.awt.Button deleteRuleButton;
    private java.awt.Button editButton;
    private java.awt.Checkbox gagCheck;
    private java.awt.Checkbox highlightCheck;
    private java.awt.Label label1;
    private java.awt.Label label2;
    private java.awt.Label label3;
    private java.awt.Label label4;
    private java.awt.Checkbox matchOnlyCheck;
    private java.awt.Button mediaButton;
    private java.awt.Checkbox mediaCheck;
    private java.awt.TextField mediaPath;
    private java.awt.Button newRuleButton;
    private java.awt.Button okayButton;
    private java.awt.Button removeRuleButton;
    private java.awt.Panel ruleDetailsPanel;
    private java.awt.List ruleList;
    private java.awt.Panel ruleListPanel;
    java.awt.Choice ruleNameChoice;
    private java.awt.Choice ruleOption;
    private java.awt.Button ruleSetCancel;
    private java.awt.TextField ruleSetName;
    private java.awt.TextField ruleWord;
    private java.awt.Button saveRulesButton;
    // End of variables declaration//GEN-END:variables
    
    private static java.util.Vector mainRules = new java.util.Vector(0, 1);
    private static java.util.Vector originalRules = new java.util.Vector(0, 1);
    
    private boolean inProcess = false;	// this stops multiple instances of the dialogue box
    private boolean editing = false;
    private String theRules;
    
    private static final String RULES = "$RULES:";
    private static final String RULENAME = "$NAME:";
    private static final String COLOUR = "$COLOUR:";
    private static final String LAUNCH = "$LAUNCH:";
    private static final String MATCHONLY = "$MATCHONLY:";
    private static final String MEDIA = "$MEDIA:";
    private static final String NAME = "$NAME:";
    private static final String DONE = "$DONE:";
    
    private static final boolean DEBUG = false;
    
    private static final String andStr ="and";
    private static final String notStr = "not";
    private static final String modStr = "modifier";
    private static String andTrans;
    private static String notTrans;
    private static String modTrans;
    
    private static TriggerGUI _instance;  // We'll try playing with a Singleton!
    private anecho.JamochaMUD.plugins.Trigger parentClass;
    
}
