/**
 * Bowsah is a small API to allow "platform independant"
 * control of web browsers.
 * $Id: Bowsah.java,v 1.3 2002/07/23 03:58:04 jeffnik Exp $
 */


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.extranet;

import java.net.URL;

/**
 * Bowsah is a small API to allow "platform independent" control of
 * web browsers.
 */
public class Bowsah {
    
    // Our variables
    Process bProc;            // The browser process
    boolean newBrowser;       // whether to create a new browser process
    String browser;           // our chosen web browser
    private static final boolean DEBUG = false;
    
    // Our constructors
    /**
     *
     * @param browser
     */
    public Bowsah(String browser) {
        this(browser, "");
    }
    
    /**
     *
     * @param browser
     * @param newBrowser
     */
    public Bowsah(String browser, boolean newBrowser) {
        this(browser, "", newBrowser);
    }
    
    /**
     *
     * @param browser
     * @param URL
     */
    public Bowsah(String browser, String URL) {
        this(browser, URL, true);
    }
    
    /**
     *
     * @param browser
     * @param URL
     * @param newBrowser
     */
    public Bowsah(String browser, String URL, boolean newBrowser) {
        this.browser = browser;
        this.newBrowser = newBrowser;
        displayURL(URL);
    }
    
    // Our methods (and our madness)!
    /**
     * Display this new &quot;Location" in our browser
     * @param url 
     */
    public void displayURL(final String url) {
        
        // Attempt to launch the browser via Reflection
        // if this fails, we'll do it the "manual" way.
        Object serviceObj;
        // Class serviceObj;
        
        try  {
            
            final Class serviceManagerClass = Class.forName( "javax.jnlp.ServiceManager" );
            final java.lang.reflect.Method lookupMethod = serviceManagerClass.getMethod("lookup", new Class [ ] { String.class } );
            
            // return lookupMethod.invoke (null, new Object [ ] { "javax.jnlp.BasicService" } );
            serviceObj = lookupMethod.invoke(null, new Object [ ] { "javax.jnlp.BasicService" } );
            
            final Class basicServiceClass = Class.forName( "javax.jnlp.BasicService" );
            
            final java.lang.reflect.Method method = basicServiceClass.getMethod("showDocument", new Class [ ] { URL.class } );
            
            // final Boolean resultBoolean = ( Boolean ) method.invoke(serviceObj, new Object [ ] { url } );
            method.invoke(serviceObj, new Object [ ] { url } );
            
            // return resultBoolean.booleanValue( );
            return;
            
        } catch ( Exception  ex ) {
            
            //  return null;
            if (DEBUG) {
                System.err.println("Failed to capture BasicService" + ex);
                System.err.println("Trying fall-back method");
            }
            
            this.openURL(url);
            
        }
        
        
        
        
        
        
//        // check to see if our browser is currently running
//        if (bProc == null) {
//            // if it is not running, make sure we are allowed to start it.
//            if (newBrowser) {
//                // Yay!  Let's start a new browser first!!
//                startNewBrowser(URL);
//                return;
//            } else {
//                System.out.println("We need to start a new browser, but are not allowed to.");
//                return;  // Since we're not allowed to start a browser, we quit
//            }
//        }
//
//        // We we can go about displaying our chosen URL
//        System.out.println("Display URL in existing browser.");
//        String userDirectory = new String("");
//        java.util.Properties systemData = System.getProperties();
//        String osName = new String(systemData.getProperty("os.name"));
//
//        String pathSeparator = new String(java.io.File.separator);
//        String sCurrentWorkingDir = new String(systemData.getProperty("user.dir") + pathSeparator);
//        if ((osName.toLowerCase()).startsWith("windows")) {
//            System.out.println("We have a windows machine.  There is a generic way of doing this.");
//            try {
//                Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + URL);
//            } catch(Exception e) {
//                System.out.println("Bowsah: There was a problem with the Windows method " + e);
//            }
//            return;
//
//        } else {
//            // This is where the fun comes in, differentiating between systems
//            // end then finding the way *they* implement this feature
//            if (osName.startsWith("OS/2")) {
//                System.out.println("This is hard-coded for netscdde.  Anyone know a better way?");
//                try {
//                    // -q starts netscdde in quiet mode
//                    // -X starts Netscape without prompting, if necessary
//                    Process p = Runtime.getRuntime().exec("netscdde.exe -q -X " + URL);
//                } catch(Exception e) {
//                    System.out.println("Bowsah... OS/2 can't find netscdde or something. " + e);
//                }
//                return;
//            }
//
//            // if the system is a Unix/Linux system, well do it this
//            // way... the problem is right now we'll assume they're using Netscape
//            startNewBrowser("-remote \"openURL(" + URL + ")\"");
//
//        }
        
        
    }
    
    /**
     * 
     * @param url 
     */
    public static void openURL(final String url) {
        final String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                final Class macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                final java.lang.reflect.Method openURL = macUtils.getDeclaredMethod("openURL", new Class[] {String.class});
                openURL.invoke(null, new Object[] {url});
            } else {
                if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    //assume Unix or Linux
                    final String[] browsers = { "firefox", "opera", "konqueror", "mozilla", "netscape" };
                    String browser = null;
                    for (int count = 0; count < browsers.length && browser == null; count++) {
                        if (Runtime.getRuntime().exec( new String[] {"which", browsers[count]}).waitFor() == 0) {
                            browser = browsers[count];
                            if (browser == null) {
                                throw new Exception("Could not find web browser.");
                            } else {
                                Runtime.getRuntime().exec(new String[] {browser, url});
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            javax.swing.JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.getLocalizedMessage());
        }
    }

/** Start a new browser because we ain't got one yet */
private void startNewBrowser(final String URL) {
    System.out.println("Attempting to start new browser.");
    try {
        bProc = Runtime.getRuntime().exec(browser + " " + URL);
    } catch (Exception e) {
        System.out.println("Bowsah.StartNewBrowser failed.  Error: " + e);
    }
}

/**
 * This will return the Process that
 * we are using for our browser
 * @return 
 */
public Process getProcess() {
    return bProc;
}

/**
 * Toggle whether a request will start a new browser
 * if one doesn't exist
 * @param newBrowser 
 */
public void newBrowser(final boolean newBrowser) {
    this.newBrowser = newBrowser;
}

        }