/** Message Format takes in a String message and
 * reformats it to certain line lengths (using the \n character).
 * This can be quite helpful in use with JOptionPane messages
 * and the like
 * $Id: AbstractMessageFormat.java,v 1.2 2004/08/03 02:17:38 jeffnik Exp $
 */

package anecho.gui;

import java.util.StringTokenizer;

/**
 * Simple line formatting methods
 */
public abstract class AbstractMessageFormat {

    private static int standWrap = 40; // Standard amount of wrap if none is supplied
    private static final boolean DEBUG = false;

    /** An empty constructor! */
    private AbstractMessageFormat() {
    }

    /**
     * Wrap the input we're given at the interval suggested by standWrap
     * @param input The string to be modified by the line wrap.
     * @return The new string that contains the extra new-line escapes.
     */
    public static String wrap(final String input) {
        return wrap(input, standWrap);
    }

    /**
     * Take the input we're given and wrap at the user-defined intervals
     * @param input The string to be modified by the line wrap.
     * @param len The maximum number of characters per line
     * @return The new string that contains the extra new-line escapes.
     */
    public static String wrap(final String input, final int len) {
        int lines = 1;
        String temp;
        final StringBuffer output = new StringBuffer();
        StringBuffer workBuf = new StringBuffer();

        final StringTokenizer strTok = new StringTokenizer(input, " ", true);

        while (strTok.hasMoreTokens()) {
            temp = strTok.nextToken();

            if ((workBuf.length() + temp.length()) >= len) {
                output.append(workBuf.toString());
                output.append("\n");
                workBuf = new StringBuffer();
                lines++;

                // Just to make things look a little nicer, we'll see if this element
                // starts with a space and lop it off if so.
                // if (temp.startsWith(" ")) {
                if (temp.charAt(0) == ' ') {
                    if (DEBUG) {
                        System.err.println("Truncating token: " + temp);
                    }

                    final int tempLen = temp.length();

                    if (tempLen > 1) {
                        temp = temp.substring(1, temp.length() - 1);
                    } else {
                        temp = "";
                    }
                }
            }

            workBuf.append(temp);
            // output.append(temp);

        }

        // Now catch the last little bit of our work buffer
        output.append(workBuf.toString());

        if (DEBUG) {
            System.err.println("Our final string is: " + output.toString());
        }

        return output.toString();
    }
}
