/**
 * SplashScreen creates easy (AND FUN!) splash screens for programs
 * $Id: SplashScreen.java,v 1.1 2004/02/29 23:59:33 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2004  Jeff Robinson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

package anecho.gui;

import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Frame;

import javax.swing.JWindow;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

/**
 * SplashScreen creates easy (AND FUN!) splash screens for programs
 */
public class SplashScreen extends JWindow {

    JLabel messageLabel;

    /**
     * Create a blank SplashScreen
     * @param parent 
     */
    public SplashScreen(Frame parent) {
        this(parent, "", (ImageIcon)null);
    }

    /**
     * Create a SplashScreen with an initial message
     * @param parent 
     * @param message 
     */
    public SplashScreen(Frame parent, String message) {
        this(parent, message, (ImageIcon)null);
    }

    /**
     * Create a SplashScreen with an initial message and an imageFile
     * @param parent 
     * @param message 
     * @param imageFile 
     */
    public SplashScreen(Frame parent, String message, ImageIcon imageFile) {
        super(parent);

        Dimension labelSize = new Dimension(2, 2);

        if (imageFile != null) {
            JLabel picture = new JLabel(imageFile);
            getContentPane().add(picture, BorderLayout.CENTER);
            labelSize = picture.getPreferredSize();
        }

        if (message != null && !message.equals("")) {
            messageLabel = new JLabel(message);
            getContentPane().add(messageLabel, BorderLayout.SOUTH);
        }

        pack();

        Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setLocation(screenSize.width/2 - (labelSize.width/2),
                    screenSize.height/2 - (labelSize.height/2));
    }

    /**
     * Update an existing message on the splash screen
     * @param message 
     */
    public synchronized void updateMessage(final String message) {
        if (messageLabel != null) {
            messageLabel.setText(message);
        }
    }
}