/*
 * TextUtils.java
 *
 * Created on October 28, 2005, 10:33 PM
 *
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package anecho.gui;

/**
 *
 * @author jeffnik
 */
public class TextUtils {
    
    private static final char BELL = '7';
    private static final boolean DEBUG = false;
    
    /** Creates a new instance of TextUtils */
    private TextUtils() {
    }
    
    /**
     * This method returns the value of a string
     * once it has had any escape characters stripped
     * from it.
     * @param token 
     * @param useBell 
     * @return 
     */
    public static synchronized String stripEscapes(final String token, final boolean useBell) {
        final StringBuffer workString = new StringBuffer("");
        boolean loop = true;
        int start = 0;
        int end = 0;
        final int tLen = token.length();
        
        do {
            // Look for the next escape character
            end = token.indexOf('\u001b', start);
            
            // if (end < start && start < 0) {
            if (start < 0) {
                // There are no escapes left
                    System.out.println("We break to avoid an index error.");
                    break;
            }
            
            if (end < start) {
                workString.append(token.substring(start));
                loop = false;
                break;
            }
            
            // if (end > 0 && start >= 0) {
            if (end > 0) {
                workString.append(token.substring(start, end));
            }
            
            // Now set the new 'start'
            start = token.indexOf('m', end) + 1;
            
            if (start <= end) {
                loop = false;
                if (start < 0) {
                    System.out.println("We don't have an 'm' to end our ANSI escape.  We may not have received it yet.");
                } else {
                    // Check for BELL character (this is probably an ugly place to stick this Fix Me XXX)
                    if (token.charAt(1) == BELL && useBell) {
                        java.awt.Toolkit.getDefaultToolkit().beep();
                        if (DEBUG) {
                            System.out.println("Start: " + start + " end: " + end);
                        }
                        start = 2;
                        if (end == 0 && tLen > 2) {
                            // There are no more escapes, so we'll just add the remainder of the string
                            workString.append(token.substring(2));
                        }
                        
                        break;
                    } else {
                        if (DEBUG) {
                            System.out.println("Not a proper ANSI escape");
                            
                            for (int i = 0; i < tLen; i++) {
                                System.out.print("*" + token.charAt(i) + "*");
                            }
                        }
                        break;
                    }
                }
                
            }
            
            // Check to see if we've reached the end of our token.  If this is
            // the case, then we can end the loop and return what we've got so far.
            if (start >= tLen) {
                loop = false;
                break;
            }
        } while (loop);
        
        return workString.toString();
    }
    
    
}
