/* HotJava 1.0 Object Maker for OS/2 Warp with JDK 1.1.1 */
/* By Samuel Audet <guardia@cam.org>                     */

call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'
javaexe = translate(syssearchpath('PATH','JAVA.EXE'))
if javaexe = '' then do
   say 'No Java runtime installed at all!  Aborting'
   exit
end
parse var javaexe java11dir '\BIN'

parse arg parm
parm = strip(parm)
if parm <> '' then java11dir = parm
if lastpos('\',java11dir) = length(java11dir) then java11dir = left(java11dir,length(java11dir) - 1)
java11dir = strip(java11dir)

say 'HotJava 1.0 Object Maker for OS/2 Warp with JDK 1.1.1'
say 'By Samuel Audet <guardia@cam.org>'
say
say 'Making Program Object for HotJava 1.0 with' java11dir '...'
say 'This directory MUST contain OS/2 Java JDK 1.1.  If that is not the case,'
say 'specify the apropriate directory on the command line. And no, don''t try'
say 'it, it won''t run with JDK 1.0.'

/* Change to executed directory */
parse source . . sourcename
sourcedir = filespec('D', sourcename)||filespec('P', sourcename)
sourcedir = delstr(sourcedir, length(sourcedir))
call directory sourcedir

/* finding home dir */
parse var sourcedir hotjavahome '\bin'

/* What are those? -noasyncgc -ms4m -mx32m */

classname='WPProgram'
title='HotJava 1.0'
location='<WP_DESKTOP>'
setup='OBJECTID=<HOT_JAVA>;'||,
      'EXENAME='java11dir'\BIN\JAVA.EXE;'||,
      'ICONFILE='sourcedir'\hotjava.ico;'||,
      'PARAMETERS=-classpath 'java11dir'\lib\classes.zip^;'hotjavahome'\lib\classes.zip^;'hotjavahome'\lib\ssl.zip -noasyncgc -ms4m -mx32m -Dhotjava.home='hotjavahome' sun.hotjava.Main;'
say 'Creating Object: 'title
result = SysCreateObject(classname, title, location, setup, 'R')
If result > 1 Then say 'Error: Object not created. Return code='result


 

