/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;

public class LruHashtable
extends Hashtable {
    private static final int nBuckets = 2;
    private float loadFactor;
    private int threshold;
    private int eachCapacity;
    private Hashtable oldTable;
    private Hashtable newTable;

    public int size() {
        return this.newTable.size() + this.oldTable.size();
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized Enumeration keys() {
        return new LruHashtableEnumerator(this.oldTable, this.newTable, true);
    }

    public synchronized Enumeration elements() {
        return new LruHashtableEnumerator(this.oldTable, this.newTable, false);
    }

    public synchronized boolean contains(Object object) {
        if (this.newTable.contains(object)) {
            return true;
        }
        return this.oldTable.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        if (this.newTable.containsKey(object)) {
            return true;
        }
        if (this.oldTable.containsKey(object)) {
            Object v = this.oldTable.get(object);
            this.newTable.put(object, v);
            this.oldTable.remove(object);
            return true;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        Object v = this.newTable.get(object);
        if (v != null) {
            return v;
        }
        v = this.oldTable.get(object);
        if (v != null) {
            this.newTable.put(object, v);
            this.oldTable.remove(object);
            return v;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3 = this.newTable.put(object, object2);
        if (object3 != null) {
            return object3;
        }
        object3 = this.oldTable.get(object);
        if (object3 != null) {
            this.oldTable.remove(object);
        } else if (this.size() >= this.threshold) {
            this.oldTable = this.newTable;
            this.newTable = new Hashtable(this.eachCapacity, this.loadFactor);
        }
        return object3;
    }

    public synchronized Object remove(Object object) {
        Object v = this.newTable.remove(object);
        if (v == null) {
            v = this.oldTable.remove(object);
        }
        return v;
    }

    public synchronized void clear() {
        this.newTable.clear();
        this.oldTable.clear();
    }

    public synchronized Object clone() {
        LruHashtable lruHashtable = (LruHashtable)super.clone();
        lruHashtable.newTable = (Hashtable)lruHashtable.newTable.clone();
        lruHashtable.oldTable = (Hashtable)lruHashtable.oldTable.clone();
        return lruHashtable;
    }

    public LruHashtable(int n, float f) {
        super(1);
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f) - 1;
        this.eachCapacity = n / 2 + 1;
        this.oldTable = new Hashtable(this.eachCapacity, f);
        this.newTable = new Hashtable(this.eachCapacity, f);
    }

    public LruHashtable(int n) {
        this(n, 0.75f);
    }
}

