/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.awt.treeview;

import com.sfs.awt.treeview.Item;
import com.sfs.awt.treeview.RootFolder;
import com.sfs.awt.treeview.TreeViewException;
import com.sfs.debug.Debug;
import java.util.StringTokenizer;
import java.util.Vector;

public class Folder
extends Item {
    public Vector Root = new Vector();
    protected RootFolder Owner;

    protected Folder(RootFolder rootFolder, Folder folder, String string, Object object) {
        this(rootFolder, folder, string, object, 0);
    }

    protected Folder(RootFolder rootFolder, Folder folder, String string, Object object, int n) {
        super(rootFolder, folder, string, object);
        this.iconType = 0;
        this.Owner = rootFolder;
        this.iconType = n;
    }

    protected boolean isLastElement(Item item) {
        return this.Root.lastElement() == item;
    }

    public Folder addFolder(String string, Object object, int n) throws TreeViewException {
        Folder folder = null;
        folder = new Folder(this.Owner, this, string, object, n);
        this.add(folder);
        return folder;
    }

    public Folder addFolder(String string, Object object) throws TreeViewException {
        Folder folder = null;
        folder = new Folder(this.Owner, this, string, object);
        this.add(folder);
        return folder;
    }

    public Item addItem(String string, Object object, int n) throws TreeViewException {
        Item item = new Item(this.Owner, this, string, object, n);
        this.add(item);
        return item;
    }

    public Item addItem(String string, Object object) throws TreeViewException {
        Item item = new Item(this.Owner, this, string, object);
        this.add(item);
        return item;
    }

    public String toString() {
        String string = "[" + this.Name + "] = {";
        int n = 0;
        while (n < this.Root.size()) {
            string = String.valueOf(string) + this.Root.elementAt(n) + ", ";
            ++n;
        }
        return String.valueOf(string) + "}\n";
    }

    public int size() {
        return this.Root.size();
    }

    protected synchronized void add(Item item) throws TreeViewException {
        if (this.Owner.Sorter != null) {
            this.Owner.Sorter.doInsertionsort(this.Root, item);
            this.Owner.insertItem(item);
            return;
        }
        this.Root.addElement(item);
        this.Owner.insertItem2(item);
    }

    public void setOpen(boolean bl) {
        if (this.isOpen() != bl) {
            super.setOpen(bl);
            if (this.isOpen()) {
                Folder folder = this.Parent;
                while (folder != null) {
                    if (!folder.isOpen()) {
                        folder.setOpen(true);
                        return;
                    }
                    folder = folder.Parent;
                }
            }
        }
    }

    public Item getItem(int n) {
        return (Item)this.Root.elementAt(n);
    }

    public Item getItem(String string) throws TreeViewException {
        if (string.equals("/")) {
            return this;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return this.Search(stringTokenizer, this.Root);
    }

    public Item Search(StringTokenizer stringTokenizer, Vector vector) throws TreeViewException {
        String string = stringTokenizer.nextToken();
        int n = 0;
        while (n < vector.size()) {
            Item item = (Item)vector.elementAt(n);
            if (item instanceof Folder) {
                if (string.equals(((Folder)item).getName())) {
                    if (stringTokenizer.countTokens() > 0) {
                        return this.Search(stringTokenizer, ((Folder)item).Root);
                    }
                    return item;
                }
            } else if (string.equals(item.getName())) {
                return item;
            }
            ++n;
        }
        throw new TreeViewException(3);
    }

    public void removeItem(String string) throws TreeViewException {
        Folder folder;
        String string2;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            folder = (Folder)this.Search(stringTokenizer, this.Root);
        } else {
            folder = this;
            string2 = string;
        }
        try {
            this.Owner.removeItem(folder.getItem(string2));
            folder.Root.removeElement(folder.getItem(string2));
            return;
        }
        catch (TreeViewException treeViewException) {
            Debug.Info(treeViewException.getMessage());
            return;
        }
    }

    public Item lookup(String string) {
        int n = 0;
        while (n < this.Root.size()) {
            Item item = (Item)this.Root.elementAt(n);
            if (item.getName().equals(string)) {
                return item;
            }
            ++n;
        }
        return null;
    }
}

