/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf;

import entagged.audioformats.Tag;
import entagged.audioformats.asf.data.AsfHeader;
import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescription;
import entagged.audioformats.asf.data.ContentDescriptor;
import entagged.audioformats.asf.data.ExtendedContentDescription;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.io.AsfHeaderReader;
import entagged.audioformats.asf.util.ChunkPositionComparator;
import entagged.audioformats.asf.util.TagConverter;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.generic.AudioFileWriter;
import entagged.audioformats.generic.GenericTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class AsfFileWriter
extends AudioFileWriter {
    private void copy(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, long l) throws IOException {
        byte[] byArray = new byte[8192];
        long l2 = 0L;
        int n = -1;
        while ((n = randomAccessFile.read(byArray, 0, l2 + 8192L > l ? (int)(l - l2) : 8192)) > 0) {
            l2 += (long)n;
            randomAccessFile2.write(byArray, 0, n);
        }
    }

    private void createModifiedCopy(Tag tag, AsfHeader asfHeader, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, boolean bl) throws IOException {
        randomAccessFile.seek(0L);
        this.copy(randomAccessFile, randomAccessFile2, 30L);
        Chunk[] chunkArray = this.getOrderedChunks(asfHeader);
        long l = 0L;
        long l2 = asfHeader.getChunkCount();
        long l3 = -1L;
        if (asfHeader.getExtendedContentDescription() == null && this.isExtendedContentDescriptionMandatory(tag) && !bl) {
            ++l2;
            l += this.createNewExtendedContentDescription(tag, null, randomAccessFile2).getChunkLength().longValue();
        }
        if (asfHeader.getContentDescription() == null && this.isContentdescriptionMandatory(tag) && !bl) {
            ++l2;
            l += this.createNewContentDescription(tag, null, randomAccessFile2).getChunkLength().longValue();
        }
        for (int i = 0; i < chunkArray.length; ++i) {
            if (chunkArray[i] == asfHeader.getContentDescription()) {
                if (bl) {
                    --l2;
                    l -= asfHeader.getContentDescription().getChunkLength().longValue();
                    continue;
                }
                l += this.createNewContentDescription(tag, asfHeader.getContentDescription(), randomAccessFile2).getChunkLength().subtract(asfHeader.getContentDescription().getChunkLength()).longValue();
                continue;
            }
            if (chunkArray[i] == asfHeader.getExtendedContentDescription()) {
                if (this.deleteExtendedContentDescription(asfHeader.getExtendedContentDescription(), tag) || bl) {
                    --l2;
                    l -= asfHeader.getExtendedContentDescription().getChunkLength().longValue();
                    continue;
                }
                l += this.createNewExtendedContentDescription(tag, asfHeader.getExtendedContentDescription(), randomAccessFile2).getChunkLength().subtract(asfHeader.getExtendedContentDescription().getChunkLength()).longValue();
                continue;
            }
            if (GUID.GUID_FILE.equals(chunkArray[i].getGuid())) {
                l3 = randomAccessFile2.getFilePointer();
            }
            randomAccessFile.seek(chunkArray[i].getPosition());
            this.copy(randomAccessFile, randomAccessFile2, chunkArray[i].getChunkLength().longValue());
        }
        randomAccessFile.seek(asfHeader.getChunckEnd());
        this.copy(randomAccessFile, randomAccessFile2, randomAccessFile.length() - randomAccessFile.getFilePointer());
        randomAccessFile2.seek(24L);
        this.write16UINT(l2, randomAccessFile2);
        randomAccessFile2.seek(l3 + 40L);
        this.write32UINT(asfHeader.getFileHeader().getFileSize().longValue() + l, randomAccessFile2);
        randomAccessFile2.seek(16L);
        this.write32UINT(asfHeader.getChunkLength().longValue() + l, randomAccessFile2);
    }

    private Chunk createNewContentDescription(Tag tag, ContentDescription contentDescription, RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.getFilePointer();
        ContentDescription contentDescription2 = TagConverter.createContentDescription(tag);
        if (contentDescription != null) {
            contentDescription2.setRating(contentDescription.getRating());
        }
        byte[] byArray = contentDescription2.getBytes();
        randomAccessFile.write(byArray);
        return new Chunk(GUID.GUID_CONTENTDESCRIPTION, l, BigInteger.valueOf(byArray.length));
    }

    private Chunk createNewExtendedContentDescription(Tag tag, ExtendedContentDescription extendedContentDescription, RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.getFilePointer();
        if (extendedContentDescription == null) {
            extendedContentDescription = new ExtendedContentDescription();
        }
        TagConverter.assignCommonTagValues(tag, extendedContentDescription);
        TagConverter.assignOptionalTagValues(tag, extendedContentDescription);
        byte[] byArray = extendedContentDescription.getBytes();
        randomAccessFile.write(byArray);
        return new Chunk(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, l, BigInteger.valueOf(byArray.length));
    }

    private boolean deleteExtendedContentDescription(ExtendedContentDescription extendedContentDescription, Tag tag) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("WM/Genre", "WM/GenreID", "WM/TrackNumber", "WM/AlbumTitle", "WM/Year"));
        Iterator iterator = extendedContentDescription.getDescriptors().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            ContentDescriptor contentDescriptor = (ContentDescriptor)iterator.next();
            bl = !hashSet.contains(contentDescriptor.getName());
        }
        return !bl && !this.isExtendedContentDescriptionMandatory(tag);
    }

    protected void deleteTag(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        try {
            AsfHeader asfHeader = AsfHeaderReader.readHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new NullPointerException("Header is null, so file couldn't be read properly. (Interpretation of data, not file access rights.)");
            }
            this.createModifiedCopy(new GenericTag(), asfHeader, randomAccessFile, randomAccessFile2, true);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new CannotWriteException("Cannot modify tag because exception occured:\n   " + exception.getMessage());
        }
    }

    private Chunk[] getOrderedChunks(AsfHeader asfHeader) {
        int n;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (n = 0; n < asfHeader.getUnspecifiedChunkCount(); ++n) {
            arrayList.add(asfHeader.getUnspecifiedChunk(n));
        }
        for (n = 0; n < asfHeader.getStreamChunkCount(); ++n) {
            arrayList.add(asfHeader.getStreamChunk(n));
        }
        if (asfHeader.getContentDescription() != null) {
            arrayList.add(asfHeader.getContentDescription());
        }
        arrayList.add(asfHeader.getFileHeader());
        if (asfHeader.getExtendedContentDescription() != null) {
            arrayList.add(asfHeader.getExtendedContentDescription());
        }
        if (asfHeader.getEncodingChunk() != null) {
            arrayList.add(asfHeader.getEncodingChunk());
        }
        if (asfHeader.getStreamBitratePropertiesChunk() != null) {
            arrayList.add(asfHeader.getStreamBitratePropertiesChunk());
        }
        Chunk[] chunkArray = arrayList.toArray(new Chunk[arrayList.size()]);
        Arrays.sort(chunkArray, new ChunkPositionComparator());
        return chunkArray;
    }

    private boolean isContentdescriptionMandatory(Tag tag) {
        return tag.getFirstArtist().trim().length() > 0 || tag.getFirstComment().trim().length() > 0 || tag.getFirstTitle().trim().length() > 0;
    }

    private boolean isExtendedContentDescriptionMandatory(Tag tag) {
        return tag.getFirstTrack().trim().length() > 0 || tag.getFirstYear().trim().length() > 0 || tag.getFirstGenre().trim().length() > 0 || tag.getFirstAlbum().trim().length() > 0;
    }

    private int write16UINT(long l, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.write((int)l & 0xFF);
        randomAccessFile.write((int)(l >>= 8) & 0xFF);
        return 2;
    }

    private int write32UINT(long l, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.write((int)l & 0xFF);
        randomAccessFile.write((int)(l >>= 8) & 0xFF);
        randomAccessFile.write((int)(l >>= 8) & 0xFF);
        randomAccessFile.write((int)(l >>= 8) & 0xFF);
        return 4;
    }

    protected void writeTag(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        try {
            AsfHeader asfHeader = AsfHeaderReader.readHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new NullPointerException("Header is null, so file couldn't be read properly. (Interpretation of data, not file access rights.)");
            }
            this.createModifiedCopy(tag, asfHeader, randomAccessFile, randomAccessFile2, false);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new CannotWriteException("Cannot modify tag because exception occured:\n   " + exception.getMessage());
        }
    }
}

