/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.AsfHeader;
import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescription;
import entagged.audioformats.asf.data.EncodingChunk;
import entagged.audioformats.asf.data.ExtendedContentDescription;
import entagged.audioformats.asf.data.FileHeader;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.data.StreamBitratePropertiesChunk;
import entagged.audioformats.asf.data.StreamChunk;
import entagged.audioformats.asf.io.ChunkHeaderReader;
import entagged.audioformats.asf.io.ContentDescriptionReader;
import entagged.audioformats.asf.io.EncodingChunkReader;
import entagged.audioformats.asf.io.ExtContentDescReader;
import entagged.audioformats.asf.io.FileHeaderReader;
import entagged.audioformats.asf.io.StreamBitratePropertiesReader;
import entagged.audioformats.asf.io.StreamChunkReader;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class AsfHeaderReader {
    public static AsfHeader readHeader(RandomAccessFile randomAccessFile) throws IOException {
        AsfHeaderReader asfHeaderReader = new AsfHeaderReader();
        return asfHeaderReader.parseData(randomAccessFile);
    }

    protected AsfHeaderReader() {
    }

    private AsfHeader parseData(RandomAccessFile randomAccessFile) throws IOException {
        AsfHeader asfHeader = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_HEADER.equals(gUID)) {
            Chunk chunk;
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            long l2 = Utils.readUINT32(randomAccessFile);
            randomAccessFile.skipBytes(2);
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            while (bigInteger.compareTo(BigInteger.valueOf(randomAccessFile.getFilePointer())) > 0) {
                chunk = ChunkHeaderReader.readChunckHeader(randomAccessFile);
                arrayList.add(chunk);
                randomAccessFile.seek(chunk.getChunckEnd());
            }
            asfHeader = new AsfHeader(l, bigInteger, l2);
            chunk = null;
            ExtendedContentDescription extendedContentDescription = null;
            EncodingChunk encodingChunk = null;
            StreamChunk streamChunk = null;
            ContentDescription contentDescription = null;
            StreamBitratePropertiesChunk streamBitratePropertiesChunk = null;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Chunk chunk2 = (Chunk)iterator.next();
                if (chunk == null && (chunk = FileHeaderReader.read(randomAccessFile, chunk2)) != null || extendedContentDescription == null && (extendedContentDescription = ExtContentDescReader.read(randomAccessFile, chunk2)) != null || encodingChunk == null && (encodingChunk = EncodingChunkReader.read(randomAccessFile, chunk2)) != null) continue;
                if (streamChunk == null && (streamChunk = StreamChunkReader.read(randomAccessFile, chunk2)) != null) {
                    asfHeader.addStreamChunk(streamChunk);
                    streamChunk = null;
                    continue;
                }
                if (contentDescription == null && (contentDescription = ContentDescriptionReader.read(randomAccessFile, chunk2)) != null || streamBitratePropertiesChunk == null && (streamBitratePropertiesChunk = StreamBitratePropertiesReader.read(randomAccessFile, chunk2)) != null) continue;
                asfHeader.addUnspecifiedChunk(chunk2);
            }
            asfHeader.setFileHeader((FileHeader)chunk);
            asfHeader.setEncodingChunk(encodingChunk);
            asfHeader.setExtendedContentDescription(extendedContentDescription);
            asfHeader.setContentDescription(contentDescription);
            asfHeader.setStreamBitratePropertiesChunk(streamBitratePropertiesChunk);
        }
        return asfHeader;
    }
}

