/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.Tag;
import entagged.audioformats.generic.TagField;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractTagCreator {
    public ByteBuffer convert(Tag tag) throws UnsupportedEncodingException {
        return this.convert(tag, 0);
    }

    public ByteBuffer convert(Tag tag, int n) throws UnsupportedEncodingException {
        Tag tag2 = this.getCompatibleTag(tag);
        List list = this.createFields(tag2);
        int n2 = this.computeTagLength(tag2, list);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + n);
        this.create(tag2, byteBuffer, list, n2, n);
        byteBuffer.rewind();
        return byteBuffer;
    }

    protected List createFields(Tag tag) throws UnsupportedEncodingException {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        Iterator iterator = tag.getFields();
        while (iterator.hasNext()) {
            TagField tagField = (TagField)iterator.next();
            linkedList.add(tagField.getRawContent());
        }
        return linkedList;
    }

    protected int computeTagLength(Tag tag, List list) throws UnsupportedEncodingException {
        int n = this.getFixedTagLength(tag);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            n += ((byte[])iterator.next()).length;
        }
        return n;
    }

    public int getTagLength(Tag tag) throws UnsupportedEncodingException {
        Tag tag2 = this.getCompatibleTag(tag);
        List list = this.createFields(tag2);
        return this.computeTagLength(tag2, list);
    }

    protected abstract int getFixedTagLength(Tag var1) throws UnsupportedEncodingException;

    protected abstract Tag getCompatibleTag(Tag var1);

    protected abstract void create(Tag var1, ByteBuffer var2, List var3, int var4, int var5) throws UnsupportedEncodingException;
}

