/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.Tag;
import entagged.audioformats.mp3.Id3v1Tag;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class Id3v1TagCreator {
    private static Hashtable translateTable = new Hashtable(130);

    public ByteBuffer convert(Tag tag) throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.put((byte)84).put((byte)65).put((byte)71);
        this.put(byteBuffer, tag.getFirstTitle(), 30);
        this.put(byteBuffer, tag.getFirstArtist(), 30);
        this.put(byteBuffer, tag.getFirstAlbum(), 30);
        this.put(byteBuffer, tag.getFirstYear(), 4);
        if (tag.getTrack().size() != 0) {
            this.put(byteBuffer, tag.getFirstComment(), 28);
            byteBuffer.put((byte)0);
            int n = 0;
            try {
                n = Integer.parseInt(tag.getFirstTrack());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            byteBuffer.put((byte)n);
        } else {
            this.put(byteBuffer, tag.getFirstComment(), 30);
        }
        byteBuffer.put(this.translateGenre(tag.getFirstGenre()));
        byteBuffer.rewind();
        return byteBuffer;
    }

    private void put(ByteBuffer byteBuffer, String string, int n) throws UnsupportedEncodingException {
        int n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        byArray2 = this.truncate(string, n).getBytes("ISO-8859-1");
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray[n2] = byArray2[n2];
        }
        for (n2 = byArray2.length; n2 < n - byArray2.length; ++n2) {
            byArray[n2] = 0;
        }
        byteBuffer.put(byArray, 0, n);
    }

    private String truncate(String string, int n) {
        return string.length() > n ? string.substring(0, n) : string;
    }

    private byte translateGenre(String string) {
        Byte by = (Byte)translateTable.get(string.toLowerCase());
        if (by == null) {
            return -1;
        }
        return by;
    }

    static {
        for (int i = 0; i < Id3v1Tag.GENRES.length; ++i) {
            translateTable.put(Id3v1Tag.GENRES[i].toLowerCase(), new Byte((byte)i));
        }
    }
}

