/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.Id3v2TagCreator;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public abstract class Id3Frame
implements TagField {
    protected byte[] flags;
    protected byte version;

    public Id3Frame() {
        this.version = Id3v2Tag.ID3V23;
        this.createDefaultFlags();
    }

    public Id3Frame(byte[] byArray, byte by) throws UnsupportedEncodingException {
        byte[] byArray2;
        if (by == Id3v2Tag.ID3V23 || by == Id3v2Tag.ID3V24) {
            int n = 2;
            if ((byArray[1] & 0x80) == 128) {
                n = (byte)(n + 4);
            }
            if ((byArray[1] & 0x80) == 64) {
                n = (byte)(n + 1);
            }
            if ((byArray[1] & 0x80) == 32) {
                n = (byte)(n + 1);
            }
            this.flags = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.flags[i] = byArray[i];
            }
            byArray2 = byArray;
        } else {
            this.createDefaultFlags();
            byArray2 = new byte[this.flags.length + byArray.length];
            this.copy(this.flags, byArray2, 0);
            this.copy(byArray, byArray2, this.flags.length);
        }
        this.version = by;
        this.populate(byArray2);
    }

    protected abstract byte[] build() throws UnsupportedEncodingException;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void copy(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + n] = byArray[i];
        }
    }

    private void createDefaultFlags() {
        this.flags = new byte[2];
        this.flags[0] = 0;
        this.flags[1] = 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Id3Frame) {
            Id3Frame id3Frame = (Id3Frame)object;
            try {
                return Arrays.equals(this.build(), id3Frame.build());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return false;
    }

    protected byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = null;
        if ("UTF-16".equalsIgnoreCase(string2)) {
            byArray = string.getBytes("UTF-16LE");
            byte[] byArray2 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            byArray2[0] = -1;
            byArray2[1] = -2;
            byArray = byArray2;
        } else {
            byArray = string.getBytes(string2);
            int n = 1;
            if ("UTF-16BE".equals(string2)) {
                n = 2;
            }
            byte[] byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = byArray3;
        }
        return byArray;
    }

    public byte[] getFlags() {
        return this.flags;
    }

    public abstract String getId();

    protected byte[] getIdBytes() {
        return this.getId().getBytes();
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        return this.build();
    }

    protected byte[] getSize(int n) {
        byte[] byArray = null;
        byArray = this.version == Id3v2Tag.ID3V24 ? Id3v2TagCreator.getSyncSafe(n) : new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    protected String getString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if ("UTF-16".equalsIgnoreCase(string)) {
            int n3 = 0;
            if (byArray[n + n2 - 2] == 0 && byArray[n + n2 - 1] == 0) {
                n3 = 2;
            }
            string2 = byArray[n] == -2 && byArray[n + 1] == -1 ? new String(byArray, n + 2, n2 - 2 - n3, "UTF-16BE") : (byArray[n] == -1 && byArray[n + 1] == -2 ? new String(byArray, n + 2, n2 - 2 - n3, "UTF-16LE") : new String(byArray, n, n2 - n3, "UTF-16LE"));
        } else {
            int n4 = 0;
            if ("UTF-16BE".equals(string)) {
                if (byArray[n + n2 - 2] == 0 && byArray[n + n2 - 1] == 0) {
                    n4 = 2;
                }
            } else if (byArray[n + n2 - 1] == 0) {
                n4 = 1;
            }
            string2 = n2 == 0 || n + n2 > byArray.length ? "" : new String(byArray, n, n2 - n4, string);
        }
        return string2;
    }

    protected int indexOfFirstNull(byte[] byArray, int n) {
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public abstract boolean isBinary();

    public void isBinary(boolean bl) {
    }

    public abstract boolean isCommon();

    protected abstract void populate(byte[] var1) throws UnsupportedEncodingException;
}

